/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.key.protection.BaseSecretKeyRingProtector;
import org.pgpainless.key.protection.CachingSecretKeyRingProtector;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.UnprotectedKeysProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.key.protection.passphrase_provider.SolitaryPassphraseProvider;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\fH&J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\u0011\u00c0\u0006\u0003"}, d2={"Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "Lorg/bouncycastle/openpgp/api/KeyPassphraseProvider;", "getDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "keyId", "", "keyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "getEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "hasPassphraseFor", "", "Companion", "pgpainless-core"})
public interface SecretKeyRingProtector
extends KeyPassphraseProvider {
    @NotNull
    public static final Companion Companion = org.pgpainless.key.protection.SecretKeyRingProtector$Companion.$$INSTANCE;

    @kotlin.Deprecated(message="Pass in a KeyIdentifier instead.")
    default public boolean hasPassphraseFor(long keyId) {
        return this.hasPassphraseFor(new KeyIdentifier(keyId));
    }

    public boolean hasPassphraseFor(@NotNull KeyIdentifier var1);

    @kotlin.Deprecated(message="Pass in a KeyIdentifier instead.")
    @Nullable
    default public PBESecretKeyDecryptor getDecryptor(long keyId) throws PGPException {
        return this.getDecryptor(new KeyIdentifier(keyId));
    }

    @Nullable
    default public PBESecretKeyDecryptor getDecryptor(@NotNull OpenPGPKey.OpenPGPSecretKey key) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        KeyIdentifier keyIdentifier = key.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
        return this.getDecryptor(keyIdentifier);
    }

    @Nullable
    public PBESecretKeyDecryptor getDecryptor(@NotNull KeyIdentifier var1) throws PGPException;

    @Nullable
    default public PBESecretKeyEncryptor getEncryptor(@NotNull OpenPGPCertificate.OpenPGPComponentKey key) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PGPPublicKey pGPPublicKey = key.getPGPPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
        return this.getEncryptor(pGPPublicKey);
    }

    @Nullable
    public PBESecretKeyEncryptor getEncryptor(@NotNull PGPPublicKey var1) throws PGPException;

    @JvmStatic
    @NotNull
    public static CachingSecretKeyRingProtector defaultSecretKeyRingProtector(@Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
        return Companion.defaultSecretKeyRingProtector(missingPassphraseCallback);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockEachKeyWith(@NotNull Passphrase passphrase, @NotNull OpenPGPKey keys) {
        return Companion.unlockEachKeyWith(passphrase, keys);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockEachKeyWith(@NotNull Passphrase passphrase, @NotNull PGPSecretKeyRing keys) {
        return Companion.unlockEachKeyWith(passphrase, keys);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockAnyKeyWith(@NotNull Passphrase passphrase) {
        return Companion.unlockAnyKeyWith(passphrase);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, @NotNull PGPSecretKey key) {
        return Companion.unlockSingleKeyWith(passphrase, key);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, @NotNull OpenPGPKey.OpenPGPSecretKey key) {
        return Companion.unlockSingleKeyWith(passphrase, key);
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, @NotNull KeyIdentifier keyIdentifier) {
        return Companion.unlockSingleKeyWith(passphrase, keyIdentifier);
    }

    @JvmStatic
    @NotNull
    public static UnprotectedKeysProtector unprotectedKeys() {
        return Companion.unprotectedKeys();
    }

    @JvmStatic
    @NotNull
    public static SecretKeyRingProtector fromPassphraseMap(@NotNull Map<KeyIdentifier, Passphrase> passphraseMap) {
        return Companion.fromPassphraseMap(passphraseMap);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0007J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0007J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0007\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/key/protection/SecretKeyRingProtector$Companion;", "", "()V", "defaultSecretKeyRingProtector", "Lorg/pgpainless/key/protection/CachingSecretKeyRingProtector;", "missingPassphraseCallback", "Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;", "fromPassphraseMap", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "passphraseMap", "", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "Lorg/pgpainless/util/Passphrase;", "unlockAnyKeyWith", "passphrase", "unlockEachKeyWith", "keys", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "unlockSingleKeyWith", "keyIdentifier", "key", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "unprotectedKeys", "Lorg/pgpainless/key/protection/UnprotectedKeysProtector;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nSecretKeyRingProtector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecretKeyRingProtector.kt\norg/pgpainless/key/protection/SecretKeyRingProtector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1271#2,2:214\n1285#2,4:216\n1549#2:220\n1620#2,3:221\n1271#2,2:224\n1285#2,4:226\n*S KotlinDebug\n*F\n+ 1 SecretKeyRingProtector.kt\norg/pgpainless/key/protection/SecretKeyRingProtector$Companion\n*L\n116#1:214,2\n116#1:216,4\n134#1:220\n134#1:221,3\n134#1:224,2\n134#1:226,4\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CachingSecretKeyRingProtector defaultSecretKeyRingProtector(@Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
            return new CachingSecretKeyRingProtector(MapsKt.emptyMap(), KeyRingProtectionSettings.Companion.secureDefaultSettings(), missingPassphraseCallback);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockEachKeyWith(@NotNull Passphrase passphrase, @NotNull OpenPGPKey keys) {
            void $this$associateWith$iv;
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Iterable iterable = keys.getSecretKeys().keySet();
            Companion companion = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                KeyIdentifier keyIdentifier = (KeyIdentifier)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                Passphrase passphrase2 = passphrase;
                map.put(t, passphrase2);
            }
            return companion.fromPassphraseMap(result$iv);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockEachKeyWith(@NotNull Passphrase passphrase, @NotNull PGPSecretKeyRing keys) {
            void $this$associateWith$iv;
            KeyIdentifier it;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Iterable iterable = (Iterable)keys;
            Companion companion = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PGPSecretKey pGPSecretKey = (PGPSecretKey)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getKeyIdentifier());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                it = (KeyIdentifier)element$iv$iv;
                Object t = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                Passphrase passphrase2 = passphrase;
                object.put(t, passphrase2);
            }
            return companion.fromPassphraseMap(result$iv);
        }

        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockAnyKeyWith(@NotNull Passphrase passphrase) {
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            return new BaseSecretKeyRingProtector(new SolitaryPassphraseProvider(passphrase));
        }

        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, @NotNull PGPSecretKey key) {
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return PasswordBasedSecretKeyRingProtector.Companion.forKey(key, passphrase);
        }

        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, @NotNull OpenPGPKey.OpenPGPSecretKey key) {
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            PGPSecretKey pGPSecretKey = key.getPGPSecretKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKey, (String)"getPGPSecretKey(...)");
            return PasswordBasedSecretKeyRingProtector.Companion.forKey(pGPSecretKey, passphrase);
        }

        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector unlockSingleKeyWith(@NotNull Passphrase passphrase, @NotNull KeyIdentifier keyIdentifier) {
            Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
            Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
            return PasswordBasedSecretKeyRingProtector.Companion.forKeyId(keyIdentifier, passphrase);
        }

        @JvmStatic
        @NotNull
        public final UnprotectedKeysProtector unprotectedKeys() {
            return new UnprotectedKeysProtector();
        }

        @JvmStatic
        @NotNull
        public final SecretKeyRingProtector fromPassphraseMap(@NotNull Map<KeyIdentifier, Passphrase> passphraseMap) {
            Intrinsics.checkNotNullParameter(passphraseMap, (String)"passphraseMap");
            return new CachingSecretKeyRingProtector(passphraseMap, KeyRingProtectionSettings.Companion.secureDefaultSettings(), null);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @kotlin.Deprecated(message="Pass in a KeyIdentifier instead.")
        @Deprecated
        public static boolean hasPassphraseFor(@NotNull SecretKeyRingProtector $this, long keyId) {
            return $this.hasPassphraseFor(keyId);
        }

        @kotlin.Deprecated(message="Pass in a KeyIdentifier instead.")
        @Deprecated
        @Nullable
        public static PBESecretKeyDecryptor getDecryptor(@NotNull SecretKeyRingProtector $this, long keyId) throws PGPException {
            return $this.getDecryptor(keyId);
        }

        @Deprecated
        @Nullable
        public static PBESecretKeyDecryptor getDecryptor(@NotNull SecretKeyRingProtector $this, @NotNull OpenPGPKey.OpenPGPSecretKey key) throws PGPException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return $this.getDecryptor(key);
        }

        @Deprecated
        @Nullable
        public static PBESecretKeyEncryptor getEncryptor(@NotNull SecretKeyRingProtector $this, @NotNull OpenPGPCertificate.OpenPGPComponentKey key) throws PGPException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return $this.getEncryptor(key);
        }
    }
}

