/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0011\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\u0005B-\b\u0016\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0007J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\tJ\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0010\u0010+\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0018\u0010,\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0007J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010,\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\tR\u001c\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/pgpainless/key/protection/CachingSecretKeyRingProtector;", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;", "()V", "missingPassphraseCallback", "(Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;)V", "passphrases", "", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "Lorg/pgpainless/util/Passphrase;", "protectionSettings", "Lorg/pgpainless/key/protection/KeyRingProtectionSettings;", "(Ljava/util/Map;Lorg/pgpainless/key/protection/KeyRingProtectionSettings;Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;)V", "cache", "", "protector", "provider", "addPassphrase", "keyId", "", "passphrase", "keyIdentifier", "keyRing", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "cert", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "forgetPassphrase", "getDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "getEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "getKeyPassword", "", "p0", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "getPassphraseFor", "hasPassphrase", "", "hasPassphraseFor", "replacePassphrase", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nCachingSecretKeyRingProtector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingSecretKeyRingProtector.kt\norg/pgpainless/key/protection/CachingSecretKeyRingProtector\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n32#2,2:204\n32#2,2:206\n32#2,2:208\n32#2,2:211\n1#3:210\n*S KotlinDebug\n*F\n+ 1 CachingSecretKeyRingProtector.kt\norg/pgpainless/key/protection/CachingSecretKeyRingProtector\n*L\n108#1:204,2\n116#1:206,2\n126#1:208,2\n169#1:211,2\n*E\n"})
public final class CachingSecretKeyRingProtector
implements SecretKeyRingProtector,
SecretKeyPassphraseProvider {
    @NotNull
    private final Map<KeyIdentifier, Passphrase> cache;
    @NotNull
    private final SecretKeyRingProtector protector;
    @Nullable
    private final SecretKeyPassphraseProvider provider;

    public CachingSecretKeyRingProtector() {
        this(null);
    }

    public CachingSecretKeyRingProtector(@Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
        this(MapsKt.emptyMap(), KeyRingProtectionSettings.Companion.secureDefaultSettings(), missingPassphraseCallback);
    }

    public CachingSecretKeyRingProtector(@NotNull Map<KeyIdentifier, Passphrase> passphrases, @NotNull KeyRingProtectionSettings protectionSettings, @Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
        Intrinsics.checkNotNullParameter(passphrases, (String)"passphrases");
        Intrinsics.checkNotNullParameter((Object)protectionSettings, (String)"protectionSettings");
        this.cache = MapsKt.toMutableMap(passphrases);
        this.protector = new PasswordBasedSecretKeyRingProtector(protectionSettings, this);
        this.provider = missingPassphraseCallback;
    }

    @Deprecated(message="Pass KeyIdentifier instead.")
    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(long keyId, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return this.addPassphrase(new KeyIdentifier(keyId), passphrase);
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(@NotNull KeyIdentifier keyIdentifier, @NotNull Passphrase passphrase) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        CachingSecretKeyRingProtector $this$addPassphrase_u24lambda_u241 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        if (!(!$this$addPassphrase_u24lambda_u241.cache.containsKey(keyIdentifier))) {
            boolean bl2 = false;
            String string = "The cache already holds a passphrase for ID " + keyIdentifier + ".\nIf you want to replace this passphrase, use replacePassphrase(Long, Passphrase) instead.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$addPassphrase_u24lambda_u241.cache.put(keyIdentifier, passphrase);
        return cachingSecretKeyRingProtector;
    }

    @Deprecated(message="Pass KeyIdentifier instead.")
    @NotNull
    public final CachingSecretKeyRingProtector replacePassphrase(long keyId, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return this.replacePassphrase(new KeyIdentifier(keyId), passphrase);
    }

    @NotNull
    public final CachingSecretKeyRingProtector replacePassphrase(@NotNull KeyIdentifier keyId, @NotNull Passphrase passphrase) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        CachingSecretKeyRingProtector $this$replacePassphrase_u24lambda_u242 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        $this$replacePassphrase_u24lambda_u242.cache.put(keyId, passphrase);
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(@NotNull PGPKeyRing keyRing, @NotNull Passphrase passphrase) {
        PGPPublicKey it;
        Object element$iv;
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter((Object)keyRing, (String)"keyRing");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        CachingSecretKeyRingProtector $this$addPassphrase_u24lambda_u246 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        Iterator iterator = keyRing.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"getPublicKeys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (PGPPublicKey)element$iv;
            boolean bl2 = false;
            if (!$this$addPassphrase_u24lambda_u246.cache.containsKey(it.getKeyIdentifier())) continue;
            boolean bl3 = false;
            String string = "The cache already holds a passphrase for the key with ID " + it.getKeyIdentifier() + ".\nIf you want to replace the passphrase, use replacePassphrase(PGPKeyRing, Passphrase) instead.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterator iterator3 = keyRing.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator3, (String)"getPublicKeys(...)");
        $this$forEach$iv = iterator3;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            it = (PGPPublicKey)element$iv;
            boolean bl4 = false;
            $this$addPassphrase_u24lambda_u246.cache.put(it.getKeyIdentifier(), passphrase);
        }
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector replacePassphrase(@NotNull PGPKeyRing keyRing, @NotNull Passphrase passphrase) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter((Object)keyRing, (String)"keyRing");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        CachingSecretKeyRingProtector $this$replacePassphrase_u24lambda_u248 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        Iterator iterator = keyRing.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"getPublicKeys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            PGPPublicKey it = (PGPPublicKey)element$iv;
            boolean bl2 = false;
            $this$replacePassphrase_u24lambda_u248.cache.put(it.getKeyIdentifier(), passphrase);
        }
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(@NotNull PGPPublicKey key, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyIdentifier keyIdentifier = key.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
        return this.addPassphrase(keyIdentifier, passphrase);
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(@NotNull OpenPGPCertificate cert, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        PGPKeyRing pGPKeyRing = cert.getPGPKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)pGPKeyRing, (String)"getPGPKeyRing(...)");
        return this.addPassphrase(pGPKeyRing, passphrase);
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(@NotNull OpenPGPCertificate.OpenPGPComponentKey key, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyIdentifier keyIdentifier = key.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
        return this.addPassphrase(keyIdentifier, passphrase);
    }

    @NotNull
    public final CachingSecretKeyRingProtector addPassphrase(@NotNull OpenPgpFingerprint fingerprint, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return this.addPassphrase(fingerprint.getKeyIdentifier(), passphrase);
    }

    @Deprecated(message="Pass KeyIdentifier instead.")
    @NotNull
    public final CachingSecretKeyRingProtector forgetPassphrase(long keyId) {
        return this.forgetPassphrase(new KeyIdentifier(keyId));
    }

    @NotNull
    public final CachingSecretKeyRingProtector forgetPassphrase(@NotNull KeyIdentifier keyId) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        block0: {
            Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
            CachingSecretKeyRingProtector $this$forgetPassphrase_u24lambda_u249 = cachingSecretKeyRingProtector = this;
            boolean bl = false;
            Passphrase passphrase = $this$forgetPassphrase_u24lambda_u249.cache.remove(keyId);
            if (passphrase == null) break block0;
            passphrase.clear();
        }
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector forgetPassphrase(@NotNull PGPKeyRing keyRing) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter((Object)keyRing, (String)"keyRing");
        CachingSecretKeyRingProtector $this$forgetPassphrase_u24lambda_u2411 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        Iterator iterator = keyRing.getPublicKeys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"getPublicKeys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            PGPPublicKey it = (PGPPublicKey)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$forgetPassphrase_u24lambda_u2411.forgetPassphrase(it);
        }
        return cachingSecretKeyRingProtector;
    }

    @NotNull
    public final CachingSecretKeyRingProtector forgetPassphrase(@NotNull OpenPGPCertificate cert) {
        Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
        PGPPublicKeyRing pGPPublicKeyRing = cert.getPGPPublicKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing, (String)"getPGPPublicKeyRing(...)");
        return this.forgetPassphrase((PGPKeyRing)pGPPublicKeyRing);
    }

    @NotNull
    public final CachingSecretKeyRingProtector forgetPassphrase(@NotNull PGPPublicKey key) {
        CachingSecretKeyRingProtector cachingSecretKeyRingProtector;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CachingSecretKeyRingProtector $this$forgetPassphrase_u24lambda_u2412 = cachingSecretKeyRingProtector = this;
        boolean bl = false;
        KeyIdentifier keyIdentifier = key.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
        $this$forgetPassphrase_u24lambda_u2412.forgetPassphrase(keyIdentifier);
        return cachingSecretKeyRingProtector;
    }

    @Override
    @Nullable
    public Passphrase getPassphraseFor(@NotNull KeyIdentifier keyIdentifier) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        if (this.hasPassphrase(keyIdentifier)) {
            object = this.cache.get(keyIdentifier);
        } else {
            Object object2 = this.provider;
            if (object2 != null && (object2 = object2.getPassphraseFor(keyIdentifier)) != null) {
                Object object3;
                Object it = object3 = object2;
                boolean bl = false;
                this.cache.put(keyIdentifier, (Passphrase)it);
                object = object3;
            } else {
                object = null;
            }
        }
        return object;
    }

    @Override
    public boolean hasPassphraseFor(@NotNull KeyIdentifier keyIdentifier) {
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        return this.hasPassphrase(keyIdentifier);
    }

    @Override
    public boolean hasPassphrase(@NotNull KeyIdentifier keyIdentifier) {
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        Passphrase passphrase = this.cache.get(keyIdentifier);
        return passphrase != null ? passphrase.isValid() : false;
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(@NotNull KeyIdentifier keyIdentifier) {
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        return this.protector.getDecryptor(keyIdentifier);
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(@NotNull PGPPublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.protector.getEncryptor(key);
    }

    @Nullable
    public char[] getKeyPassword(@NotNull OpenPGPKey.OpenPGPSecretKey p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        KeyIdentifier keyIdentifier = p0.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
        Passphrase passphrase = this.getPassphraseFor(keyIdentifier);
        return (char[])(passphrase != null ? passphrase.getChars() : null);
    }
}

