/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/pgpainless/key/protection/BaseSecretKeyRingProtector;", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "passphraseProvider", "Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;", "(Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;)V", "protectionSettings", "Lorg/pgpainless/key/protection/KeyRingProtectionSettings;", "(Lorg/pgpainless/key/protection/passphrase_provider/SecretKeyPassphraseProvider;Lorg/pgpainless/key/protection/KeyRingProtectionSettings;)V", "getDecryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "keyId", "", "keyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "getEncryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyEncryptor;", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "getKeyPassword", "", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "hasPassphraseFor", "", "pgpainless-core"})
public class BaseSecretKeyRingProtector
implements SecretKeyRingProtector {
    @NotNull
    private final SecretKeyPassphraseProvider passphraseProvider;
    @NotNull
    private final KeyRingProtectionSettings protectionSettings;

    public BaseSecretKeyRingProtector(@NotNull SecretKeyPassphraseProvider passphraseProvider, @NotNull KeyRingProtectionSettings protectionSettings) {
        Intrinsics.checkNotNullParameter((Object)passphraseProvider, (String)"passphraseProvider");
        Intrinsics.checkNotNullParameter((Object)protectionSettings, (String)"protectionSettings");
        this.passphraseProvider = passphraseProvider;
        this.protectionSettings = protectionSettings;
    }

    public BaseSecretKeyRingProtector(@NotNull SecretKeyPassphraseProvider passphraseProvider) {
        Intrinsics.checkNotNullParameter((Object)passphraseProvider, (String)"passphraseProvider");
        this(passphraseProvider, KeyRingProtectionSettings.Companion.secureDefaultSettings());
    }

    @Override
    public boolean hasPassphraseFor(@NotNull KeyIdentifier keyIdentifier) {
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        return this.passphraseProvider.hasPassphrase(keyIdentifier);
    }

    @Override
    @Deprecated(message="Pass in a KeyIdentifier instead.")
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(long keyId) {
        return this.getDecryptor(new KeyIdentifier(keyId));
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(@NotNull KeyIdentifier keyIdentifier) {
        PBESecretKeyDecryptor pBESecretKeyDecryptor;
        Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyIdentifier);
        if (passphrase != null) {
            Passphrase it = passphrase;
            boolean bl = false;
            pBESecretKeyDecryptor = it.isEmpty() ? null : OpenPGPImplementation.getInstance().pbeSecretKeyDecryptorBuilderProvider().provide().build(it.getChars());
        } else {
            pBESecretKeyDecryptor = null;
        }
        return pBESecretKeyDecryptor;
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(@NotNull PGPPublicKey key) {
        PBESecretKeyEncryptor pBESecretKeyEncryptor;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        KeyIdentifier keyIdentifier = key.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyIdentifier);
        if (passphrase != null) {
            Passphrase it = passphrase;
            boolean bl = false;
            pBESecretKeyEncryptor = it.isEmpty() ? null : OpenPGPImplementation.getInstance().pbeSecretKeyEncryptorFactory(this.protectionSettings.getAead(), this.protectionSettings.getEncryptionAlgorithm().getAlgorithmId(), this.protectionSettings.getS2kCount()).build(it.getChars(), key.getPublicKeyPacket());
        } else {
            pBESecretKeyEncryptor = null;
        }
        return pBESecretKeyEncryptor;
    }

    @Nullable
    public char[] getKeyPassword(@NotNull OpenPGPKey.OpenPGPSecretKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        KeyIdentifier keyIdentifier = key.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyIdentifier);
        return (char[])(passphrase != null ? passphrase.getChars() : null);
    }
}

