/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.AEADCipherMode;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.PreferredAlgorithmsExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/pgpainless/key/info/KeyAccessor;", "", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "referenceTime", "Ljava/util/Date;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;Ljava/util/Date;)V", "component", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPCertificateComponent;", "getComponent", "()Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPCertificateComponent;", "features", "", "Lorg/pgpainless/algorithm/Feature;", "getFeatures", "()Ljava/util/Set;", "getKey", "()Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "preferredAEADCipherSuites", "Lorg/pgpainless/algorithm/AEADCipherMode;", "getPreferredAEADCipherSuites", "preferredCompressionAlgorithms", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "getPreferredCompressionAlgorithms", "preferredHashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "getPreferredHashAlgorithms", "preferredSymmetricKeyAlgorithms", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getPreferredSymmetricKeyAlgorithms", "ViaKeyIdentifier", "ViaUserId", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nKeyAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyAccessor.kt\norg/pgpainless/key/info/KeyAccessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,75:1\n11065#2:76\n11400#2,3:77\n*S KotlinDebug\n*F\n+ 1 KeyAccessor.kt\norg/pgpainless/key/info/KeyAccessor\n*L\n45#1:76\n45#1:77,3\n*E\n"})
public abstract class KeyAccessor {
    @NotNull
    private final OpenPGPCertificate.OpenPGPComponentKey key;
    @NotNull
    private final Date referenceTime;

    public KeyAccessor(@NotNull OpenPGPCertificate.OpenPGPComponentKey key, @NotNull Date referenceTime) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
        this.key = key;
        this.referenceTime = referenceTime;
    }

    @NotNull
    protected final OpenPGPCertificate.OpenPGPComponentKey getKey() {
        return this.key;
    }

    @NotNull
    public abstract OpenPGPCertificate.OpenPGPCertificateComponent getComponent();

    @NotNull
    public final Set<SymmetricKeyAlgorithm> getPreferredSymmetricKeyAlgorithms() {
        Object object = this.getComponent().getSymmetricCipherPreferences(this.referenceTime);
        if (object == null || (object = PreferredAlgorithmsExtensionsKt.toSymmetricKeyAlgorithms(object)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @NotNull
    public final Set<HashAlgorithm> getPreferredHashAlgorithms() {
        Object object = this.getComponent().getHashAlgorithmPreferences(this.referenceTime);
        if (object == null || (object = PreferredAlgorithmsExtensionsKt.toHashAlgorithms(object)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @NotNull
    public final Set<CompressionAlgorithm> getPreferredCompressionAlgorithms() {
        Object object = this.getComponent().getCompressionAlgorithmPreferences(this.referenceTime);
        if (object == null || (object = PreferredAlgorithmsExtensionsKt.toCompressionAlgorithms(object)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Set<AEADCipherMode> getPreferredAEADCipherSuites() {
        Set set;
        PreferredAEADCiphersuites.Combination[] combinationArray;
        PreferredAEADCiphersuites preferredAEADCiphersuites = this.getComponent().getAEADCipherSuitePreferences(this.referenceTime);
        if (preferredAEADCiphersuites != null && (combinationArray = preferredAEADCiphersuites.getRawAlgorithms()) != null) {
            void $this$mapTo$iv$iv;
            PreferredAEADCiphersuites.Combination[] $this$map$iv = combinationArray;
            boolean $i$f$map = false;
            PreferredAEADCiphersuites.Combination[] combinationArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(new AEADCipherMode((PreferredAEADCiphersuites.Combination)it));
            }
            Set set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (set2 != null) {
                set = set2;
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    @NotNull
    public final Set<Feature> getFeatures() {
        Features features = this.getComponent().getFeatures(this.referenceTime);
        return CollectionsKt.toSet((Iterable)Feature.Companion.fromBitmask(features != null ? features.getFeatures() : (byte)0));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/key/info/KeyAccessor$ViaKeyIdentifier;", "Lorg/pgpainless/key/info/KeyAccessor;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "referenceTime", "Ljava/util/Date;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;Ljava/util/Date;)V", "component", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPCertificateComponent;", "getComponent", "()Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPCertificateComponent;", "pgpainless-core"})
    public static final class ViaKeyIdentifier
    extends KeyAccessor {
        @NotNull
        private final OpenPGPCertificate.OpenPGPCertificateComponent component;

        public ViaKeyIdentifier(@NotNull OpenPGPCertificate.OpenPGPComponentKey key, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            super(key, referenceTime);
            this.component = (OpenPGPCertificate.OpenPGPCertificateComponent)key;
        }

        public /* synthetic */ ViaKeyIdentifier(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                date = new Date();
            }
            this(openPGPComponentKey, date);
        }

        @Override
        @NotNull
        public OpenPGPCertificate.OpenPGPCertificateComponent getComponent() {
            return this.component;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/pgpainless/key/info/KeyAccessor$ViaUserId;", "Lorg/pgpainless/key/info/KeyAccessor;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "userId", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPIdentityComponent;", "referenceTime", "Ljava/util/Date;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPIdentityComponent;Ljava/util/Date;)V", "component", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPCertificateComponent;", "getComponent", "()Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPCertificateComponent;", "pgpainless-core"})
    public static final class ViaUserId
    extends KeyAccessor {
        @NotNull
        private final OpenPGPCertificate.OpenPGPCertificateComponent component;

        public ViaUserId(@NotNull OpenPGPCertificate.OpenPGPComponentKey key, @NotNull OpenPGPCertificate.OpenPGPIdentityComponent userId, @NotNull Date referenceTime) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)referenceTime, (String)"referenceTime");
            super(key, referenceTime);
            this.component = (OpenPGPCertificate.OpenPGPCertificateComponent)userId;
        }

        public /* synthetic */ ViaUserId(OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey, OpenPGPCertificate.OpenPGPIdentityComponent openPGPIdentityComponent, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                date = new Date();
            }
            this(openPGPComponentKey, openPGPIdentityComponent, date);
        }

        @Override
        @NotNull
        public OpenPGPCertificate.OpenPGPCertificateComponent getComponent() {
            return this.component;
        }
    }
}

