/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.ecc.Ed25519;
import org.pgpainless.key.generation.type.ecc.Ed448;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;
import org.pgpainless.key.generation.type.ecc.X25519;
import org.pgpainless.key.generation.type.ecc.X448;
import org.pgpainless.key.generation.type.ecc.ecdh.ECDH;
import org.pgpainless.key.generation.type.ecc.ecdsa.ECDSA;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacy;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.rsa.RSA;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacy;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a\u00c0\u0006\u0003"}, d2={"Lorg/pgpainless/key/generation/type/KeyType;", "", "algorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getAlgorithm", "()Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "bitStrength", "", "getBitStrength", "()I", "canAuthenticate", "", "()Z", "canCertify", "canEncryptCommunication", "canEncryptStorage", "canSign", "name", "", "getName", "()Ljava/lang/String;", "generateKeyPair", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "generator", "Lorg/bouncycastle/openpgp/operator/PGPKeyPairGenerator;", "Companion", "pgpainless-core"})
public interface KeyType {
    @NotNull
    public static final Companion Companion = org.pgpainless.key.generation.type.KeyType$Companion.$$INSTANCE;

    @NotNull
    public String getName();

    @NotNull
    public PublicKeyAlgorithm getAlgorithm();

    public int getBitStrength();

    @JvmName(name="canSign")
    default public boolean canSign() {
        return this.getAlgorithm().getSigningCapable();
    }

    @JvmName(name="canCertify")
    default public boolean canCertify() {
        return this.canSign();
    }

    @JvmName(name="canAuthenticate")
    default public boolean canAuthenticate() {
        return this.canSign();
    }

    @JvmName(name="canEncryptCommunication")
    default public boolean canEncryptCommunication() {
        return this.getAlgorithm().getEncryptionCapable();
    }

    @JvmName(name="canEncryptStorage")
    default public boolean canEncryptStorage() {
        return this.getAlgorithm().getEncryptionCapable();
    }

    @NotNull
    public PGPKeyPair generateKeyPair(@NotNull PGPKeyPairGenerator var1);

    @JvmStatic
    @NotNull
    public static RSA RSA(@NotNull RsaLength length) {
        return Companion.RSA(length);
    }

    @JvmStatic
    @NotNull
    public static ECDH ECDH(@NotNull EllipticCurve curve) {
        return Companion.ECDH(curve);
    }

    @JvmStatic
    @NotNull
    public static ECDSA ECDSA(@NotNull EllipticCurve curve) {
        return Companion.ECDSA(curve);
    }

    @JvmStatic
    @NotNull
    public static EdDSALegacy EDDSA_LEGACY(@NotNull EdDSALegacyCurve curve) {
        return Companion.EDDSA_LEGACY(curve);
    }

    @JvmStatic
    @NotNull
    public static XDHLegacy XDH_LEGACY(@NotNull XDHLegacySpec curve) {
        return Companion.XDH_LEGACY(curve);
    }

    @JvmStatic
    @NotNull
    public static X25519 X25519() {
        return Companion.X25519();
    }

    @JvmStatic
    @NotNull
    public static X448 X448() {
        return Companion.X448();
    }

    @JvmStatic
    @NotNull
    public static Ed25519 Ed25519() {
        return Companion.Ed25519();
    }

    @JvmStatic
    @NotNull
    public static Ed448 Ed448() {
        return Companion.Ed448();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u001aH\u0007\u00a8\u0006\u001b"}, d2={"Lorg/pgpainless/key/generation/type/KeyType$Companion;", "", "()V", "ECDH", "Lorg/pgpainless/key/generation/type/ecc/ecdh/ECDH;", "curve", "Lorg/pgpainless/key/generation/type/ecc/EllipticCurve;", "ECDSA", "Lorg/pgpainless/key/generation/type/ecc/ecdsa/ECDSA;", "EDDSA_LEGACY", "Lorg/pgpainless/key/generation/type/eddsa_legacy/EdDSALegacy;", "Lorg/pgpainless/key/generation/type/eddsa_legacy/EdDSALegacyCurve;", "Ed25519", "Lorg/pgpainless/key/generation/type/ecc/Ed25519;", "Ed448", "Lorg/pgpainless/key/generation/type/ecc/Ed448;", "RSA", "Lorg/pgpainless/key/generation/type/rsa/RSA;", "length", "Lorg/pgpainless/key/generation/type/rsa/RsaLength;", "X25519", "Lorg/pgpainless/key/generation/type/ecc/X25519;", "X448", "Lorg/pgpainless/key/generation/type/ecc/X448;", "XDH_LEGACY", "Lorg/pgpainless/key/generation/type/xdh_legacy/XDHLegacy;", "Lorg/pgpainless/key/generation/type/xdh_legacy/XDHLegacySpec;", "pgpainless-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RSA RSA(@NotNull RsaLength length) {
            Intrinsics.checkNotNullParameter((Object)length, (String)"length");
            return RSA.Companion.withLength(length);
        }

        @JvmStatic
        @NotNull
        public final ECDH ECDH(@NotNull EllipticCurve curve) {
            Intrinsics.checkNotNullParameter((Object)((Object)curve), (String)"curve");
            return ECDH.Companion.fromCurve(curve);
        }

        @JvmStatic
        @NotNull
        public final ECDSA ECDSA(@NotNull EllipticCurve curve) {
            Intrinsics.checkNotNullParameter((Object)((Object)curve), (String)"curve");
            return ECDSA.Companion.fromCurve(curve);
        }

        @JvmStatic
        @NotNull
        public final EdDSALegacy EDDSA_LEGACY(@NotNull EdDSALegacyCurve curve) {
            Intrinsics.checkNotNullParameter((Object)((Object)curve), (String)"curve");
            return EdDSALegacy.Companion.fromCurve(curve);
        }

        @JvmStatic
        @NotNull
        public final XDHLegacy XDH_LEGACY(@NotNull XDHLegacySpec curve) {
            Intrinsics.checkNotNullParameter((Object)((Object)curve), (String)"curve");
            return XDHLegacy.Companion.fromSpec(curve);
        }

        @JvmStatic
        @NotNull
        public final X25519 X25519() {
            return new X25519();
        }

        @JvmStatic
        @NotNull
        public final X448 X448() {
            return new X448();
        }

        @JvmStatic
        @NotNull
        public final Ed25519 Ed25519() {
            return new Ed25519();
        }

        @JvmStatic
        @NotNull
        public final Ed448 Ed448() {
            return new Ed448();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @JvmName(name="canSign")
        public static boolean canSign(@NotNull KeyType $this) {
            return $this.canSign();
        }

        @Deprecated
        @JvmName(name="canCertify")
        public static boolean canCertify(@NotNull KeyType $this) {
            return $this.canCertify();
        }

        @Deprecated
        @JvmName(name="canAuthenticate")
        public static boolean canAuthenticate(@NotNull KeyType $this) {
            return $this.canAuthenticate();
        }

        @Deprecated
        @JvmName(name="canEncryptCommunication")
        public static boolean canEncryptCommunication(@NotNull KeyType $this) {
            return $this.canEncryptCommunication();
        }

        @Deprecated
        @JvmName(name="canEncryptStorage")
        public static boolean canEncryptStorage(@NotNull KeyType $this) {
            return $this.canEncryptStorage();
        }
    }
}

