/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.AEADCipherMode;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.KeySpecBuilderInterface;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J!\u0010\u0019\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005\"\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u00020\u00002\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0005\"\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\u00020\u00002\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0005\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\u00020\u00002\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0005\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020\u00002\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0005\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u000eH\u0016R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/pgpainless/key/generation/KeySpecBuilder;", "Lorg/pgpainless/key/generation/KeySpecBuilderInterface;", "type", "Lorg/pgpainless/key/generation/type/KeyType;", "keyFlags", "", "Lorg/pgpainless/algorithm/KeyFlag;", "(Lorg/pgpainless/key/generation/type/KeyType;[Lorg/pgpainless/algorithm/KeyFlag;)V", "", "(Lorg/pgpainless/key/generation/type/KeyType;Ljava/util/List;)V", "features", "", "Lorg/pgpainless/algorithm/Feature;", "keyCreationDate", "Ljava/util/Date;", "preferredAEADAlgorithms", "Lorg/pgpainless/algorithm/AEADCipherMode;", "preferredCompressionAlgorithms", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "preferredHashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "preferredSymmetricAlgorithms", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "build", "Lorg/pgpainless/key/generation/KeySpec;", "overrideFeatures", "([Lorg/pgpainless/algorithm/Feature;)Lorg/pgpainless/key/generation/KeySpecBuilder;", "overridePreferredAEADAlgorithms", "algorithms", "([Lorg/pgpainless/algorithm/AEADCipherMode;)Lorg/pgpainless/key/generation/KeySpecBuilder;", "overridePreferredCompressionAlgorithms", "([Lorg/pgpainless/algorithm/CompressionAlgorithm;)Lorg/pgpainless/key/generation/KeySpecBuilder;", "overridePreferredHashAlgorithms", "([Lorg/pgpainless/algorithm/HashAlgorithm;)Lorg/pgpainless/key/generation/KeySpecBuilder;", "overridePreferredSymmetricKeyAlgorithms", "([Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;)Lorg/pgpainless/key/generation/KeySpecBuilder;", "setKeyCreationDate", "creationDate", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nKeySpecBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeySpecBuilder.kt\norg/pgpainless/key/generation/KeySpecBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,76:1\n37#2,2:77\n*S KotlinDebug\n*F\n+ 1 KeySpecBuilder.kt\norg/pgpainless/key/generation/KeySpecBuilder\n*L\n27#1:77,2\n*E\n"})
public final class KeySpecBuilder
implements KeySpecBuilderInterface {
    @NotNull
    private final KeyType type;
    @NotNull
    private final List<KeyFlag> keyFlags;
    @Nullable
    private Set<? extends CompressionAlgorithm> preferredCompressionAlgorithms;
    @Nullable
    private Set<? extends HashAlgorithm> preferredHashAlgorithms;
    @Nullable
    private Set<? extends SymmetricKeyAlgorithm> preferredSymmetricAlgorithms;
    @Nullable
    private Set<AEADCipherMode> preferredAEADAlgorithms;
    @Nullable
    private Set<? extends Feature> features;
    @Nullable
    private Date keyCreationDate;

    public KeySpecBuilder(@NotNull KeyType type, @NotNull List<? extends KeyFlag> keyFlags) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(keyFlags, (String)"keyFlags");
        this.type = type;
        this.keyFlags = keyFlags;
        Collection $this$toTypedArray$iv = this.keyFlags;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KeyFlag[] keyFlagArray = thisCollection$iv.toArray(new KeyFlag[0]);
        SignatureSubpacketsUtil.Companion.assureKeyCanCarryFlags(this.type, Arrays.copyOf(keyFlagArray, keyFlagArray.length));
    }

    public KeySpecBuilder(@NotNull KeyType type, KeyFlag ... keyFlags) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)keyFlags, (String)"keyFlags");
        this(type, CollectionsKt.listOf((Object[])Arrays.copyOf(keyFlags, keyFlags.length)));
    }

    @Override
    @NotNull
    public KeySpecBuilder overridePreferredCompressionAlgorithms(CompressionAlgorithm ... algorithms) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)algorithms, (String)"algorithms");
        KeySpecBuilder $this$overridePreferredCompressionAlgorithms_u24lambda_u240 = keySpecBuilder = this;
        boolean bl = false;
        $this$overridePreferredCompressionAlgorithms_u24lambda_u240.preferredCompressionAlgorithms = algorithms.length == 0 ? null : ArraysKt.toSet((Object[])algorithms);
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpecBuilder overridePreferredHashAlgorithms(HashAlgorithm ... algorithms) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)algorithms, (String)"algorithms");
        KeySpecBuilder $this$overridePreferredHashAlgorithms_u24lambda_u241 = keySpecBuilder = this;
        boolean bl = false;
        $this$overridePreferredHashAlgorithms_u24lambda_u241.preferredHashAlgorithms = algorithms.length == 0 ? null : ArraysKt.toSet((Object[])algorithms);
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpecBuilder overridePreferredSymmetricKeyAlgorithms(SymmetricKeyAlgorithm ... algorithms) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)algorithms, (String)"algorithms");
        KeySpecBuilder $this$overridePreferredSymmetricKeyAlgorithms_u24lambda_u243 = keySpecBuilder = this;
        boolean bl = false;
        if (!(!ArraysKt.contains((Object[])algorithms, (Object)((Object)SymmetricKeyAlgorithm.NULL)))) {
            boolean bl2 = false;
            String string = "NULL (unencrypted) is an invalid symmetric key algorithm preference.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$overridePreferredSymmetricKeyAlgorithms_u24lambda_u243.preferredSymmetricAlgorithms = algorithms.length == 0 ? null : ArraysKt.toSet((Object[])algorithms);
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpecBuilder overridePreferredAEADAlgorithms(AEADCipherMode ... algorithms) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)algorithms, (String)"algorithms");
        KeySpecBuilder $this$overridePreferredAEADAlgorithms_u24lambda_u244 = keySpecBuilder = this;
        boolean bl = false;
        $this$overridePreferredAEADAlgorithms_u24lambda_u244.preferredAEADAlgorithms = algorithms.length == 0 ? null : ArraysKt.toSet((Object[])algorithms);
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpecBuilder overrideFeatures(Feature ... features) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)features, (String)"features");
        KeySpecBuilder $this$overrideFeatures_u24lambda_u245 = keySpecBuilder = this;
        boolean bl = false;
        $this$overrideFeatures_u24lambda_u245.features = features.length == 0 ? null : ArraysKt.toSet((Object[])features);
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpecBuilder setKeyCreationDate(@NotNull Date creationDate) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
        KeySpecBuilder $this$setKeyCreationDate_u24lambda_u246 = keySpecBuilder = this;
        boolean bl = false;
        $this$setKeyCreationDate_u24lambda_u246.keyCreationDate = creationDate;
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpec build() {
        return new KeySpec(this.type, this.keyFlags, this.preferredCompressionAlgorithms, this.preferredHashAlgorithms, this.preferredSymmetricAlgorithms, this.preferredAEADAlgorithms, this.features, this.keyCreationDate);
    }
}

