/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.OpenPGPKeyVersion;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa_legacy.EdDSALegacyCurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh_legacy.XDHLegacySpec;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\"\u0010\u0011\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ$\u0010\u0011\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u0014\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001c\u0010\u0014\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\"\u0010\u0015\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ$\u0010\u0015\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/pgpainless/key/generation/KeyRingTemplates;", "", "version", "Lorg/pgpainless/algorithm/OpenPGPKeyVersion;", "creationTime", "Ljava/util/Date;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/algorithm/OpenPGPKeyVersion;Ljava/util/Date;Lorg/pgpainless/PGPainless;)V", "modernKeyRing", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "userId", "", "password", "", "passphrase", "Lorg/pgpainless/util/Passphrase;", "rsaKeyRing", "length", "Lorg/pgpainless/key/generation/type/rsa/RsaLength;", "simpleEcKeyRing", "simpleRsaKeyRing", "pgpainless-core"})
public final class KeyRingTemplates {
    @NotNull
    private final OpenPGPKeyVersion version;
    @NotNull
    private final Date creationTime;
    @NotNull
    private final PGPainless api;

    public KeyRingTemplates(@NotNull OpenPGPKeyVersion version, @NotNull Date creationTime, @NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter((Object)creationTime, (String)"creationTime");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.version = version;
        this.creationTime = creationTime;
        this.api = api;
    }

    public /* synthetic */ KeyRingTemplates(OpenPGPKeyVersion openPGPKeyVersion, Date date, PGPainless pGPainless, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            date = new Date();
        }
        if ((n & 4) != 0) {
            pGPainless = PGPainless.Companion.getInstance();
        }
        this(openPGPKeyVersion, date, pGPainless);
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKey rsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length, @NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyRingBuilder $this$rsaKeyRing_u24lambda_u240 = keyRingBuilder = this.api.buildKey(this.version);
        boolean bl = false;
        KeyFlag[] keyFlagArray = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
        $this$rsaKeyRing_u24lambda_u240.setPrimaryKey(KeySpec.Companion.getBuilder(KeyType.Companion.RSA(length), keyFlagArray).setKeyCreationDate(this.creationTime));
        keyFlagArray = new KeyFlag[]{KeyFlag.SIGN_DATA};
        $this$rsaKeyRing_u24lambda_u240.addSubkey(KeySpec.Companion.getBuilder(KeyType.Companion.RSA(length), keyFlagArray).setKeyCreationDate(this.creationTime));
        keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
        $this$rsaKeyRing_u24lambda_u240.addSubkey(KeySpec.Companion.getBuilder(KeyType.Companion.RSA(length), keyFlagArray).setKeyCreationDate(this.creationTime));
        $this$rsaKeyRing_u24lambda_u240.setPassphrase(passphrase);
        if (userId != null) {
            $this$rsaKeyRing_u24lambda_u240.addUserId(userId);
        }
        return keyRingBuilder.build();
    }

    public static /* synthetic */ OpenPGPKey rsaKeyRing$default(KeyRingTemplates keyRingTemplates, CharSequence charSequence, RsaLength rsaLength, Passphrase passphrase, int n, Object object) {
        if ((n & 4) != 0) {
            passphrase = Passphrase.Companion.emptyPassphrase();
        }
        return keyRingTemplates.rsaKeyRing(charSequence, rsaLength, passphrase);
    }

    @NotNull
    public final OpenPGPKey rsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        String it = password;
        boolean bl = false;
        CharSequence charSequence = it;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.rsaKeyRing(userId, length, Passphrase.Companion.emptyPassphrase()) : this.rsaKeyRing(userId, length, Passphrase.Companion.fromPassword(it));
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKey simpleRsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length, @NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyRingBuilder $this$simpleRsaKeyRing_u24lambda_u242 = keyRingBuilder = this.api.buildKey(this.version);
        boolean bl = false;
        KeyFlag[] keyFlagArray = new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS};
        $this$simpleRsaKeyRing_u24lambda_u242.setPrimaryKey(KeySpec.Companion.getBuilder(KeyType.Companion.RSA(length), keyFlagArray).setKeyCreationDate(this.creationTime));
        $this$simpleRsaKeyRing_u24lambda_u242.setPassphrase(passphrase);
        if (userId != null) {
            $this$simpleRsaKeyRing_u24lambda_u242.addUserId(((Object)userId).toString());
        }
        return keyRingBuilder.build();
    }

    public static /* synthetic */ OpenPGPKey simpleRsaKeyRing$default(KeyRingTemplates keyRingTemplates, CharSequence charSequence, RsaLength rsaLength, Passphrase passphrase, int n, Object object) {
        if ((n & 4) != 0) {
            passphrase = Passphrase.Companion.emptyPassphrase();
        }
        return keyRingTemplates.simpleRsaKeyRing(charSequence, rsaLength, passphrase);
    }

    @NotNull
    public final OpenPGPKey simpleRsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length, @Nullable String password) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        String it = password;
        boolean bl = false;
        CharSequence charSequence = it;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.simpleRsaKeyRing(userId, length, Passphrase.Companion.emptyPassphrase()) : this.simpleRsaKeyRing(userId, length, Passphrase.Companion.fromPassword(it));
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKey simpleEcKeyRing(@Nullable CharSequence userId, @NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyType signingKeyType = this.version == OpenPGPKeyVersion.v6 ? (KeyType)KeyType.Companion.Ed25519() : (KeyType)KeyType.Companion.EDDSA_LEGACY(EdDSALegacyCurve._Ed25519);
        KeyType encryptionKeyType = this.version == OpenPGPKeyVersion.v6 ? (KeyType)KeyType.Companion.X25519() : (KeyType)KeyType.Companion.XDH_LEGACY(XDHLegacySpec._X25519);
        KeyRingBuilder $this$simpleEcKeyRing_u24lambda_u244 = keyRingBuilder = this.api.buildKey(this.version);
        boolean bl = false;
        KeyFlag[] keyFlagArray = new KeyFlag[]{KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA};
        $this$simpleEcKeyRing_u24lambda_u244.setPrimaryKey(KeySpec.Companion.getBuilder(signingKeyType, keyFlagArray).setKeyCreationDate(this.creationTime));
        keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS};
        $this$simpleEcKeyRing_u24lambda_u244.addSubkey(KeySpec.Companion.getBuilder(encryptionKeyType, keyFlagArray).setKeyCreationDate(this.creationTime));
        $this$simpleEcKeyRing_u24lambda_u244.setPassphrase(passphrase);
        if (userId != null) {
            $this$simpleEcKeyRing_u24lambda_u244.addUserId(((Object)userId).toString());
        }
        return keyRingBuilder.build();
    }

    public static /* synthetic */ OpenPGPKey simpleEcKeyRing$default(KeyRingTemplates keyRingTemplates, CharSequence charSequence, Passphrase passphrase, int n, Object object) {
        if ((n & 2) != 0) {
            passphrase = Passphrase.Companion.emptyPassphrase();
        }
        return keyRingTemplates.simpleEcKeyRing(charSequence, passphrase);
    }

    @NotNull
    public final OpenPGPKey simpleEcKeyRing(@Nullable CharSequence userId, @Nullable String password) {
        String it = password;
        boolean bl = false;
        CharSequence charSequence = it;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.simpleEcKeyRing(userId, Passphrase.Companion.emptyPassphrase()) : this.simpleEcKeyRing(userId, Passphrase.Companion.fromPassword(it));
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKey modernKeyRing(@Nullable CharSequence userId, @NotNull Passphrase passphrase) {
        KeyRingBuilder keyRingBuilder;
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        KeyType signingKeyType = this.version == OpenPGPKeyVersion.v6 ? (KeyType)KeyType.Companion.Ed25519() : (KeyType)KeyType.Companion.EDDSA_LEGACY(EdDSALegacyCurve._Ed25519);
        KeyType encryptionKeyType = this.version == OpenPGPKeyVersion.v6 ? (KeyType)KeyType.Companion.X25519() : (KeyType)KeyType.Companion.XDH_LEGACY(XDHLegacySpec._X25519);
        KeyRingBuilder $this$modernKeyRing_u24lambda_u246 = keyRingBuilder = this.api.buildKey(this.version);
        boolean bl = false;
        KeyFlag[] keyFlagArray = new KeyFlag[]{KeyFlag.CERTIFY_OTHER};
        $this$modernKeyRing_u24lambda_u246.setPrimaryKey(KeySpec.Companion.getBuilder(signingKeyType, keyFlagArray).setKeyCreationDate(this.creationTime));
        keyFlagArray = new KeyFlag[]{KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE};
        $this$modernKeyRing_u24lambda_u246.addSubkey(KeySpec.Companion.getBuilder(encryptionKeyType, keyFlagArray).setKeyCreationDate(this.creationTime));
        keyFlagArray = new KeyFlag[]{KeyFlag.SIGN_DATA};
        $this$modernKeyRing_u24lambda_u246.addSubkey(KeySpec.Companion.getBuilder(signingKeyType, keyFlagArray).setKeyCreationDate(this.creationTime));
        $this$modernKeyRing_u24lambda_u246.setPassphrase(passphrase);
        if (userId != null) {
            $this$modernKeyRing_u24lambda_u246.addUserId(userId);
        }
        return keyRingBuilder.build();
    }

    public static /* synthetic */ OpenPGPKey modernKeyRing$default(KeyRingTemplates keyRingTemplates, CharSequence charSequence, Passphrase passphrase, int n, Object object) {
        if ((n & 2) != 0) {
            passphrase = Passphrase.Companion.emptyPassphrase();
        }
        return keyRingTemplates.modernKeyRing(charSequence, passphrase);
    }

    @NotNull
    public final OpenPGPKey modernKeyRing(@Nullable CharSequence userId, @Nullable String password) {
        String it = password;
        boolean bl = false;
        CharSequence charSequence = it;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? this.modernKeyRing(userId, Passphrase.Companion.emptyPassphrase()) : this.modernKeyRing(userId, Passphrase.Companion.fromPassword(it));
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKey rsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        return KeyRingTemplates.rsaKeyRing$default(this, userId, length, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKey simpleRsaKeyRing(@Nullable CharSequence userId, @NotNull RsaLength length) {
        Intrinsics.checkNotNullParameter((Object)length, (String)"length");
        return KeyRingTemplates.simpleRsaKeyRing$default(this, userId, length, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKey simpleEcKeyRing(@Nullable CharSequence userId) {
        return KeyRingTemplates.simpleEcKeyRing$default(this, userId, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final OpenPGPKey modernKeyRing(@Nullable CharSequence userId) {
        return KeyRingTemplates.modernKeyRing$default(this, userId, null, 2, null);
    }
}

