/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.certification;

import java.util.Date;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CertificationType;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.Trustworthiness;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.signature.builder.RevocationSignatureBuilder;
import org.pgpainless.signature.builder.ThirdPartyCertificationSignatureBuilder;
import org.pgpainless.signature.builder.ThirdPartyDirectKeySignatureBuilder;
import org.pgpainless.signature.subpackets.CertificationSubpackets;
import org.pgpainless.signature.subpackets.RevocationSignatureSubpackets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 \u001b2\u00020\u0001:\n\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u001c\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000e2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000eJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u000eJ\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J \u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate;", "", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "certificate", "Lorg/pgpainless/key/certification/CertifyCertificate$DelegationOnCertificate;", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "trustworthiness", "Lorg/pgpainless/algorithm/Trustworthiness;", "certifyUserId", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationOnUserId;", "userId", "", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "certificationType", "Lorg/pgpainless/algorithm/CertificationType;", "delegateTrust", "revokeCertifiedUserId", "Lorg/pgpainless/key/certification/CertifyCertificate$RevocationOnUserId;", "revokeDelegatedTrust", "Lorg/pgpainless/key/certification/CertifyCertificate$RevocationOnCertificate;", "userIdOnCertificate", "", "CertificationOnUserId", "CertificationOnUserIdWithSubpackets", "CertificationResult", "Companion", "DelegationOnCertificate", "DelegationOnCertificateWithSubpackets", "RevocationOnCertificate", "RevocationOnCertificateWithSubpackets", "RevocationOnUserId", "RevocationOnUserIdWithSubpackets", "pgpainless-core"})
public final class CertifyCertificate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PGPainless api;

    public CertifyCertificate(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
    }

    @JvmOverloads
    @NotNull
    public final CertificationOnUserId certifyUserId(@NotNull CharSequence userId, @NotNull OpenPGPCertificate certificate, @NotNull CertificationType certificationType) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter((Object)((Object)certificationType), (String)"certificationType");
        return new CertificationOnUserId(userId, certificate, certificationType, this.api);
    }

    public static /* synthetic */ CertificationOnUserId certifyUserId$default(CertifyCertificate certifyCertificate, CharSequence charSequence, OpenPGPCertificate openPGPCertificate, CertificationType certificationType, int n, Object object) {
        if ((n & 4) != 0) {
            certificationType = CertificationType.GENERIC;
        }
        return certifyCertificate.certifyUserId(charSequence, openPGPCertificate, certificationType);
    }

    @Deprecated(message="Pass in an OpenPGPCertificate instead.", replaceWith=@ReplaceWith(expression="certifyUserId", imports={}))
    @NotNull
    public final CertificationOnUserId userIdOnCertificate(@NotNull String userId, @NotNull PGPPublicKeyRing certificate) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        return this.userIdOnCertificate(userId, certificate, CertificationType.GENERIC);
    }

    @Deprecated(message="Pass in an OpenPGPCertificate instead of PGPPublicKeyRing.")
    @NotNull
    public final CertificationOnUserId userIdOnCertificate(@NotNull String userId, @NotNull PGPPublicKeyRing certificate, @NotNull CertificationType certificationType) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter((Object)((Object)certificationType), (String)"certificationType");
        return new CertificationOnUserId(userId, certificate, certificationType, this.api);
    }

    @NotNull
    public final RevocationOnUserId revokeCertifiedUserId(@NotNull CharSequence userId, @NotNull OpenPGPCertificate certificate) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        return new RevocationOnUserId(userId, certificate, this.api);
    }

    @JvmOverloads
    @NotNull
    public final DelegationOnCertificate delegateTrust(@NotNull OpenPGPCertificate certificate, @Nullable Trustworthiness trustworthiness) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        return new DelegationOnCertificate(certificate, trustworthiness, this.api);
    }

    public static /* synthetic */ DelegationOnCertificate delegateTrust$default(CertifyCertificate certifyCertificate, OpenPGPCertificate openPGPCertificate, Trustworthiness trustworthiness, int n, Object object) {
        if ((n & 2) != 0) {
            trustworthiness = null;
        }
        return certifyCertificate.delegateTrust(openPGPCertificate, trustworthiness);
    }

    @Deprecated(message="Pass in an OpenPGPCertificate instead of PGPPublicKeyRing.")
    @NotNull
    public final DelegationOnCertificate certificate(@NotNull PGPPublicKeyRing certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        return this.certificate(certificate, null);
    }

    @Deprecated(message="Pass in an OpenPGPCertificate instead of PGPPublicKeyRing.")
    @NotNull
    public final DelegationOnCertificate certificate(@NotNull PGPPublicKeyRing certificate, @Nullable Trustworthiness trustworthiness) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        return new DelegationOnCertificate(certificate, trustworthiness, this.api);
    }

    @NotNull
    public final RevocationOnCertificate revokeDelegatedTrust(@NotNull OpenPGPCertificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        return new RevocationOnCertificate(certificate, this.api);
    }

    @JvmOverloads
    @NotNull
    public final CertificationOnUserId certifyUserId(@NotNull CharSequence userId, @NotNull OpenPGPCertificate certificate) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        return CertifyCertificate.certifyUserId$default(this, userId, certificate, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final DelegationOnCertificate delegateTrust(@NotNull OpenPGPCertificate certificate) {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        return CertifyCertificate.delegateTrust$default(this, certificate, null, 2, null);
    }

    @JvmStatic
    private static final OpenPGPKey.OpenPGPSecretKey getCertifyingSecretKey(OpenPGPKey certificationKey, PGPainless api) {
        return CertifyCertificate.Companion.getCertifyingSecretKey(certificationKey, api);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB%\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$CertificationOnUserId;", "", "userId", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "certificationType", "Lorg/pgpainless/algorithm/CertificationType;", "api", "Lorg/pgpainless/PGPainless;", "(Ljava/lang/String;Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Lorg/pgpainless/algorithm/CertificationType;Lorg/pgpainless/PGPainless;)V", "", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Ljava/lang/CharSequence;Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Lorg/pgpainless/algorithm/CertificationType;Lorg/pgpainless/PGPainless;)V", "withKey", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationOnUserIdWithSubpackets;", "certificationKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "pgpainless-core"})
    public static final class CertificationOnUserId {
        @NotNull
        private final CharSequence userId;
        @NotNull
        private final OpenPGPCertificate certificate;
        @NotNull
        private final CertificationType certificationType;
        @NotNull
        private final PGPainless api;

        public CertificationOnUserId(@NotNull CharSequence userId, @NotNull OpenPGPCertificate certificate, @NotNull CertificationType certificationType, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)((Object)certificationType), (String)"certificationType");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.userId = userId;
            this.certificate = certificate;
            this.certificationType = certificationType;
            this.api = api;
        }

        @Deprecated(message="Use primary constructor instead.")
        public CertificationOnUserId(@NotNull String userId, @NotNull PGPPublicKeyRing certificate, @NotNull CertificationType certificationType, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)((Object)certificationType), (String)"certificationType");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this((CharSequence)userId, api.toCertificate(certificate), certificationType, api);
        }

        @NotNull
        public final CertificationOnUserIdWithSubpackets withKey(@NotNull OpenPGPKey key, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            OpenPGPKey.OpenPGPSecretKey secretKey = Companion.getCertifyingSecretKey(key, this.api);
            ThirdPartyCertificationSignatureBuilder sigBuilder = new ThirdPartyCertificationSignatureBuilder(this.certificationType.asSignatureType(), secretKey, protector, this.api);
            return new CertificationOnUserIdWithSubpackets(this.certificate, this.userId, sigBuilder, this.api);
        }

        @Deprecated(message="Pass in an OpenPGPKey instead of a PGPSecretKeyRing.")
        @NotNull
        public final CertificationOnUserIdWithSubpackets withKey(@NotNull PGPSecretKeyRing certificationKey, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter((Object)certificationKey, (String)"certificationKey");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            return this.withKey(this.api.toKey(certificationKey), protector);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB%\u0012\u0006\u0010\u0002\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$CertificationOnUserIdWithSubpackets;", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "userId", "", "sigBuilder", "Lorg/pgpainless/signature/builder/ThirdPartyCertificationSignatureBuilder;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Ljava/lang/String;Lorg/pgpainless/signature/builder/ThirdPartyCertificationSignatureBuilder;Lorg/pgpainless/PGPainless;)V", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Ljava/lang/CharSequence;Lorg/pgpainless/signature/builder/ThirdPartyCertificationSignatureBuilder;Lorg/pgpainless/PGPainless;)V", "build", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationResult;", "buildWithSubpackets", "subpacketCallback", "Lorg/pgpainless/signature/subpackets/CertificationSubpackets$Callback;", "pgpainless-core"})
    public static final class CertificationOnUserIdWithSubpackets {
        @NotNull
        private final OpenPGPCertificate certificate;
        @NotNull
        private final CharSequence userId;
        @NotNull
        private final ThirdPartyCertificationSignatureBuilder sigBuilder;
        @NotNull
        private final PGPainless api;

        public CertificationOnUserIdWithSubpackets(@NotNull OpenPGPCertificate certificate, @NotNull CharSequence userId, @NotNull ThirdPartyCertificationSignatureBuilder sigBuilder, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)sigBuilder, (String)"sigBuilder");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.certificate = certificate;
            this.userId = userId;
            this.sigBuilder = sigBuilder;
            this.api = api;
        }

        @Deprecated(message="Pass in an OpenPGPCertificate instead of a PGPPublicKeyRing.")
        public CertificationOnUserIdWithSubpackets(@NotNull PGPPublicKeyRing certificate, @NotNull String userId, @NotNull ThirdPartyCertificationSignatureBuilder sigBuilder, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)sigBuilder, (String)"sigBuilder");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this(api.toCertificate(certificate), (CharSequence)userId, sigBuilder, api);
        }

        @NotNull
        public final CertificationResult buildWithSubpackets(@NotNull CertificationSubpackets.Callback subpacketCallback) {
            Intrinsics.checkNotNullParameter((Object)subpacketCallback, (String)"subpacketCallback");
            this.sigBuilder.applyCallback(subpacketCallback);
            return this.build();
        }

        @NotNull
        public final CertificationResult build() {
            OpenPGPSignature signature = this.sigBuilder.build(this.certificate, this.userId);
            PGPKeyRing pGPKeyRing = (PGPKeyRing)this.certificate.getPGPPublicKeyRing();
            PGPSignature pGPSignature = signature.getSignature();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
            PGPKeyRing pGPKeyRing2 = KeyRingUtils.Companion.injectCertification(pGPKeyRing, this.userId, pGPSignature);
            Intrinsics.checkNotNullExpressionValue((Object)pGPKeyRing2, (String)"injectCertification(...)");
            OpenPGPCertificate certifiedCertificate = this.api.toCertificate((PGPPublicKeyRing)pGPKeyRing2);
            return new CertificationResult(certifiedCertificate, signature);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$CertificationResult;", "", "certifiedCertificate", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "certification", "Lorg/bouncycastle/openpgp/api/OpenPGPSignature;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Lorg/bouncycastle/openpgp/api/OpenPGPSignature;)V", "getCertification", "()Lorg/bouncycastle/openpgp/api/OpenPGPSignature;", "getCertifiedCertificate", "()Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "pgpSignature", "Lorg/bouncycastle/openpgp/PGPSignature;", "getPgpSignature", "()Lorg/bouncycastle/openpgp/PGPSignature;", "publicKeyRing", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getPublicKeyRing", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "pgpainless-core"})
    public static final class CertificationResult {
        @NotNull
        private final OpenPGPCertificate certifiedCertificate;
        @NotNull
        private final OpenPGPSignature certification;
        @NotNull
        private final PGPPublicKeyRing publicKeyRing;
        @NotNull
        private final PGPSignature pgpSignature;

        public CertificationResult(@NotNull OpenPGPCertificate certifiedCertificate, @NotNull OpenPGPSignature certification) {
            Intrinsics.checkNotNullParameter((Object)certifiedCertificate, (String)"certifiedCertificate");
            Intrinsics.checkNotNullParameter((Object)certification, (String)"certification");
            this.certifiedCertificate = certifiedCertificate;
            this.certification = certification;
            PGPPublicKeyRing pGPPublicKeyRing = this.certifiedCertificate.getPGPPublicKeyRing();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing, (String)"getPGPPublicKeyRing(...)");
            this.publicKeyRing = pGPPublicKeyRing;
            PGPSignature pGPSignature = this.certification.getSignature();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
            this.pgpSignature = pGPSignature;
        }

        @NotNull
        public final OpenPGPCertificate getCertifiedCertificate() {
            return this.certifiedCertificate;
        }

        @NotNull
        public final OpenPGPSignature getCertification() {
            return this.certification;
        }

        @NotNull
        public final PGPPublicKeyRing getPublicKeyRing() {
            return this.publicKeyRing;
        }

        @NotNull
        public final PGPSignature getPgpSignature() {
            return this.pgpSignature;
        }

        @NotNull
        public final OpenPGPCertificate component1() {
            return this.certifiedCertificate;
        }

        @NotNull
        public final OpenPGPSignature component2() {
            return this.certification;
        }

        @NotNull
        public final CertificationResult copy(@NotNull OpenPGPCertificate certifiedCertificate, @NotNull OpenPGPSignature certification) {
            Intrinsics.checkNotNullParameter((Object)certifiedCertificate, (String)"certifiedCertificate");
            Intrinsics.checkNotNullParameter((Object)certification, (String)"certification");
            return new CertificationResult(certifiedCertificate, certification);
        }

        public static /* synthetic */ CertificationResult copy$default(CertificationResult certificationResult, OpenPGPCertificate openPGPCertificate, OpenPGPSignature openPGPSignature, int n, Object object) {
            if ((n & 1) != 0) {
                openPGPCertificate = certificationResult.certifiedCertificate;
            }
            if ((n & 2) != 0) {
                openPGPSignature = certificationResult.certification;
            }
            return certificationResult.copy(openPGPCertificate, openPGPSignature);
        }

        @NotNull
        public String toString() {
            return "CertificationResult(certifiedCertificate=" + this.certifiedCertificate + ", certification=" + this.certification + ")";
        }

        public int hashCode() {
            int result = this.certifiedCertificate.hashCode();
            result = result * 31 + this.certification.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CertificationResult)) {
                return false;
            }
            CertificationResult certificationResult = (CertificationResult)other;
            if (!Intrinsics.areEqual((Object)this.certifiedCertificate, (Object)certificationResult.certifiedCertificate)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.certification, (Object)certificationResult.certification);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003\u00a8\u0006\t"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$Companion;", "", "()V", "getCertifyingSecretKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "certificationKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "api", "Lorg/pgpainless/PGPainless;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nCertifyCertificate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertifyCertificate.kt\norg/pgpainless/key/certification/CertifyCertificate$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,471:1\n1#2:472\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final OpenPGPKey.OpenPGPSecretKey getCertifyingSecretKey(OpenPGPKey certificationKey, PGPainless api) {
            OpenPgpFingerprint fingerprint;
            Date now = new Date();
            KeyRingInfo info = api.inspect((OpenPGPCertificate)certificationKey, now);
            OpenPGPCertificate.OpenPGPComponentKey certificationPubKey = info.getPublicKey(fingerprint = info.getFingerprint());
            if (certificationPubKey == null) {
                boolean $i$a$-requireNotNull-CertifyCertificate$Companion$getCertifyingSecretKey$22 = false;
                String $i$a$-requireNotNull-CertifyCertificate$Companion$getCertifyingSecretKey$22 = "Primary key cannot be null.";
                throw new IllegalArgumentException($i$a$-requireNotNull-CertifyCertificate$Companion$getCertifyingSecretKey$22.toString());
            }
            KeyIdentifier keyIdentifier = certificationPubKey.getKeyIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
            if (!info.isKeyValidlyBound(keyIdentifier)) {
                throw new KeyException.RevokedKeyException(fingerprint);
            }
            if (!info.isUsableForThirdPartyCertification()) {
                throw new KeyException.UnacceptableThirdPartyCertificationKeyException(fingerprint);
            }
            Date expirationDate = info.getExpirationDateForUse(KeyFlag.CERTIFY_OTHER);
            if (expirationDate != null && expirationDate.compareTo(now) < 0) {
                throw new KeyException.ExpiredKeyException(fingerprint, expirationDate);
            }
            OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = certificationKey.getSecretKey(certificationPubKey.getKeyIdentifier());
            if (openPGPSecretKey == null) {
                KeyIdentifier keyIdentifier2 = certificationPubKey.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier2, (String)"getKeyIdentifier(...)");
                throw new KeyException.MissingSecretKeyException(fingerprint, keyIdentifier2);
            }
            return openPGPSecretKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$DelegationOnCertificate;", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "trustworthiness", "Lorg/pgpainless/algorithm/Trustworthiness;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Lorg/pgpainless/algorithm/Trustworthiness;Lorg/pgpainless/PGPainless;)V", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Lorg/pgpainless/algorithm/Trustworthiness;Lorg/pgpainless/PGPainless;)V", "withKey", "Lorg/pgpainless/key/certification/CertifyCertificate$DelegationOnCertificateWithSubpackets;", "certificationKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "pgpainless-core"})
    public static final class DelegationOnCertificate {
        @NotNull
        private final OpenPGPCertificate certificate;
        @Nullable
        private final Trustworthiness trustworthiness;
        @NotNull
        private final PGPainless api;

        public DelegationOnCertificate(@NotNull OpenPGPCertificate certificate, @Nullable Trustworthiness trustworthiness, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.certificate = certificate;
            this.trustworthiness = trustworthiness;
            this.api = api;
        }

        @Deprecated(message="Pass in an OpenPGPCertificate instead of PGPPublicKeyRing.")
        public DelegationOnCertificate(@NotNull PGPPublicKeyRing certificate, @Nullable Trustworthiness trustworthiness, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this(api.toCertificate(certificate), trustworthiness, api);
        }

        @NotNull
        public final DelegationOnCertificateWithSubpackets withKey(@NotNull OpenPGPKey key, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            OpenPGPKey.OpenPGPSecretKey secretKey = Companion.getCertifyingSecretKey(key, this.api);
            ThirdPartyDirectKeySignatureBuilder sigBuilder = new ThirdPartyDirectKeySignatureBuilder(secretKey, protector, this.api);
            if (this.trustworthiness != null) {
                sigBuilder.getHashedSubpackets().setTrust(true, this.trustworthiness.getDepth(), this.trustworthiness.getAmount());
            }
            return new DelegationOnCertificateWithSubpackets(this.certificate, sigBuilder, this.api);
        }

        @Deprecated(message="Pass in an OpenPGPKey instead of PGPSecretKeyRing.")
        @NotNull
        public final DelegationOnCertificateWithSubpackets withKey(@NotNull PGPSecretKeyRing certificationKey, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter((Object)certificationKey, (String)"certificationKey");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            return this.withKey(this.api.toKey(certificationKey), protector);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$DelegationOnCertificateWithSubpackets;", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "sigBuilder", "Lorg/pgpainless/signature/builder/ThirdPartyDirectKeySignatureBuilder;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Lorg/pgpainless/signature/builder/ThirdPartyDirectKeySignatureBuilder;Lorg/pgpainless/PGPainless;)V", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Lorg/pgpainless/signature/builder/ThirdPartyDirectKeySignatureBuilder;Lorg/pgpainless/PGPainless;)V", "build", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationResult;", "buildWithSubpackets", "subpacketsCallback", "Lorg/pgpainless/signature/subpackets/CertificationSubpackets$Callback;", "pgpainless-core"})
    public static final class DelegationOnCertificateWithSubpackets {
        @NotNull
        private final OpenPGPCertificate certificate;
        @NotNull
        private final ThirdPartyDirectKeySignatureBuilder sigBuilder;
        @NotNull
        private final PGPainless api;

        public DelegationOnCertificateWithSubpackets(@NotNull OpenPGPCertificate certificate, @NotNull ThirdPartyDirectKeySignatureBuilder sigBuilder, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)sigBuilder, (String)"sigBuilder");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.certificate = certificate;
            this.sigBuilder = sigBuilder;
            this.api = api;
        }

        @Deprecated(message="Pass in an OpenPGPCertificate instead of a PGPPublicKeyRing.")
        public DelegationOnCertificateWithSubpackets(@NotNull PGPPublicKeyRing certificate, @NotNull ThirdPartyDirectKeySignatureBuilder sigBuilder, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)sigBuilder, (String)"sigBuilder");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this(api.toCertificate(certificate), sigBuilder, api);
        }

        @NotNull
        public final CertificationResult buildWithSubpackets(@NotNull CertificationSubpackets.Callback subpacketsCallback) {
            Intrinsics.checkNotNullParameter((Object)subpacketsCallback, (String)"subpacketsCallback");
            this.sigBuilder.applyCallback(subpacketsCallback);
            return this.build();
        }

        @NotNull
        public final CertificationResult build() {
            OpenPGPCertificate.OpenPGPPrimaryKey delegatedKey = this.certificate.getPrimaryKey();
            Intrinsics.checkNotNull((Object)delegatedKey);
            OpenPGPSignature delegation = this.sigBuilder.build((OpenPGPCertificate.OpenPGPComponentKey)delegatedKey);
            PGPKeyRing pGPKeyRing = (PGPKeyRing)this.certificate.getPGPPublicKeyRing();
            PGPPublicKey pGPPublicKey = delegatedKey.getPGPPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
            PGPSignature pGPSignature = delegation.getSignature();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
            PGPKeyRing pGPKeyRing2 = KeyRingUtils.Companion.injectCertification(pGPKeyRing, pGPPublicKey, pGPSignature);
            Intrinsics.checkNotNullExpressionValue((Object)pGPKeyRing2, (String)"injectCertification(...)");
            OpenPGPCertificate delegatedCertificate = this.api.toCertificate((PGPPublicKeyRing)pGPKeyRing2);
            return new CertificationResult(delegatedCertificate, delegation);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$RevocationOnCertificate;", "", "certificate", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Lorg/pgpainless/PGPainless;)V", "withKey", "Lorg/pgpainless/key/certification/CertifyCertificate$RevocationOnCertificateWithSubpackets;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "pgpainless-core"})
    public static final class RevocationOnCertificate {
        @NotNull
        private final OpenPGPCertificate certificate;
        @NotNull
        private final PGPainless api;

        public RevocationOnCertificate(@NotNull OpenPGPCertificate certificate, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.certificate = certificate;
            this.api = api;
        }

        @NotNull
        public final RevocationOnCertificateWithSubpackets withKey(@NotNull OpenPGPKey key, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            OpenPGPKey.OpenPGPSecretKey secretKey = Companion.getCertifyingSecretKey(key, this.api);
            RevocationSignatureBuilder sigBuilder = new RevocationSignatureBuilder(SignatureType.KEY_REVOCATION, secretKey, protector, this.api);
            return new RevocationOnCertificateWithSubpackets(this.certificate, sigBuilder, this.api);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$RevocationOnCertificateWithSubpackets;", "", "certificate", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "sigBuilder", "Lorg/pgpainless/signature/builder/RevocationSignatureBuilder;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Lorg/pgpainless/signature/builder/RevocationSignatureBuilder;Lorg/pgpainless/PGPainless;)V", "build", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationResult;", "buildWithSubpackets", "subpacketsCallback", "Lorg/pgpainless/signature/subpackets/RevocationSignatureSubpackets$Callback;", "pgpainless-core"})
    public static final class RevocationOnCertificateWithSubpackets {
        @NotNull
        private final OpenPGPCertificate certificate;
        @NotNull
        private final RevocationSignatureBuilder sigBuilder;
        @NotNull
        private final PGPainless api;

        public RevocationOnCertificateWithSubpackets(@NotNull OpenPGPCertificate certificate, @NotNull RevocationSignatureBuilder sigBuilder, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)sigBuilder, (String)"sigBuilder");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.certificate = certificate;
            this.sigBuilder = sigBuilder;
            this.api = api;
        }

        @NotNull
        public final CertificationResult buildWithSubpackets(@NotNull RevocationSignatureSubpackets.Callback subpacketsCallback) {
            Intrinsics.checkNotNullParameter((Object)subpacketsCallback, (String)"subpacketsCallback");
            this.sigBuilder.applyCallback(subpacketsCallback);
            return this.build();
        }

        @NotNull
        public final CertificationResult build() {
            OpenPGPCertificate.OpenPGPPrimaryKey revokedKey = this.certificate.getPrimaryKey();
            Intrinsics.checkNotNull((Object)revokedKey);
            OpenPGPSignature revocation = this.sigBuilder.build((OpenPGPCertificate.OpenPGPComponentKey)revokedKey);
            PGPKeyRing pGPKeyRing = (PGPKeyRing)this.certificate.getPGPPublicKeyRing();
            PGPPublicKey pGPPublicKey = revokedKey.getPGPPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPGPPublicKey(...)");
            PGPSignature pGPSignature = revocation.getSignature();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
            PGPKeyRing pGPKeyRing2 = KeyRingUtils.Companion.injectCertification(pGPKeyRing, pGPPublicKey, pGPSignature);
            Intrinsics.checkNotNullExpressionValue((Object)pGPKeyRing2, (String)"injectCertification(...)");
            OpenPGPCertificate revokedCertificate = this.api.toCertificate((PGPPublicKeyRing)pGPKeyRing2);
            return new CertificationResult(revokedCertificate, revocation);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$RevocationOnUserId;", "", "userId", "", "certificate", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "api", "Lorg/pgpainless/PGPainless;", "(Ljava/lang/CharSequence;Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Lorg/pgpainless/PGPainless;)V", "withKey", "Lorg/pgpainless/key/certification/CertifyCertificate$RevocationOnUserIdWithSubpackets;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "pgpainless-core"})
    public static final class RevocationOnUserId {
        @NotNull
        private final CharSequence userId;
        @NotNull
        private final OpenPGPCertificate certificate;
        @NotNull
        private final PGPainless api;

        public RevocationOnUserId(@NotNull CharSequence userId, @NotNull OpenPGPCertificate certificate, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.userId = userId;
            this.certificate = certificate;
            this.api = api;
        }

        @NotNull
        public final RevocationOnUserIdWithSubpackets withKey(@NotNull OpenPGPKey key, @NotNull SecretKeyRingProtector protector) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
            OpenPGPKey.OpenPGPSecretKey secretKey = Companion.getCertifyingSecretKey(key, this.api);
            RevocationSignatureBuilder sigBuilder = new RevocationSignatureBuilder(SignatureType.CERTIFICATION_REVOCATION, secretKey, protector, this.api);
            return new RevocationOnUserIdWithSubpackets(this.certificate, this.userId, sigBuilder, this.api);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/key/certification/CertifyCertificate$RevocationOnUserIdWithSubpackets;", "", "certificate", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "userId", "", "sigBuilder", "Lorg/pgpainless/signature/builder/RevocationSignatureBuilder;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Ljava/lang/CharSequence;Lorg/pgpainless/signature/builder/RevocationSignatureBuilder;Lorg/pgpainless/PGPainless;)V", "build", "Lorg/pgpainless/key/certification/CertifyCertificate$CertificationResult;", "buildWithSubpackets", "subpacketCallback", "Lorg/pgpainless/signature/subpackets/RevocationSignatureSubpackets$Callback;", "pgpainless-core"})
    public static final class RevocationOnUserIdWithSubpackets {
        @NotNull
        private final OpenPGPCertificate certificate;
        @NotNull
        private final CharSequence userId;
        @NotNull
        private final RevocationSignatureBuilder sigBuilder;
        @NotNull
        private final PGPainless api;

        public RevocationOnUserIdWithSubpackets(@NotNull OpenPGPCertificate certificate, @NotNull CharSequence userId, @NotNull RevocationSignatureBuilder sigBuilder, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)sigBuilder, (String)"sigBuilder");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.certificate = certificate;
            this.userId = userId;
            this.sigBuilder = sigBuilder;
            this.api = api;
        }

        @NotNull
        public final CertificationResult buildWithSubpackets(@NotNull RevocationSignatureSubpackets.Callback subpacketCallback) {
            Intrinsics.checkNotNullParameter((Object)subpacketCallback, (String)"subpacketCallback");
            this.sigBuilder.applyCallback(subpacketCallback);
            return this.build();
        }

        @NotNull
        public final CertificationResult build() {
            OpenPGPCertificate.OpenPGPPrimaryKey openPGPPrimaryKey = this.certificate.getPrimaryKey();
            Intrinsics.checkNotNullExpressionValue((Object)openPGPPrimaryKey, (String)"getPrimaryKey(...)");
            OpenPGPCertificate.OpenPGPComponentSignature signature = this.sigBuilder.build((OpenPGPCertificate.OpenPGPComponentKey)openPGPPrimaryKey, this.userId);
            PGPKeyRing pGPKeyRing = (PGPKeyRing)this.certificate.getPGPPublicKeyRing();
            PGPSignature pGPSignature = signature.getSignature();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
            PGPKeyRing pGPKeyRing2 = KeyRingUtils.Companion.injectCertification(pGPKeyRing, this.userId, pGPSignature);
            Intrinsics.checkNotNullExpressionValue((Object)pGPKeyRing2, (String)"injectCertification(...)");
            OpenPGPCertificate certifiedCertificate = this.api.toCertificate((PGPPublicKeyRing)pGPKeyRing2);
            return new CertificationResult(certifiedCertificate, (OpenPGPSignature)signature);
        }
    }
}

