/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.exception;

import java.util.Date;
import javax.annotation.Nonnull;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.util.DateUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\r\b&\u0018\u00002\u00060\u0001j\u0002`\u0002:\t\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015B\u0017\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/pgpainless/exception/KeyException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "(Ljava/lang/String;Lorg/pgpainless/key/OpenPgpFingerprint;)V", "underlying", "", "(Ljava/lang/String;Lorg/pgpainless/key/OpenPgpFingerprint;Ljava/lang/Throwable;)V", "getFingerprint", "()Lorg/pgpainless/key/OpenPgpFingerprint;", "ExpiredKeyException", "MissingSecretKeyException", "PublicKeyAlgorithmPolicyException", "RevokedKeyException", "UnacceptableEncryptionKeyException", "UnacceptableSelfSignatureException", "UnacceptableSigningKeyException", "UnacceptableThirdPartyCertificationKeyException", "UnboundUserIdException", "pgpainless-core"})
public abstract class KeyException
extends RuntimeException {
    @NotNull
    private final OpenPgpFingerprint fingerprint;

    @NotNull
    public final OpenPgpFingerprint getFingerprint() {
        return this.fingerprint;
    }

    protected KeyException(@NotNull String message, @NotNull OpenPgpFingerprint fingerprint) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        super(message);
        this.fingerprint = fingerprint;
    }

    protected KeyException(@NotNull String message, @NotNull OpenPgpFingerprint fingerprint, @NotNull Throwable underlying) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        super(message, underlying);
        this.fingerprint = fingerprint;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/pgpainless/exception/KeyException$ExpiredKeyException;", "Lorg/pgpainless/exception/KeyException;", "cert", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "expirationDate", "Ljava/util/Date;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Ljava/util/Date;)V", "componentKey", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;Ljava/util/Date;)V", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "(Lorg/pgpainless/key/OpenPgpFingerprint;Ljava/util/Date;)V", "pgpainless-core"})
    public static final class ExpiredKeyException
    extends KeyException {
        public ExpiredKeyException(@NotNull OpenPgpFingerprint fingerprint, @NotNull Date expirationDate) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Intrinsics.checkNotNullParameter((Object)expirationDate, (String)"expirationDate");
            super("Key " + fingerprint + " is expired. Expiration date: " + DateUtil.Companion.formatUTCDate(expirationDate), fingerprint);
        }

        public ExpiredKeyException(@NotNull OpenPGPCertificate cert, @NotNull Date expirationDate) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            Intrinsics.checkNotNullParameter((Object)expirationDate, (String)"expirationDate");
            this(OpenPgpFingerprint.Companion.of(cert), expirationDate);
        }

        public ExpiredKeyException(@NotNull OpenPGPCertificate.OpenPGPComponentKey componentKey, @NotNull Date expirationDate) {
            Intrinsics.checkNotNullParameter((Object)componentKey, (String)"componentKey");
            Intrinsics.checkNotNullParameter((Object)expirationDate, (String)"expirationDate");
            this(OpenPgpFingerprint.Companion.of(componentKey), expirationDate);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/exception/KeyException$MissingSecretKeyException;", "Lorg/pgpainless/exception/KeyException;", "publicKey", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;)V", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "keyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "(Lorg/pgpainless/key/OpenPgpFingerprint;Lorg/bouncycastle/bcpg/KeyIdentifier;)V", "keyId", "", "(Lorg/pgpainless/key/OpenPgpFingerprint;J)V", "missingSecretKeyIdentifier", "getMissingSecretKeyIdentifier", "()Lorg/bouncycastle/bcpg/KeyIdentifier;", "pgpainless-core"})
    public static final class MissingSecretKeyException
    extends KeyException {
        @NotNull
        private final KeyIdentifier missingSecretKeyIdentifier;

        @NotNull
        public final KeyIdentifier getMissingSecretKeyIdentifier() {
            return this.missingSecretKeyIdentifier;
        }

        public MissingSecretKeyException(@NotNull OpenPGPCertificate.OpenPGPComponentKey publicKey) {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            OpenPGPCertificate openPGPCertificate = publicKey.getCertificate();
            Intrinsics.checkNotNullExpressionValue((Object)openPGPCertificate, (String)"getCertificate(...)");
            OpenPgpFingerprint openPgpFingerprint = OpenPgpFingerprint.Companion.of(openPGPCertificate);
            KeyIdentifier keyIdentifier = publicKey.getKeyIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
            this(openPgpFingerprint, keyIdentifier);
        }

        public MissingSecretKeyException(@NotNull OpenPgpFingerprint fingerprint, @NotNull KeyIdentifier keyIdentifier) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Intrinsics.checkNotNullParameter((Object)keyIdentifier, (String)"keyIdentifier");
            super("Key " + fingerprint + " does not contain a secret key for public key " + keyIdentifier, fingerprint);
            this.missingSecretKeyIdentifier = keyIdentifier;
        }

        @Deprecated(message="Pass in a KeyIdentifier instead.")
        public MissingSecretKeyException(@NotNull OpenPgpFingerprint fingerprint, long keyId) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            this(fingerprint, new KeyIdentifier(keyId));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/pgpainless/exception/KeyException$PublicKeyAlgorithmPolicyException;", "Lorg/pgpainless/exception/KeyException;", "subkey", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "algorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "bitSize", "", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;Lorg/pgpainless/algorithm/PublicKeyAlgorithm;I)V", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "keyId", "", "(Lorg/pgpainless/key/OpenPgpFingerprint;JLorg/pgpainless/algorithm/PublicKeyAlgorithm;I)V", "violatingSubkeyId", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "getViolatingSubkeyId", "()Lorg/bouncycastle/bcpg/KeyIdentifier;", "pgpainless-core"})
    public static final class PublicKeyAlgorithmPolicyException
    extends KeyException {
        @NotNull
        private final KeyIdentifier violatingSubkeyId;

        @NotNull
        public final KeyIdentifier getViolatingSubkeyId() {
            return this.violatingSubkeyId;
        }

        public PublicKeyAlgorithmPolicyException(@NotNull OpenPGPCertificate.OpenPGPComponentKey subkey, @NotNull PublicKeyAlgorithm algorithm, int bitSize) {
            Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
            Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
            super("Subkey " + subkey.getKeyIdentifier() + " of key " + subkey.getCertificate().getKeyIdentifier() + " is violating the Public Key Algorithm Policy:\n" + algorithm + " of size " + bitSize + " is not acceptable.", OpenPgpFingerprint.Companion.of(subkey));
            KeyIdentifier keyIdentifier = subkey.getKeyIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
            this.violatingSubkeyId = keyIdentifier;
        }

        public PublicKeyAlgorithmPolicyException(@NotNull OpenPgpFingerprint fingerprint, long keyId, @NotNull PublicKeyAlgorithm algorithm, int bitSize) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
            super("Subkey " + Long.toHexString(keyId) + " of key " + fingerprint + " is violating the Public Key Algorithm Policy:\n" + algorithm + " of size " + bitSize + " is not acceptable.", fingerprint);
            this.violatingSubkeyId = new KeyIdentifier(keyId);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/exception/KeyException$RevokedKeyException;", "Lorg/pgpainless/exception/KeyException;", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "(Lorg/pgpainless/key/OpenPgpFingerprint;)V", "componentKey", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;)V", "cert", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;)V", "pgpainless-core"})
    public static final class RevokedKeyException
    extends KeyException {
        public RevokedKeyException(@NotNull OpenPgpFingerprint fingerprint) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            super("Key " + fingerprint + " appears to be revoked.", fingerprint);
        }

        public RevokedKeyException(@NotNull OpenPGPCertificate.OpenPGPComponentKey componentKey) {
            Intrinsics.checkNotNullParameter((Object)componentKey, (String)"componentKey");
            super("Subkey " + componentKey.getKeyIdentifier() + " appears to be revoked.", OpenPgpFingerprint.Companion.of(componentKey));
        }

        public RevokedKeyException(@NotNull OpenPGPCertificate cert) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            super("Key or certificate " + cert.getKeyIdentifier() + " appears to be revoked.", OpenPgpFingerprint.Companion.of(cert));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/pgpainless/exception/KeyException$UnacceptableEncryptionKeyException;", "Lorg/pgpainless/exception/KeyException;", "cert", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;)V", "subkey", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;)V", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "(Lorg/pgpainless/key/OpenPgpFingerprint;)V", "reason", "Lorg/pgpainless/exception/KeyException$PublicKeyAlgorithmPolicyException;", "(Lorg/pgpainless/exception/KeyException$PublicKeyAlgorithmPolicyException;)V", "pgpainless-core"})
    public static final class UnacceptableEncryptionKeyException
    extends KeyException {
        public UnacceptableEncryptionKeyException(@NotNull OpenPGPCertificate cert) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            this(OpenPgpFingerprint.Companion.of(cert));
        }

        public UnacceptableEncryptionKeyException(@NotNull OpenPGPCertificate.OpenPGPComponentKey subkey) {
            Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
            super("Subkey " + subkey.getKeyIdentifier() + " is not an acceptable encryption key.", OpenPgpFingerprint.Companion.of(subkey));
        }

        public UnacceptableEncryptionKeyException(@NotNull OpenPgpFingerprint fingerprint) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            super("Key " + fingerprint + " has no acceptable encryption key.", fingerprint);
        }

        public UnacceptableEncryptionKeyException(@NotNull PublicKeyAlgorithmPolicyException reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super("Key " + reason.getFingerprint() + " has no acceptable encryption key.", reason.getFingerprint(), reason);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/pgpainless/exception/KeyException$UnacceptableSelfSignatureException;", "Lorg/pgpainless/exception/KeyException;", "cert", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;)V", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "(Lorg/pgpainless/key/OpenPgpFingerprint;)V", "pgpainless-core"})
    public static final class UnacceptableSelfSignatureException
    extends KeyException {
        public UnacceptableSelfSignatureException(@NotNull OpenPGPCertificate cert) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            this(OpenPgpFingerprint.Companion.of(cert));
        }

        public UnacceptableSelfSignatureException(@NotNull OpenPgpFingerprint fingerprint) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            super("Key " + fingerprint + " does not have a valid/acceptable signature to derive an expiration date from.", fingerprint);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/pgpainless/exception/KeyException$UnacceptableSigningKeyException;", "Lorg/pgpainless/exception/KeyException;", "cert", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;)V", "subkey", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "(Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;)V", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "(Lorg/pgpainless/key/OpenPgpFingerprint;)V", "reason", "Lorg/pgpainless/exception/KeyException$PublicKeyAlgorithmPolicyException;", "(Lorg/pgpainless/exception/KeyException$PublicKeyAlgorithmPolicyException;)V", "pgpainless-core"})
    public static final class UnacceptableSigningKeyException
    extends KeyException {
        public UnacceptableSigningKeyException(@NotNull OpenPGPCertificate cert) {
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            this(OpenPgpFingerprint.Companion.of(cert));
        }

        public UnacceptableSigningKeyException(@NotNull OpenPGPCertificate.OpenPGPComponentKey subkey) {
            Intrinsics.checkNotNullParameter((Object)subkey, (String)"subkey");
            this(OpenPgpFingerprint.Companion.of(subkey));
        }

        public UnacceptableSigningKeyException(@NotNull OpenPgpFingerprint fingerprint) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            super("Key " + fingerprint + " has no acceptable signing key.", fingerprint);
        }

        public UnacceptableSigningKeyException(@NotNull PublicKeyAlgorithmPolicyException reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super("Key " + reason.getFingerprint() + " has no acceptable signing key.", reason.getFingerprint(), reason);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/exception/KeyException$UnacceptableThirdPartyCertificationKeyException;", "Lorg/pgpainless/exception/KeyException;", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "(Lorg/pgpainless/key/OpenPgpFingerprint;)V", "pgpainless-core"})
    public static final class UnacceptableThirdPartyCertificationKeyException
    extends KeyException {
        public UnacceptableThirdPartyCertificationKeyException(@NotNull OpenPgpFingerprint fingerprint) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            super("Key " + fingerprint + " has no acceptable certification key.", fingerprint);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u0001:\u0001\nB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/exception/KeyException$UnboundUserIdException;", "Lorg/pgpainless/exception/KeyException;", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "userId", "", "userIdSignature", "Lorg/bouncycastle/openpgp/PGPSignature;", "userIdRevocation", "(Lorg/pgpainless/key/OpenPgpFingerprint;Ljava/lang/String;Lorg/bouncycastle/openpgp/PGPSignature;Lorg/bouncycastle/openpgp/PGPSignature;)V", "Companion", "pgpainless-core"})
    public static final class UnboundUserIdException
    extends KeyException {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public UnboundUserIdException(@NotNull OpenPgpFingerprint fingerprint, @NotNull String userId, @Nullable PGPSignature userIdSignature, @Nullable PGPSignature userIdRevocation) {
            Intrinsics.checkNotNullParameter((Object)fingerprint, (String)"fingerprint");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            super(UnboundUserIdException.Companion.errorMessage(fingerprint, userId, userIdSignature, userIdRevocation), fingerprint);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/exception/KeyException$UnboundUserIdException$Companion;", "", "()V", "errorMessage", "", "fingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "userId", "userIdSignature", "Lorg/bouncycastle/openpgp/PGPSignature;", "userIdRevocation", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            private final String errorMessage(@Nonnull OpenPgpFingerprint fingerprint, @Nonnull String userId, PGPSignature userIdSignature, PGPSignature userIdRevocation) {
                String errorMessage = "UserID '" + userId + "' is not valid for key " + fingerprint + ": ";
                if (userIdSignature == null) {
                    return errorMessage + "Missing binding signature.";
                }
                if (userIdRevocation != null) {
                    return errorMessage + "UserID is revoked.";
                }
                return errorMessage + "Unacceptable binding signature.";
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

