/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.KeyPassphraseProvider;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.HashAlgorithmNegotiator;
import org.pgpainless.exception.KeyException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u0001:\u0002?@B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007J:\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010\"\u001a\u00020#2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010%H\u0007J \u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0007J:\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020)2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010*2\b\b\u0002\u0010\"\u001a\u00020#2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010%H\u0007J \u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020)2\b\b\u0002\u0010\"\u001a\u00020#J:\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020+2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010*2\b\b\u0002\u0010\"\u001a\u00020#2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010%H\u0007J&\u0010,\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0.2\u0006\u0010\"\u001a\u00020#H\u0007J:\u0010/\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010*2\b\b\u0002\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007J6\u0010/\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007J \u0010/\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0007J:\u0010/\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020)2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010*2\b\b\u0002\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007J \u0010/\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020)2\b\b\u0002\u0010\"\u001a\u00020#J.\u0010/\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020+2\b\b\u0002\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0007J&\u00100\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0.2\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u00101\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0016\u00101\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020)J4\u00102\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u00104\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#2\u0006\u00105\u001a\u0002062\n\b\u0002\u0010(\u001a\u0004\u0018\u00010%H\u0002J \u00107\u001a\u0002082\u0006\u0010\u001e\u001a\u0002092\u0006\u00104\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010:\u001a\u00020\b2\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010<H\u0002J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010>\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006A"}, d2={"Lorg/pgpainless/encryption_signing/SigningOptions;", "", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "_evaluationDate", "Ljava/util/Date;", "_hashAlgorithmOverride", "Lorg/pgpainless/algorithm/HashAlgorithm;", "evaluationDate", "getEvaluationDate", "()Ljava/util/Date;", "hashAlgorithmNegotiator", "Lorg/pgpainless/algorithm/negotiation/HashAlgorithmNegotiator;", "getHashAlgorithmNegotiator", "()Lorg/pgpainless/algorithm/negotiation/HashAlgorithmNegotiator;", "setHashAlgorithmNegotiator", "(Lorg/pgpainless/algorithm/negotiation/HashAlgorithmNegotiator;)V", "hashAlgorithmOverride", "getHashAlgorithmOverride", "()Lorg/pgpainless/algorithm/HashAlgorithm;", "signingMethods", "", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPPrivateKey;", "Lorg/pgpainless/encryption_signing/SigningOptions$SigningMethod;", "getSigningMethods", "()Ljava/util/Map;", "addDetachedSignature", "signingKeyProtector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "signingKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "keyId", "", "signatureType", "Lorg/pgpainless/algorithm/DocumentSignatureType;", "subpacketsCallback", "Lorg/pgpainless/signature/subpackets/BaseSignatureSubpackets$Callback;", "userId", "", "subpacketCallback", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "addDetachedSignatures", "signingKeys", "", "addInlineSignature", "addInlineSignatures", "addSignature", "addSigningMethod", "", "hashAlgorithm", "detached", "", "createSignatureGenerator", "Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "Lorg/bouncycastle/openpgp/PGPKeyPair;", "negotiateHashAlgorithm", "preferences", "", "overrideHashAlgorithm", "setEvaluationDate", "Companion", "SigningMethod", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nSigningOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SigningOptions.kt\norg/pgpainless/encryption_signing/SigningOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,627:1\n1#2:628\n1855#3,2:629\n1747#3,3:631\n1855#3,2:634\n*S KotlinDebug\n*F\n+ 1 SigningOptions.kt\norg/pgpainless/encryption_signing/SigningOptions\n*L\n117#1:629,2\n267#1:631,3\n333#1:634,2\n*E\n"})
public final class SigningOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PGPainless api;
    @NotNull
    private HashAlgorithmNegotiator hashAlgorithmNegotiator;
    @NotNull
    private final Map<OpenPGPKey.OpenPGPPrivateKey, SigningMethod> signingMethods;
    @Nullable
    private HashAlgorithm _hashAlgorithmOverride;
    @NotNull
    private Date _evaluationDate;

    public SigningOptions(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
        this.hashAlgorithmNegotiator = HashAlgorithmNegotiator.Companion.negotiateSignatureHashAlgorithm(this.api.getAlgorithmPolicy());
        this.signingMethods = new LinkedHashMap();
        this._evaluationDate = new Date();
    }

    @NotNull
    public final HashAlgorithmNegotiator getHashAlgorithmNegotiator() {
        return this.hashAlgorithmNegotiator;
    }

    public final void setHashAlgorithmNegotiator(@NotNull HashAlgorithmNegotiator hashAlgorithmNegotiator) {
        Intrinsics.checkNotNullParameter((Object)hashAlgorithmNegotiator, (String)"<set-?>");
        this.hashAlgorithmNegotiator = hashAlgorithmNegotiator;
    }

    @NotNull
    public final Map<OpenPGPKey.OpenPGPPrivateKey, SigningMethod> getSigningMethods() {
        return this.signingMethods;
    }

    @Nullable
    public final HashAlgorithm getHashAlgorithmOverride() {
        return this._hashAlgorithmOverride;
    }

    @NotNull
    public final SigningOptions overrideHashAlgorithm(@NotNull HashAlgorithm hashAlgorithmOverride) {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithmOverride), (String)"hashAlgorithmOverride");
        SigningOptions $this$overrideHashAlgorithm_u24lambda_u240 = signingOptions = this;
        boolean bl = false;
        $this$overrideHashAlgorithm_u24lambda_u240._hashAlgorithmOverride = hashAlgorithmOverride;
        return signingOptions;
    }

    @NotNull
    public final Date getEvaluationDate() {
        return this._evaluationDate;
    }

    @NotNull
    public final SigningOptions setEvaluationDate(@NotNull Date evaluationDate) {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)evaluationDate, (String)"evaluationDate");
        SigningOptions $this$setEvaluationDate_u24lambda_u241 = signingOptions = this;
        boolean bl = false;
        $this$setEvaluationDate_u24lambda_u241._evaluationDate = evaluationDate;
        return signingOptions;
    }

    @NotNull
    public final SigningOptions addSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        SigningOptions $this$addSignature_u24lambda_u242 = signingOptions = this;
        boolean bl = false;
        SigningOptions.addInlineSignature$default($this$addSignature_u24lambda_u242, signingKeyProtector, signingKey, null, DocumentSignatureType.BINARY_DOCUMENT, null, 16, null);
        return signingOptions;
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @NotNull
    public final SigningOptions addSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return this.addSignature(signingKeyProtector, this.api.toKey(signingKey));
    }

    @Deprecated(message="Repeatedly call addInlineSignature(), passing an OpenPGPKey instead.")
    @NotNull
    public final SigningOptions addInlineSignatures(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull Iterable<? extends PGPSecretKeyRing> signingKeys, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKeys, (String)"signingKeys");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        SigningOptions $this$addInlineSignatures_u24lambda_u244 = signingOptions = this;
        boolean bl = false;
        Iterable<? extends PGPSecretKeyRing> $this$forEach$iv = signingKeys;
        boolean $i$f$forEach = false;
        Iterator<? extends PGPSecretKeyRing> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing element$iv;
            PGPSecretKeyRing it = element$iv = iterator.next();
            boolean bl2 = false;
            SigningOptions.addInlineSignature$default($this$addInlineSignatures_u24lambda_u244, signingKeyProtector, it, null, signatureType, null, 16, null);
        }
        return signingOptions;
    }

    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey, @NotNull DocumentSignatureType signatureType) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, null, signatureType, null, 16, null);
    }

    public static /* synthetic */ SigningOptions addInlineSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, OpenPGPKey openPGPKey, DocumentSignatureType documentSignatureType, int n, Object object) {
        if ((n & 4) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        return signingOptions.addInlineSignature(secretKeyRingProtector, openPGPKey, documentSignatureType);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return this.addInlineSignature(signingKeyProtector, this.api.toKey(signingKey), signatureType);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        SigningOptions $this$addInlineSignature_u24lambda_u245 = signingOptions = this;
        boolean bl = false;
        KeyRingInfo keyRingInfo = $this$addInlineSignature_u24lambda_u245.api.inspect((OpenPGPCertificate)signingKey, $this$addInlineSignature_u24lambda_u245.getEvaluationDate());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyException.UnboundUserIdException(OpenPgpFingerprint.Companion.of((OpenPGPCertificate)signingKey), ((Object)userId).toString(), keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<OpenPGPCertificate.OpenPGPComponentKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException((OpenPGPCertificate)signingKey);
        }
        for (OpenPGPCertificate.OpenPGPComponentKey signingPubKey : signingPubKeys) {
            Set<HashAlgorithm> set;
            OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = signingKey.getSecretKey(signingPubKey);
            if (openPGPSecretKey == null) {
                throw new KeyException.MissingSecretKeyException(signingPubKey);
            }
            OpenPGPKey.OpenPGPSecretKey signingSecKey = openPGPSecretKey;
            OpenPGPKey.OpenPGPPrivateKey signingPrivKey = UnlockSecretKey.Companion.unlockSecretKey$default(UnlockSecretKey.Companion, signingSecKey, signingKeyProtector, null, 4, null);
            CharSequence charSequence = userId;
            if (charSequence != null) {
                set = keyRingInfo.getPreferredHashAlgorithms(charSequence);
            } else {
                KeyIdentifier keyIdentifier = signingPubKey.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                set = keyRingInfo.getPreferredHashAlgorithms(keyIdentifier);
            }
            Set<HashAlgorithm> hashAlgorithms = set;
            HashAlgorithm hashAlgorithm = $this$addInlineSignature_u24lambda_u245.negotiateHashAlgorithm(hashAlgorithms);
            $this$addInlineSignature_u24lambda_u245.addSigningMethod(signingPrivKey, hashAlgorithm, signatureType, false, subpacketsCallback);
        }
        return signingOptions;
    }

    public static /* synthetic */ SigningOptions addInlineSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, OpenPGPKey openPGPKey, CharSequence charSequence, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) {
        if ((n & 4) != 0) {
            charSequence = null;
        }
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addInlineSignature(secretKeyRingProtector, openPGPKey, charSequence, documentSignatureType, callback2);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return this.addInlineSignature(signingKeyProtector, this.api.toKey(signingKey), userId, signatureType, subpacketsCallback);
    }

    public static /* synthetic */ SigningOptions addInlineSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, PGPSecretKeyRing pGPSecretKeyRing, CharSequence charSequence, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) throws KeyException, PGPException {
        if ((n & 4) != 0) {
            charSequence = null;
        }
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addInlineSignature(secretKeyRingProtector, pGPSecretKeyRing, charSequence, documentSignatureType, callback2);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) {
        boolean bl;
        KeyRingInfo keyRingInfo;
        SigningOptions $this$addInlineSignature_u24lambda_u247;
        SigningOptions signingOptions;
        block5: {
            Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
            Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
            Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
            $this$addInlineSignature_u24lambda_u247 = signingOptions = this;
            boolean bl2 = false;
            OpenPGPKey openPGPKey = signingKey.getOpenPGPKey();
            PGPainless pGPainless = $this$addInlineSignature_u24lambda_u247.api;
            Intrinsics.checkNotNull((Object)openPGPKey);
            keyRingInfo = pGPainless.inspect((OpenPGPCertificate)openPGPKey, $this$addInlineSignature_u24lambda_u247.getEvaluationDate());
            List<OpenPGPCertificate.OpenPGPComponentKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
            if (signingPubKeys.isEmpty()) {
                throw new KeyException.UnacceptableSigningKeyException((OpenPGPCertificate)openPGPKey);
            }
            Iterable $this$any$iv = signingPubKeys;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OpenPGPCertificate.OpenPGPComponentKey it = (OpenPGPCertificate.OpenPGPComponentKey)element$iv;
                    boolean bl3 = false;
                    if (!it.getKeyIdentifier().matchesExplicit(signingKey.getKeyIdentifier())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (!bl) {
            throw new KeyException.MissingSecretKeyException((OpenPGPCertificate.OpenPGPComponentKey)signingKey);
        }
        OpenPGPKey.OpenPGPPrivateKey signingPrivKey = UnlockSecretKey.Companion.unlockSecretKey$default(UnlockSecretKey.Companion, signingKey, signingKeyProtector, null, 4, null);
        KeyIdentifier keyIdentifier = signingKey.getKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
        Set<HashAlgorithm> hashAlgorithms = keyRingInfo.getPreferredHashAlgorithms(keyIdentifier);
        HashAlgorithm hashAlgorithm = $this$addInlineSignature_u24lambda_u247.negotiateHashAlgorithm(hashAlgorithms);
        $this$addInlineSignature_u24lambda_u247.addSigningMethod(signingPrivKey, hashAlgorithm, signatureType, false, subpacketsCallback);
        return signingOptions;
    }

    public static /* synthetic */ SigningOptions addInlineSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, OpenPGPKey.OpenPGPSecretKey openPGPSecretKey, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) {
        if ((n & 4) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 8) != 0) {
            callback2 = null;
        }
        return signingOptions.addInlineSignature(secretKeyRingProtector, openPGPSecretKey, documentSignatureType, callback2);
    }

    @Deprecated(message="Pass in an OpenPGPSecretKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        OpenPGPKey key = this.api.toKey(signingKey);
        KeyIdentifier subkeyIdentifier = new KeyIdentifier(keyId);
        OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = key.getSecretKey(subkeyIdentifier);
        if (openPGPSecretKey == null) {
            throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.Companion.of((PGPKeyRing)signingKey), subkeyIdentifier);
        }
        return this.addInlineSignature(signingKeyProtector, openPGPSecretKey, signatureType, subpacketsCallback);
    }

    public static /* synthetic */ SigningOptions addInlineSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, PGPSecretKeyRing pGPSecretKeyRing, long l, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) throws KeyException, PGPException {
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addInlineSignature(secretKeyRingProtector, pGPSecretKeyRing, l, documentSignatureType, callback2);
    }

    @Deprecated(message="Repeatedly call addDetachedSignature(), passing an OpenPGPKey instead.")
    @NotNull
    public final SigningOptions addDetachedSignatures(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull Iterable<? extends PGPSecretKeyRing> signingKeys, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter(signingKeys, (String)"signingKeys");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        SigningOptions $this$addDetachedSignatures_u24lambda_u249 = signingOptions = this;
        boolean bl = false;
        Iterable<? extends PGPSecretKeyRing> $this$forEach$iv = signingKeys;
        boolean $i$f$forEach = false;
        Iterator<? extends PGPSecretKeyRing> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            PGPSecretKeyRing element$iv;
            PGPSecretKeyRing it = element$iv = iterator.next();
            boolean bl2 = false;
            SigningOptions.addDetachedSignature$default($this$addDetachedSignatures_u24lambda_u249, signingKeyProtector, it, null, signatureType, null, 16, null);
        }
        return signingOptions;
    }

    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey, @NotNull DocumentSignatureType signatureType) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, null, signatureType, null, 16, null);
    }

    public static /* synthetic */ SigningOptions addDetachedSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, OpenPGPKey openPGPKey, DocumentSignatureType documentSignatureType, int n, Object object) {
        if ((n & 4) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        return signingOptions.addDetachedSignature(secretKeyRingProtector, openPGPKey, documentSignatureType);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        SigningOptions $this$addDetachedSignature_u24lambda_u2410 = signingOptions = this;
        boolean bl = false;
        SigningOptions.addDetachedSignature$default($this$addDetachedSignature_u24lambda_u2410, signingKeyProtector, signingKey, null, signatureType, null, 16, null);
        return signingOptions;
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketCallback) {
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        SigningOptions $this$addDetachedSignature_u24lambda_u2411 = signingOptions = this;
        boolean bl = false;
        KeyRingInfo keyRingInfo = $this$addDetachedSignature_u24lambda_u2411.api.inspect((OpenPGPCertificate)signingKey, $this$addDetachedSignature_u24lambda_u2411.getEvaluationDate());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyException.UnboundUserIdException(OpenPgpFingerprint.Companion.of((OpenPGPCertificate)signingKey), ((Object)userId).toString(), keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<OpenPGPCertificate.OpenPGPComponentKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyException.UnacceptableSigningKeyException((OpenPGPCertificate)signingKey);
        }
        for (OpenPGPCertificate.OpenPGPComponentKey signingPubKey : signingPubKeys) {
            OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = signingKey.getSecretKey(signingPubKey.getKeyIdentifier());
            if (openPGPSecretKey == null) {
                throw new KeyException.MissingSecretKeyException(signingPubKey);
            }
            OpenPGPKey.OpenPGPSecretKey signingSecKey = openPGPSecretKey;
            $this$addDetachedSignature_u24lambda_u2411.addDetachedSignature(signingKeyProtector, signingSecKey, userId, signatureType, subpacketCallback);
        }
        return signingOptions;
    }

    public static /* synthetic */ SigningOptions addDetachedSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, OpenPGPKey openPGPKey, CharSequence charSequence, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) {
        if ((n & 4) != 0) {
            charSequence = null;
        }
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addDetachedSignature(secretKeyRingProtector, openPGPKey, charSequence, documentSignatureType, callback2);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable String userId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketCallback) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return this.addDetachedSignature(signingKeyProtector, this.api.toKey(signingKey), (CharSequence)userId, signatureType, subpacketCallback);
    }

    public static /* synthetic */ SigningOptions addDetachedSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, PGPSecretKeyRing pGPSecretKeyRing, String string, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) throws KeyException, PGPException {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addDetachedSignature(secretKeyRingProtector, pGPSecretKeyRing, string, documentSignatureType, callback2);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketCallback) {
        Set<HashAlgorithm> set;
        SigningOptions signingOptions;
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        SigningOptions $this$addDetachedSignature_u24lambda_u2412 = signingOptions = this;
        boolean bl = false;
        PGPainless pGPainless = $this$addDetachedSignature_u24lambda_u2412.api;
        OpenPGPKey openPGPKey = signingKey.getOpenPGPKey();
        Intrinsics.checkNotNullExpressionValue((Object)openPGPKey, (String)"getOpenPGPKey(...)");
        KeyRingInfo keyRingInfo = pGPainless.inspect((OpenPGPCertificate)openPGPKey, $this$addDetachedSignature_u24lambda_u2412.getEvaluationDate());
        OpenPGPKey.OpenPGPPrivateKey openPGPPrivateKey = signingKey.unlock((KeyPassphraseProvider)signingKeyProtector);
        Intrinsics.checkNotNullExpressionValue((Object)openPGPPrivateKey, (String)"unlock(...)");
        OpenPGPKey.OpenPGPPrivateKey signingPrivKey = openPGPPrivateKey;
        CharSequence charSequence = userId;
        if (charSequence != null) {
            set = keyRingInfo.getPreferredHashAlgorithms(charSequence);
        } else {
            KeyIdentifier keyIdentifier = signingKey.getKeyIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
            set = keyRingInfo.getPreferredHashAlgorithms(keyIdentifier);
        }
        Set<HashAlgorithm> hashAlgorithms = set;
        HashAlgorithm hashAlgorithm = $this$addDetachedSignature_u24lambda_u2412.negotiateHashAlgorithm(hashAlgorithms);
        $this$addDetachedSignature_u24lambda_u2412.addSigningMethod(signingPrivKey, hashAlgorithm, signatureType, true, subpacketCallback);
        return signingOptions;
    }

    public static /* synthetic */ SigningOptions addDetachedSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, OpenPGPKey.OpenPGPSecretKey openPGPSecretKey, CharSequence charSequence, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) {
        if ((n & 4) != 0) {
            charSequence = null;
        }
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addDetachedSignature(secretKeyRingProtector, openPGPSecretKey, charSequence, documentSignatureType, callback2);
    }

    @Deprecated(message="Pass an OpenPGPSecretKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId, @NotNull DocumentSignatureType signatureType, @Nullable BaseSignatureSubpackets.Callback subpacketsCallback) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        OpenPGPKey key = this.api.toKey(signingKey);
        KeyIdentifier signingKeyIdentifier = new KeyIdentifier(keyId);
        OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = key.getSecretKey(signingKeyIdentifier);
        if (openPGPSecretKey == null) {
            throw new KeyException.MissingSecretKeyException(OpenPgpFingerprint.Companion.of((OpenPGPCertificate)key), signingKeyIdentifier);
        }
        return this.addDetachedSignature(signingKeyProtector, openPGPSecretKey, null, signatureType, subpacketsCallback);
    }

    public static /* synthetic */ SigningOptions addDetachedSignature$default(SigningOptions signingOptions, SecretKeyRingProtector secretKeyRingProtector, PGPSecretKeyRing pGPSecretKeyRing, long l, DocumentSignatureType documentSignatureType, BaseSignatureSubpackets.Callback callback2, int n, Object object) throws KeyException, PGPException {
        if ((n & 8) != 0) {
            documentSignatureType = DocumentSignatureType.BINARY_DOCUMENT;
        }
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        return signingOptions.addDetachedSignature(secretKeyRingProtector, pGPSecretKeyRing, l, documentSignatureType, callback2);
    }

    private final void addSigningMethod(OpenPGPKey.OpenPGPPrivateKey signingKey, HashAlgorithm hashAlgorithm, DocumentSignatureType signatureType, boolean detached, BaseSignatureSubpackets.Callback subpacketCallback) {
        PGPSecretKey pGPSecretKey = signingKey.getSecretKey().getPGPSecretKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKey, (String)"getPGPSecretKey(...)");
        PGPSecretKey signingSecretKey = pGPSecretKey;
        PublicKeyAlgorithm publicKeyAlgorithm = PublicKeyAlgorithm.Companion.requireFromId(signingSecretKey.getPublicKey().getAlgorithm());
        int bitStrength = signingSecretKey.getPublicKey().getBitStrength();
        if (!this.api.getAlgorithmPolicy().getPublicKeyAlgorithmPolicy().isAcceptable(publicKeyAlgorithm, bitStrength)) {
            OpenPGPKey.OpenPGPSecretKey openPGPSecretKey = signingKey.getSecretKey();
            Intrinsics.checkNotNullExpressionValue((Object)openPGPSecretKey, (String)"getSecretKey(...)");
            throw new KeyException.UnacceptableSigningKeyException(new KeyException.PublicKeyAlgorithmPolicyException((OpenPGPCertificate.OpenPGPComponentKey)openPGPSecretKey, publicKeyAlgorithm, bitStrength));
        }
        PGPKeyPair pGPKeyPair = signingKey.getKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)pGPKeyPair, (String)"getKeyPair(...)");
        PGPSignatureGenerator generator = this.createSignatureGenerator(pGPKeyPair, hashAlgorithm, signatureType);
        PGPPublicKey pGPPublicKey = signingSecretKey.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"getPublicKey(...)");
        SignatureSubpackets hashedSubpackets = SignatureSubpackets.Companion.createHashedSubpackets(pGPPublicKey);
        SignatureSubpackets unhashedSubpackets = SignatureSubpackets.Companion.createEmptySubpackets();
        if (subpacketCallback != null) {
            subpacketCallback.modifyHashedSubpackets((BaseSignatureSubpackets)hashedSubpackets);
            subpacketCallback.modifyUnhashedSubpackets((BaseSignatureSubpackets)unhashedSubpackets);
        }
        generator.setHashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(hashedSubpackets));
        generator.setUnhashedSubpackets(SignatureSubpacketsHelper.Companion.toVector(unhashedSubpackets));
        SigningMethod signingMethod = detached ? SigningMethod.Companion.detachedSignature(generator, hashAlgorithm) : SigningMethod.Companion.inlineSignature(generator, hashAlgorithm);
        Map<OpenPGPKey.OpenPGPPrivateKey, SigningMethod> map = this.signingMethods;
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<org.bouncycastle.openpgp.api.OpenPGPKey.OpenPGPPrivateKey, org.pgpainless.encryption_signing.SigningOptions.SigningMethod>");
        TypeIntrinsics.asMutableMap(map).put(signingKey, signingMethod);
    }

    static /* synthetic */ void addSigningMethod$default(SigningOptions signingOptions, OpenPGPKey.OpenPGPPrivateKey openPGPPrivateKey, HashAlgorithm hashAlgorithm, DocumentSignatureType documentSignatureType, boolean bl, BaseSignatureSubpackets.Callback callback2, int n, Object object) {
        if ((n & 0x10) != 0) {
            callback2 = null;
        }
        signingOptions.addSigningMethod(openPGPPrivateKey, hashAlgorithm, documentSignatureType, bl, callback2);
    }

    private final HashAlgorithm negotiateHashAlgorithm(Set<? extends HashAlgorithm> preferences) {
        HashAlgorithm hashAlgorithm = this._hashAlgorithmOverride;
        if (hashAlgorithm == null) {
            hashAlgorithm = this.hashAlgorithmNegotiator.negotiateHashAlgorithm(preferences);
        }
        return hashAlgorithm;
    }

    private final PGPSignatureGenerator createSignatureGenerator(PGPKeyPair signingKey, HashAlgorithm hashAlgorithm, DocumentSignatureType signatureType) throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator;
        PGPContentSignerBuilder csb = OpenPGPImplementation.getInstance().pgpContentSignerBuilder(signingKey.getPublicKey().getAlgorithm(), hashAlgorithm.getAlgorithmId());
        boolean bl = false;
        PGPSignatureGenerator it = pGPSignatureGenerator = new PGPSignatureGenerator(csb, signingKey.getPublicKey());
        boolean bl2 = false;
        it.init(signatureType.getSignatureType().getCode(), signingKey.getPrivateKey());
        return pGPSignatureGenerator;
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, userId, signatureType, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey, @Nullable CharSequence userId) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, userId, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, null, null, null, 28, null);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, userId, signatureType, null, 16, null);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable CharSequence userId) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, userId, null, null, 24, null);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, null, null, null, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @NotNull DocumentSignatureType signatureType) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, signatureType, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, null, null, 12, null);
    }

    @Deprecated(message="Pass in an OpenPGPSecretKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, keyId, signatureType, null, 16, null);
    }

    @Deprecated(message="Pass in an OpenPGPSecretKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addInlineSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addInlineSignature$default(this, signingKeyProtector, signingKey, keyId, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, userId, signatureType, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey, @Nullable CharSequence userId) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, userId, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey signingKey) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, null, null, null, 28, null);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable String userId, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, userId, signatureType, null, 16, null);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, @Nullable String userId) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, userId, null, null, 24, null);
    }

    @Deprecated(message="Pass an OpenPGPKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, null, null, null, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @Nullable CharSequence userId, @NotNull DocumentSignatureType signatureType) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, userId, signatureType, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey, @Nullable CharSequence userId) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, userId, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull OpenPGPKey.OpenPGPSecretKey signingKey) {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, null, null, null, 28, null);
    }

    @Deprecated(message="Pass an OpenPGPSecretKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId, @NotNull DocumentSignatureType signatureType) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, keyId, signatureType, null, 16, null);
    }

    @Deprecated(message="Pass an OpenPGPSecretKey instead.")
    @JvmOverloads
    @NotNull
    public final SigningOptions addDetachedSignature(@NotNull SecretKeyRingProtector signingKeyProtector, @NotNull PGPSecretKeyRing signingKey, long keyId) throws KeyException, PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKeyProtector, (String)"signingKeyProtector");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        return SigningOptions.addDetachedSignature$default(this, signingKeyProtector, signingKey, keyId, null, null, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SigningOptions get(@NotNull PGPainless api) {
        return Companion.get(api);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SigningOptions get() {
        return Companion.get();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/encryption_signing/SigningOptions$Companion;", "", "()V", "get", "Lorg/pgpainless/encryption_signing/SigningOptions;", "api", "Lorg/pgpainless/PGPainless;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SigningOptions get(@NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            return new SigningOptions(api);
        }

        public static /* synthetic */ SigningOptions get$default(Companion companion, PGPainless pGPainless, int n, Object object) {
            if ((n & 1) != 0) {
                pGPainless = PGPainless.Companion.getInstance();
            }
            return companion.get(pGPainless);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SigningOptions get() {
            return org.pgpainless.encryption_signing.SigningOptions$Companion.get$default(this, null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/encryption_signing/SigningOptions$SigningMethod;", "", "signatureGenerator", "Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "isDetached", "", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "(Lorg/bouncycastle/openpgp/PGPSignatureGenerator;ZLorg/pgpainless/algorithm/HashAlgorithm;)V", "getHashAlgorithm", "()Lorg/pgpainless/algorithm/HashAlgorithm;", "()Z", "getSignatureGenerator", "()Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "Companion", "pgpainless-core"})
    public static final class SigningMethod {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final PGPSignatureGenerator signatureGenerator;
        private final boolean isDetached;
        @NotNull
        private final HashAlgorithm hashAlgorithm;

        private SigningMethod(PGPSignatureGenerator signatureGenerator, boolean isDetached, HashAlgorithm hashAlgorithm) {
            this.signatureGenerator = signatureGenerator;
            this.isDetached = isDetached;
            this.hashAlgorithm = hashAlgorithm;
        }

        @NotNull
        public final PGPSignatureGenerator getSignatureGenerator() {
            return this.signatureGenerator;
        }

        public final boolean isDetached() {
            return this.isDetached;
        }

        @NotNull
        public final HashAlgorithm getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        @JvmStatic
        @NotNull
        public static final SigningMethod inlineSignature(@NotNull PGPSignatureGenerator signatureGenerator, @NotNull HashAlgorithm hashAlgorithm) {
            return Companion.inlineSignature(signatureGenerator, hashAlgorithm);
        }

        @JvmStatic
        @NotNull
        public static final SigningMethod detachedSignature(@NotNull PGPSignatureGenerator signatureGenerator, @NotNull HashAlgorithm hashAlgorithm) {
            return Companion.detachedSignature(signatureGenerator, hashAlgorithm);
        }

        public /* synthetic */ SigningMethod(PGPSignatureGenerator signatureGenerator, boolean isDetached, HashAlgorithm hashAlgorithm, DefaultConstructorMarker $constructor_marker) {
            this(signatureGenerator, isDetached, hashAlgorithm);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/pgpainless/encryption_signing/SigningOptions$SigningMethod$Companion;", "", "()V", "detachedSignature", "Lorg/pgpainless/encryption_signing/SigningOptions$SigningMethod;", "signatureGenerator", "Lorg/bouncycastle/openpgp/PGPSignatureGenerator;", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "inlineSignature", "pgpainless-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final SigningMethod inlineSignature(@NotNull PGPSignatureGenerator signatureGenerator, @NotNull HashAlgorithm hashAlgorithm) {
                Intrinsics.checkNotNullParameter((Object)signatureGenerator, (String)"signatureGenerator");
                Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
                return new SigningMethod(signatureGenerator, false, hashAlgorithm, null);
            }

            @JvmStatic
            @NotNull
            public final SigningMethod detachedSignature(@NotNull PGPSignatureGenerator signatureGenerator, @NotNull HashAlgorithm hashAlgorithm) {
                Intrinsics.checkNotNullParameter((Object)signatureGenerator, (String)"signatureGenerator");
                Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
                return new SigningMethod(signatureGenerator, true, hashAlgorithm, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

