/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collection;
import java.util.Date;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.negotiation.CompressionAlgorithmNegotiator;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.policy.Policy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 J2\u00020\u0001:\u0001JB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0000J\u0006\u00108\u001a\u00020\rJ\u0006\u00109\u001a\u00020\rJ\u0015\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020<H\u0000\u00a2\u0006\u0002\b=J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\nJ\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\rJ\u0006\u0010A\u001a\u00020\u0000J\u0010\u0010B\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\bJ\u0010\u0010C\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H\u0007J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\bJ\b\u0010E\u001a\u00020\u0000H\u0007J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\rJ\u000e\u0010H\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u000fJ\u0010\u0010I\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u00010\bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0016R\u0011\u0010)\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010*R\u0011\u0010,\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u001a\u0010-\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010*\"\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010*R\u0011\u00101\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0013\u00106\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0016\u00a8\u0006K"}, d2={"Lorg/pgpainless/encryption_signing/ProducerOptions;", "", "encryptionOptions", "Lorg/pgpainless/encryption_signing/EncryptionOptions;", "signingOptions", "Lorg/pgpainless/encryption_signing/SigningOptions;", "(Lorg/pgpainless/encryption_signing/EncryptionOptions;Lorg/pgpainless/encryption_signing/SigningOptions;)V", "_comment", "", "_compressionAlgorithmOverride", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "_fileName", "_hideArmorHeaders", "", "_modificationDate", "Ljava/util/Date;", "_version", "applyCRLFEncoding", "asciiArmor", "cleartextSigned", "comment", "getComment", "()Ljava/lang/String;", "compressionAlgorithmNegotiator", "Lorg/pgpainless/algorithm/negotiation/CompressionAlgorithmNegotiator;", "getCompressionAlgorithmNegotiator", "()Lorg/pgpainless/algorithm/negotiation/CompressionAlgorithmNegotiator;", "setCompressionAlgorithmNegotiator", "(Lorg/pgpainless/algorithm/negotiation/CompressionAlgorithmNegotiator;)V", "compressionAlgorithmOverride", "getCompressionAlgorithmOverride", "()Lorg/pgpainless/algorithm/CompressionAlgorithm;", "encoding", "Lorg/pgpainless/algorithm/StreamEncoding;", "getEncoding", "()Lorg/pgpainless/algorithm/StreamEncoding;", "encodingField", "getEncryptionOptions", "()Lorg/pgpainless/encryption_signing/EncryptionOptions;", "fileName", "getFileName", "isApplyCRLFEncoding", "()Z", "isAsciiArmor", "isCleartextSigned", "isDisableAsciiArmorCRC", "setDisableAsciiArmorCRC", "(Z)V", "isHideArmorHeaders", "modificationDate", "getModificationDate", "()Ljava/util/Date;", "getSigningOptions", "()Lorg/pgpainless/encryption_signing/SigningOptions;", "version", "getVersion", "hasComment", "hasVersion", "negotiateCompressionAlgorithm", "policy", "Lorg/pgpainless/policy/Policy;", "negotiateCompressionAlgorithm$pgpainless_core", "overrideCompressionAlgorithm", "compressionAlgorithm", "setAsciiArmor", "setCleartextSigned", "setComment", "setEncoding", "setFileName", "setForYourEyesOnly", "setHideArmorHeaders", "hideArmorHeaders", "setModificationDate", "setVersion", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nProducerOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProducerOptions.kt\norg/pgpainless/encryption_signing/ProducerOptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1#2:289\n1726#3,3:290\n*S KotlinDebug\n*F\n+ 1 ProducerOptions.kt\norg/pgpainless/encryption_signing/ProducerOptions\n*L\n122#1:290,3\n*E\n"})
public final class ProducerOptions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final EncryptionOptions encryptionOptions;
    @Nullable
    private final SigningOptions signingOptions;
    @NotNull
    private CompressionAlgorithmNegotiator compressionAlgorithmNegotiator;
    @NotNull
    private String _fileName;
    @NotNull
    private Date _modificationDate;
    @NotNull
    private StreamEncoding encodingField;
    private boolean applyCRLFEncoding;
    private boolean cleartextSigned;
    private boolean _hideArmorHeaders;
    private boolean isDisableAsciiArmorCRC;
    @Nullable
    private CompressionAlgorithm _compressionAlgorithmOverride;
    private boolean asciiArmor;
    @Nullable
    private String _comment;
    @Nullable
    private String _version;

    public ProducerOptions(@Nullable EncryptionOptions encryptionOptions, @Nullable SigningOptions signingOptions) {
        this.encryptionOptions = encryptionOptions;
        this.signingOptions = signingOptions;
        this.compressionAlgorithmNegotiator = CompressionAlgorithmNegotiator.Companion.staticNegotiation();
        this._fileName = "";
        Date date = PGPLiteralData.NOW;
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"NOW");
        this._modificationDate = date;
        this.encodingField = StreamEncoding.BINARY;
        this.asciiArmor = true;
    }

    @Nullable
    public final EncryptionOptions getEncryptionOptions() {
        return this.encryptionOptions;
    }

    @Nullable
    public final SigningOptions getSigningOptions() {
        return this.signingOptions;
    }

    @NotNull
    public final CompressionAlgorithmNegotiator getCompressionAlgorithmNegotiator() {
        return this.compressionAlgorithmNegotiator;
    }

    public final void setCompressionAlgorithmNegotiator(@NotNull CompressionAlgorithmNegotiator compressionAlgorithmNegotiator) {
        Intrinsics.checkNotNullParameter((Object)compressionAlgorithmNegotiator, (String)"<set-?>");
        this.compressionAlgorithmNegotiator = compressionAlgorithmNegotiator;
    }

    public final boolean isDisableAsciiArmorCRC() {
        return this.isDisableAsciiArmorCRC;
    }

    public final void setDisableAsciiArmorCRC(boolean bl) {
        this.isDisableAsciiArmorCRC = bl;
    }

    @NotNull
    public final ProducerOptions setAsciiArmor(boolean asciiArmor) {
        ProducerOptions producerOptions;
        ProducerOptions $this$setAsciiArmor_u24lambda_u241 = producerOptions = this;
        boolean bl = false;
        if (!(!$this$setAsciiArmor_u24lambda_u241.cleartextSigned || asciiArmor)) {
            boolean bl2 = false;
            String string = "Cleartext signing is enabled. Cannot disable ASCII armoring.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$setAsciiArmor_u24lambda_u241.asciiArmor = asciiArmor;
        return producerOptions;
    }

    public final boolean isAsciiArmor() {
        return this.asciiArmor;
    }

    @NotNull
    public final ProducerOptions setComment(@Nullable String comment) {
        ProducerOptions producerOptions;
        ProducerOptions $this$setComment_u24lambda_u242 = producerOptions = this;
        boolean bl = false;
        $this$setComment_u24lambda_u242._comment = comment;
        return producerOptions;
    }

    @Nullable
    public final String getComment() {
        return this._comment;
    }

    public final boolean hasComment() {
        return this._comment != null;
    }

    @NotNull
    public final ProducerOptions setVersion(@Nullable String version) {
        ProducerOptions producerOptions;
        ProducerOptions $this$setVersion_u24lambda_u243 = producerOptions = this;
        boolean bl = false;
        $this$setVersion_u24lambda_u243._version = version;
        return producerOptions;
    }

    @Nullable
    public final String getVersion() {
        return this._version;
    }

    public final boolean hasVersion() {
        return this.getVersion() != null;
    }

    @NotNull
    public final ProducerOptions setCleartextSigned() {
        boolean bl;
        ProducerOptions producerOptions;
        block6: {
            ProducerOptions $this$setCleartextSigned_u24lambda_u248 = producerOptions = this;
            boolean bl2 = false;
            if (!($this$setCleartextSigned_u24lambda_u248.signingOptions != null)) {
                boolean $i$a$-require-ProducerOptions$setCleartextSigned$1$32 = false;
                String $i$a$-require-ProducerOptions$setCleartextSigned$1$32 = "Signing Options cannot be null if cleartext signing is enabled.";
                throw new IllegalArgumentException($i$a$-require-ProducerOptions$setCleartextSigned$1$32.toString());
            }
            if (!($this$setCleartextSigned_u24lambda_u248.encryptionOptions == null)) {
                boolean $i$a$-require-ProducerOptions$setCleartextSigned$1$52 = false;
                String $i$a$-require-ProducerOptions$setCleartextSigned$1$52 = "Cannot encode encrypted message as Cleartext Signed.";
                throw new IllegalArgumentException($i$a$-require-ProducerOptions$setCleartextSigned$1$52.toString());
            }
            Iterable $this$all$iv = $this$setCleartextSigned_u24lambda_u248.signingOptions.getSigningMethods().values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    SigningOptions.SigningMethod it = (SigningOptions.SigningMethod)element$iv;
                    boolean bl3 = false;
                    if (it.isDetached()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl4 = false;
            String string = "For cleartext signed messages, all signatures must be added as detached signatures.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$setCleartextSigned_u24lambda_u248.cleartextSigned = true;
        $this$setCleartextSigned_u24lambda_u248.asciiArmor = true;
        $this$setCleartextSigned_u24lambda_u248._compressionAlgorithmOverride = CompressionAlgorithm.UNCOMPRESSED;
        return producerOptions;
    }

    public final boolean isCleartextSigned() {
        return this.cleartextSigned;
    }

    @NotNull
    public final ProducerOptions setFileName(@NotNull String fileName) {
        ProducerOptions producerOptions;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ProducerOptions $this$setFileName_u24lambda_u249 = producerOptions = this;
        boolean bl = false;
        $this$setFileName_u24lambda_u249._fileName = fileName;
        return producerOptions;
    }

    @NotNull
    public final String getFileName() {
        return this._fileName;
    }

    @Deprecated(message="Signaling using special file name is discouraged.")
    @NotNull
    public final ProducerOptions setForYourEyesOnly() {
        ProducerOptions producerOptions;
        ProducerOptions $this$setForYourEyesOnly_u24lambda_u2410 = producerOptions = this;
        boolean bl = false;
        $this$setForYourEyesOnly_u24lambda_u2410._fileName = "_CONSOLE";
        return producerOptions;
    }

    @NotNull
    public final ProducerOptions setModificationDate(@NotNull Date modificationDate) {
        ProducerOptions producerOptions;
        Intrinsics.checkNotNullParameter((Object)modificationDate, (String)"modificationDate");
        ProducerOptions $this$setModificationDate_u24lambda_u2411 = producerOptions = this;
        boolean bl = false;
        $this$setModificationDate_u24lambda_u2411._modificationDate = modificationDate;
        return producerOptions;
    }

    @NotNull
    public final Date getModificationDate() {
        return this._modificationDate;
    }

    @Deprecated(message="Options other than BINARY are discouraged.")
    @NotNull
    public final ProducerOptions setEncoding(@NotNull StreamEncoding encoding) {
        ProducerOptions producerOptions;
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        ProducerOptions $this$setEncoding_u24lambda_u2412 = producerOptions = this;
        boolean bl = false;
        $this$setEncoding_u24lambda_u2412.encodingField = encoding;
        return producerOptions;
    }

    @NotNull
    public final StreamEncoding getEncoding() {
        return this.encodingField;
    }

    @NotNull
    public final ProducerOptions applyCRLFEncoding() {
        ProducerOptions producerOptions;
        ProducerOptions $this$applyCRLFEncoding_u24lambda_u2413 = producerOptions = this;
        boolean bl = false;
        $this$applyCRLFEncoding_u24lambda_u2413.applyCRLFEncoding = true;
        return producerOptions;
    }

    public final boolean isApplyCRLFEncoding() {
        return this.applyCRLFEncoding;
    }

    @NotNull
    public final ProducerOptions overrideCompressionAlgorithm(@NotNull CompressionAlgorithm compressionAlgorithm) {
        ProducerOptions producerOptions;
        Intrinsics.checkNotNullParameter((Object)((Object)compressionAlgorithm), (String)"compressionAlgorithm");
        ProducerOptions $this$overrideCompressionAlgorithm_u24lambda_u2414 = producerOptions = this;
        boolean bl = false;
        $this$overrideCompressionAlgorithm_u24lambda_u2414._compressionAlgorithmOverride = compressionAlgorithm;
        return producerOptions;
    }

    @Nullable
    public final CompressionAlgorithm getCompressionAlgorithmOverride() {
        return this._compressionAlgorithmOverride;
    }

    public final boolean isHideArmorHeaders() {
        return this._hideArmorHeaders;
    }

    @NotNull
    public final ProducerOptions setHideArmorHeaders(boolean hideArmorHeaders) {
        ProducerOptions producerOptions;
        ProducerOptions $this$setHideArmorHeaders_u24lambda_u2415 = producerOptions = this;
        boolean bl = false;
        $this$setHideArmorHeaders_u24lambda_u2415._hideArmorHeaders = hideArmorHeaders;
        return producerOptions;
    }

    @NotNull
    public final CompressionAlgorithm negotiateCompressionAlgorithm$pgpainless_core(@NotNull Policy policy) {
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        return this.compressionAlgorithmNegotiator.negotiate(policy, this.getCompressionAlgorithmOverride(), SetsKt.emptySet());
    }

    @JvmStatic
    @NotNull
    public static final ProducerOptions signAndEncrypt(@NotNull EncryptionOptions encryptionOptions, @NotNull SigningOptions signingOptions) {
        return Companion.signAndEncrypt(encryptionOptions, signingOptions);
    }

    @JvmStatic
    @NotNull
    public static final ProducerOptions sign(@NotNull SigningOptions signingOptions) {
        return Companion.sign(signingOptions);
    }

    @JvmStatic
    @NotNull
    public static final ProducerOptions encrypt(@NotNull EncryptionOptions encryptionOptions) {
        return Companion.encrypt(encryptionOptions);
    }

    @JvmStatic
    @NotNull
    public static final ProducerOptions noEncryptionNoSigning() {
        return Companion.noEncryptionNoSigning();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Lorg/pgpainless/encryption_signing/ProducerOptions$Companion;", "", "()V", "encrypt", "Lorg/pgpainless/encryption_signing/ProducerOptions;", "encryptionOptions", "Lorg/pgpainless/encryption_signing/EncryptionOptions;", "noEncryptionNoSigning", "sign", "signingOptions", "Lorg/pgpainless/encryption_signing/SigningOptions;", "signAndEncrypt", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProducerOptions signAndEncrypt(@NotNull EncryptionOptions encryptionOptions, @NotNull SigningOptions signingOptions) {
            Intrinsics.checkNotNullParameter((Object)encryptionOptions, (String)"encryptionOptions");
            Intrinsics.checkNotNullParameter((Object)signingOptions, (String)"signingOptions");
            return new ProducerOptions(encryptionOptions, signingOptions);
        }

        @JvmStatic
        @NotNull
        public final ProducerOptions sign(@NotNull SigningOptions signingOptions) {
            Intrinsics.checkNotNullParameter((Object)signingOptions, (String)"signingOptions");
            return new ProducerOptions(null, signingOptions);
        }

        @JvmStatic
        @NotNull
        public final ProducerOptions encrypt(@NotNull EncryptionOptions encryptionOptions) {
            Intrinsics.checkNotNullParameter((Object)encryptionOptions, (String)"encryptionOptions");
            return new ProducerOptions(encryptionOptions, null);
        }

        @JvmStatic
        @NotNull
        public final ProducerOptions noEncryptionNoSigning() {
            return new ProducerOptions(null, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

