/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.OutputStream;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/encryption_signing/PGPHashContextContentSignerBuilder;", "Lorg/bouncycastle/openpgp/operator/PGPContentSignerBuilder;", "()V", "ExistingMessageDigest", "SignerOutputStream", "pgpainless-core"})
public abstract class PGPHashContextContentSignerBuilder
implements PGPContentSignerBuilder {

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/pgpainless/encryption_signing/PGPHashContextContentSignerBuilder$ExistingMessageDigest;", "Lorg/bouncycastle/crypto/Digest;", "digest", "Ljava/security/MessageDigest;", "(Ljava/security/MessageDigest;)V", "doFinal", "", "out", "", "outOff", "getAlgorithmName", "", "getDigestSize", "reset", "", "update", "b", "", "buf", "inOff", "len", "pgpainless-core"})
    public static final class ExistingMessageDigest
    implements Digest {
        @NotNull
        private final MessageDigest digest;

        public ExistingMessageDigest(@NotNull MessageDigest digest) {
            Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
            this.digest = digest;
        }

        @NotNull
        public String getAlgorithmName() {
            String string = this.digest.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAlgorithm(...)");
            return string;
        }

        public int getDigestSize() {
            return this.digest.getDigestLength();
        }

        public void update(byte b) {
            this.digest.update(b);
        }

        public void update(@NotNull byte[] buf, int inOff, int len) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            this.digest.update(buf);
        }

        public int doFinal(@NotNull byte[] out, int outOff) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            byte[] byArray = this.digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            ArraysKt.copyInto$default((byte[])byArray, (byte[])out, (int)outOff, (int)0, (int)0, (int)12, null);
            return this.getDigestSize();
        }

        public void reset() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/pgpainless/encryption_signing/PGPHashContextContentSignerBuilder$SignerOutputStream;", "Ljava/io/OutputStream;", "signer", "Lorg/bouncycastle/crypto/Signer;", "(Lorg/bouncycastle/crypto/Signer;)V", "write", "", "b", "", "off", "", "len", "p0", "pgpainless-core"})
    public static final class SignerOutputStream
    extends OutputStream {
        @NotNull
        private final Signer signer;

        public SignerOutputStream(@NotNull Signer signer) {
            Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
            this.signer = signer;
        }

        @Override
        public void write(int p0) {
            this.signer.update((byte)p0);
        }

        @Override
        public void write(@NotNull byte[] b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.signer.update(b, 0, b.length);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            this.signer.update(b, off, len);
        }
    }
}

