/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.bouncycastle.extensions.OpenPGPImplementationExtensionsKt;
import org.pgpainless.encryption_signing.CRLFGeneratorStream;
import org.pgpainless.encryption_signing.EncryptionResult;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.encryption_signing.SignatureGenerationStream;
import org.pgpainless.encryption_signing.SigningOptions;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.SessionKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u001eH\u0002J\b\u0010%\u001a\u00020\u001eH\u0002J\b\u0010&\u001a\u00020\u001eH\u0002J\b\u0010'\u001a\u00020\u001eH\u0002J\b\u0010(\u001a\u00020\u001eH\u0002J\b\u0010)\u001a\u00020\u001eH\u0002J\b\u0010*\u001a\u00020\u001eH\u0002J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0016J \u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020!H\u0016J\u0010\u0010+\u001a\u00020\u001e2\u0006\u00100\u001a\u00020!H\u0016J\b\u00101\u001a\u00020\u001eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionStream;", "Ljava/io/OutputStream;", "outermostStream", "options", "Lorg/pgpainless/encryption_signing/ProducerOptions;", "api", "Lorg/pgpainless/PGPainless;", "(Ljava/io/OutputStream;Lorg/pgpainless/encryption_signing/ProducerOptions;Lorg/pgpainless/PGPainless;)V", "armorOutputStream", "Lorg/bouncycastle/bcpg/ArmoredOutputStream;", "basicCompressionStream", "Lorg/bouncycastle/bcpg/BCPGOutputStream;", "closed", "", "compressedDataGenerator", "Lorg/bouncycastle/openpgp/PGPCompressedDataGenerator;", "isClosed", "()Z", "literalDataGenerator", "Lorg/bouncycastle/openpgp/PGPLiteralDataGenerator;", "literalDataStream", "publicKeyEncryptedStream", "result", "Lorg/pgpainless/encryption_signing/EncryptionResult;", "getResult", "()Lorg/pgpainless/encryption_signing/EncryptionResult;", "resultBuilder", "Lorg/pgpainless/encryption_signing/EncryptionResult$Builder;", "signatureLayerStream", "close", "", "collectHashAlgorithmsForCleartextSigning", "", "", "()[Ljava/lang/Integer;", "flush", "prepareArmor", "prepareCompression", "prepareEncryption", "prepareInputEncoding", "prepareLiteralDataProcessing", "prepareOnePassSignatures", "prepareSigningStream", "write", "buffer", "", "off", "len", "data", "writeSignatures", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nEncryptionStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionStream.kt\norg/pgpainless/encryption_signing/EncryptionStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,270:1\n1#2:271\n1855#3,2:272\n1855#3,2:274\n1549#3:276\n1620#3,3:277\n1549#3:280\n1620#3,3:281\n1855#3,2:286\n37#4,2:284\n*S KotlinDebug\n*F\n+ 1 EncryptionStream.kt\norg/pgpainless/encryption_signing/EncryptionStream\n*L\n91#1:272,2\n94#1:274,2\n186#1:276\n186#1:277,3\n188#1:280\n188#1:281,3\n249#1:286,2\n189#1:284,2\n*E\n"})
public final class EncryptionStream
extends OutputStream {
    @NotNull
    private OutputStream outermostStream;
    @NotNull
    private final ProducerOptions options;
    @NotNull
    private final PGPainless api;
    @NotNull
    private final EncryptionResult.Builder resultBuilder;
    private boolean closed;
    @Nullable
    private OutputStream signatureLayerStream;
    @Nullable
    private ArmoredOutputStream armorOutputStream;
    @Nullable
    private OutputStream publicKeyEncryptedStream;
    @Nullable
    private PGPCompressedDataGenerator compressedDataGenerator;
    @Nullable
    private BCPGOutputStream basicCompressionStream;
    @Nullable
    private PGPLiteralDataGenerator literalDataGenerator;
    @Nullable
    private OutputStream literalDataStream;

    public EncryptionStream(@NotNull OutputStream outermostStream, @NotNull ProducerOptions options, @NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)outermostStream, (String)"outermostStream");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.outermostStream = outermostStream;
        this.options = options;
        this.api = api;
        this.resultBuilder = EncryptionResult.Companion.builder();
        this.prepareArmor();
        this.prepareEncryption();
        this.prepareCompression();
        this.prepareOnePassSignatures();
        this.prepareLiteralDataProcessing();
        this.prepareSigningStream();
        this.prepareInputEncoding();
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareArmor() {
        void it;
        ArmoredOutputStream armoredOutputStream;
        if (!this.options.isAsciiArmor()) {
            return;
        }
        this.outermostStream = new BufferedOutputStream(this.outermostStream);
        ArmoredOutputStream armoredOutputStream2 = armoredOutputStream = ArmoredOutputStreamFactory.Companion.get(this.outermostStream, this.options);
        EncryptionStream encryptionStream = this;
        boolean bl = false;
        this.outermostStream = (OutputStream)it;
        encryptionStream.armorOutputStream = armoredOutputStream;
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareEncryption() throws IOException, PGPException {
        void stream;
        OutputStream outputStream;
        if (this.options.getEncryptionOptions() == null) {
            return;
        }
        if (!(!((Collection)this.options.getEncryptionOptions().getEncryptionMethods()).isEmpty())) {
            boolean $i$a$-require-EncryptionStream$prepareEncryption$22 = false;
            String $i$a$-require-EncryptionStream$prepareEncryption$22 = "If EncryptionOptions are provided, at least one encryption method MUST be provided as well.";
            throw new IllegalArgumentException($i$a$-require-EncryptionStream$prepareEncryption$22.toString());
        }
        MessageEncryptionMechanism mechanism = this.options.getEncryptionOptions().negotiateEncryptionMechanism$pgpainless_core();
        this.resultBuilder.setEncryptionMechanism(mechanism);
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator(OpenPGPImplementationExtensionsKt.pgpDataEncryptorBuilder(this.api.getImplementation(), mechanism));
        Iterable $this$forEach$iv = this.options.getEncryptionOptions().getEncryptionMethods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPKeyEncryptionMethodGenerator m = (PGPKeyEncryptionMethodGenerator)element$iv;
            boolean bl = false;
            encryptedDataGenerator.addMethod(m);
        }
        $this$forEach$iv = this.options.getEncryptionOptions().getEncryptionKeyIdentifiers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SubkeyIdentifier r = (SubkeyIdentifier)element$iv;
            boolean bl = false;
            this.resultBuilder.addRecipient(r);
        }
        encryptedDataGenerator.setSessionKeyExtractionCallback(arg_0 -> EncryptionStream.prepareEncryption$lambda$4(this, arg_0));
        OutputStream $i$f$forEach2 = outputStream = encryptedDataGenerator.open(this.outermostStream, new byte[512]);
        EncryptionStream encryptionStream = this;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)stream);
        this.outermostStream = stream;
        encryptionStream.publicKeyEncryptedStream = outputStream;
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareCompression() throws IOException {
        void stream;
        BCPGOutputStream bCPGOutputStream;
        CompressionAlgorithm it = this.options.negotiateCompressionAlgorithm$pgpainless_core(this.api.getAlgorithmPolicy());
        boolean bl = false;
        this.resultBuilder.setCompressionAlgorithm(it);
        this.compressedDataGenerator = new PGPCompressedDataGenerator(it.getAlgorithmId());
        if (it == CompressionAlgorithm.UNCOMPRESSED) {
            return;
        }
        PGPCompressedDataGenerator pGPCompressedDataGenerator = this.compressedDataGenerator;
        Intrinsics.checkNotNull((Object)pGPCompressedDataGenerator);
        BCPGOutputStream bCPGOutputStream2 = bCPGOutputStream = new BCPGOutputStream(pGPCompressedDataGenerator.open(this.outermostStream));
        EncryptionStream encryptionStream = this;
        boolean bl2 = false;
        this.outermostStream = (OutputStream)stream;
        encryptionStream.basicCompressionStream = bCPGOutputStream;
    }

    private final void prepareOnePassSignatures() throws IOException, PGPException {
        this.signatureLayerStream = this.outermostStream;
        if (this.options.getSigningOptions() == null) {
            return;
        }
        if (!(!this.options.getSigningOptions().getSigningMethods().isEmpty())) {
            boolean bl = false;
            String string = "If SigningOptions are provided, at least one SigningMethod MUST be provided.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterator<SigningOptions.SigningMethod> iterator = this.options.getSigningOptions().getSigningMethods().values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            SigningOptions.SigningMethod method = iterator.next();
            if (method.isDetached()) continue;
            boolean nested = index + 1 < this.options.getSigningOptions().getSigningMethods().size();
            method.getSignatureGenerator().generateOnePassVersion(nested).encode(this.outermostStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareLiteralDataProcessing() throws IOException {
        void stream;
        void gen;
        OutputStream outputStream;
        if (this.options.isCleartextSigned()) {
            Integer[] hashAlgorithms = this.collectHashAlgorithmsForCleartextSigning();
            ArmoredOutputStream armoredOutputStream = this.armorOutputStream;
            Intrinsics.checkNotNull((Object)armoredOutputStream);
            int[] nArray = ArraysKt.toIntArray((Integer[])hashAlgorithms);
            armoredOutputStream.beginClearText(Arrays.copyOf(nArray, nArray.length));
            return;
        }
        Object object = new PGPLiteralDataGenerator();
        PGPLiteralDataGenerator pGPLiteralDataGenerator = object;
        EncryptionStream encryptionStream = this;
        boolean bl = false;
        OutputStream outputStream2 = outputStream = gen.open(this.outermostStream, this.options.getEncoding().getCode(), this.options.getFileName(), this.options.getModificationDate(), new byte[512]);
        EncryptionStream encryptionStream2 = this;
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)stream);
        this.outermostStream = stream;
        encryptionStream2.literalDataStream = outputStream;
        encryptionStream.literalDataGenerator = object;
        Object $this$prepareLiteralDataProcessing_u24lambda_u2411 = object = this.resultBuilder;
        boolean bl3 = false;
        ((EncryptionResult.Builder)$this$prepareLiteralDataProcessing_u24lambda_u2411).setFileName(this.options.getFileName());
        ((EncryptionResult.Builder)$this$prepareLiteralDataProcessing_u24lambda_u2411).setModificationDate(this.options.getModificationDate());
        ((EncryptionResult.Builder)$this$prepareLiteralDataProcessing_u24lambda_u2411).setFileEncoding(this.options.getEncoding());
    }

    private final void prepareSigningStream() {
        this.outermostStream = new SignatureGenerationStream(this.outermostStream, this.options.getSigningOptions());
    }

    private final void prepareInputEncoding() {
        this.outermostStream = new CRLFGeneratorStream(new BufferedOutputStream(this.outermostStream), this.options.isApplyCRLFEncoding() ? StreamEncoding.UTF8 : StreamEncoding.BINARY);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Integer[] collectHashAlgorithmsForCleartextSigning() {
        Integer[] integerArray;
        Collection<SigningOptions.SigningMethod> collection;
        Map<OpenPGPKey.OpenPGPPrivateKey, SigningOptions.SigningMethod> map;
        SigningOptions signingOptions = this.options.getSigningOptions();
        if (signingOptions != null && (map = signingOptions.getSigningMethods()) != null && (collection = map.values()) != null) {
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = collection;
            boolean $i$f$map = false;
            Integer[] integerArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SigningOptions.SigningMethod signingMethod = (SigningOptions.SigningMethod)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getHashAlgorithm());
            }
            iterable = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (iterable != null) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                $this$mapTo$iv$iv = iterable;
                boolean $i$f$map22 = false;
                void $i$f$mapTo2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    HashAlgorithm hashAlgorithm = (HashAlgorithm)((Object)item$iv$iv);
                    collection2 = destination$iv$iv2;
                    boolean bl = false;
                    collection2.add(it.getAlgorithmId());
                }
                Collection $i$f$map22 = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                integerArray2 = thisCollection$iv.toArray(new Integer[0]);
                if (integerArray2 != null) {
                    integerArray = integerArray2;
                    return integerArray;
                }
            }
        }
        integerArray = new Integer[]{};
        return integerArray;
    }

    @Override
    public void write(int data) throws IOException {
        this.outermostStream.write(data);
    }

    @Override
    public void write(@NotNull byte[] buffer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(@NotNull byte[] buffer, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.outermostStream.write(buffer, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.outermostStream.flush();
    }

    @Override
    public void close() throws IOException {
        OutputStream outputStream;
        if (this.closed) {
            return;
        }
        this.outermostStream.close();
        OutputStream outputStream2 = this.literalDataStream;
        if (outputStream2 != null) {
            OutputStream $this$close_u24lambda_u2414 = outputStream = outputStream2;
            boolean bl = false;
            $this$close_u24lambda_u2414.flush();
            $this$close_u24lambda_u2414.close();
        }
        PGPLiteralDataGenerator pGPLiteralDataGenerator = this.literalDataGenerator;
        if (pGPLiteralDataGenerator != null) {
            pGPLiteralDataGenerator.close();
        }
        if (this.options.isCleartextSigned()) {
            ArmoredOutputStream armoredOutputStream = this.armorOutputStream;
            if (armoredOutputStream != null) {
                OutputStream $this$close_u24lambda_u2415 = outputStream = armoredOutputStream;
                boolean bl = false;
                $this$close_u24lambda_u2415.write(13);
                $this$close_u24lambda_u2415.write(10);
                $this$close_u24lambda_u2415.endClearText();
            }
        }
        try {
            this.writeSignatures();
        }
        catch (PGPException e) {
            throw new IOException("Exception while writing signatures.", e);
        }
        PGPCompressedDataGenerator pGPCompressedDataGenerator = this.compressedDataGenerator;
        if (pGPCompressedDataGenerator != null) {
            pGPCompressedDataGenerator.close();
        }
        OutputStream outputStream3 = this.publicKeyEncryptedStream;
        if (outputStream3 != null) {
            OutputStream $this$close_u24lambda_u2416 = outputStream = outputStream3;
            boolean bl = false;
            $this$close_u24lambda_u2416.flush();
            $this$close_u24lambda_u2416.close();
        }
        ArmoredOutputStream armoredOutputStream = this.armorOutputStream;
        if (armoredOutputStream != null) {
            OutputStream $this$close_u24lambda_u2417 = outputStream = armoredOutputStream;
            boolean bl = false;
            $this$close_u24lambda_u2417.flush();
            $this$close_u24lambda_u2417.close();
        }
        this.closed = true;
    }

    private final void writeSignatures() throws PGPException, IOException {
        if (this.options.getSigningOptions() == null) {
            return;
        }
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)this.options.getSigningOptions().getSigningMethods().entrySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            OpenPGPKey.OpenPGPPrivateKey key = (OpenPGPKey.OpenPGPPrivateKey)entry.getKey();
            SigningOptions.SigningMethod method = (SigningOptions.SigningMethod)entry.getValue();
            PGPSignature sig = method.getSignatureGenerator().generate();
            boolean bl2 = false;
            OpenPGPSignature.OpenPGPDocumentSignature documentSignature = new OpenPGPSignature.OpenPGPDocumentSignature(sig, key.getPublicKey());
            if (method.isDetached()) {
                this.resultBuilder.addDetachedSignature(documentSignature);
            }
            if (method.isDetached() && !this.options.isCleartextSigned()) continue;
            sig.encode(this.signatureLayerStream);
        }
    }

    @NotNull
    public final EncryptionResult getResult() {
        if (!this.closed) {
            boolean $i$a$-check-EncryptionStream$result$22 = false;
            String $i$a$-check-EncryptionStream$result$22 = "EncryptionStream must be closed before accessing the result.";
            throw new IllegalStateException($i$a$-check-EncryptionStream$result$22.toString());
        }
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        return this.resultBuilder.build();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    private static final void prepareEncryption$lambda$4(EncryptionStream this$0, PGPSessionKey pgpSessionKey) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (pgpSessionKey != null) {
            this$0.resultBuilder.setSessionKey(new SessionKey(pgpSessionKey));
        }
    }
}

