/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.encryption_signing.OpenPGPSignatureSet;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.MultiMap;
import org.pgpainless.util.SessionKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 G2\u00020\u0001:\u0002FGBS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\u000b\u00105\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u00106\u001a\u00020\u0007H\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\t\u00109\u001a\u00020\u000fH\u00c6\u0003J\t\u0010:\u001a\u00020\u0011H\u00c6\u0003J\t\u0010;\u001a\u00020\u0013H\u00c6\u0003Jg\u0010<\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u0010=\u001a\u00020,2\b\u0010>\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010?\u001a\u00020@H\u00d6\u0001J\u000e\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020CJ\u000e\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020DJ\t\u0010E\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R&\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001b0\u001a8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010\u001d\u001a\u0004\b#\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010-R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006H"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionResult;", "", "encryptionMechanism", "Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "sessionKey", "Lorg/pgpainless/util/SessionKey;", "compressionAlgorithm", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "detachedDocumentSignatures", "Lorg/pgpainless/encryption_signing/OpenPGPSignatureSet;", "Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;", "recipients", "", "Lorg/pgpainless/key/SubkeyIdentifier;", "fileName", "", "modificationDate", "Ljava/util/Date;", "fileEncoding", "Lorg/pgpainless/algorithm/StreamEncoding;", "(Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;Lorg/pgpainless/util/SessionKey;Lorg/pgpainless/algorithm/CompressionAlgorithm;Lorg/pgpainless/encryption_signing/OpenPGPSignatureSet;Ljava/util/Set;Ljava/lang/String;Ljava/util/Date;Lorg/pgpainless/algorithm/StreamEncoding;)V", "getCompressionAlgorithm", "()Lorg/pgpainless/algorithm/CompressionAlgorithm;", "getDetachedDocumentSignatures", "()Lorg/pgpainless/encryption_signing/OpenPGPSignatureSet;", "detachedSignatures", "Lorg/pgpainless/util/MultiMap;", "Lorg/bouncycastle/openpgp/PGPSignature;", "getDetachedSignatures$annotations", "()V", "getDetachedSignatures", "()Lorg/pgpainless/util/MultiMap;", "encryptionAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getEncryptionAlgorithm$annotations", "getEncryptionAlgorithm", "()Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getEncryptionMechanism", "()Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "getFileEncoding", "()Lorg/pgpainless/algorithm/StreamEncoding;", "getFileName", "()Ljava/lang/String;", "isForYourEyesOnly", "", "()Z", "getModificationDate", "()Ljava/util/Date;", "getRecipients", "()Ljava/util/Set;", "getSessionKey", "()Lorg/pgpainless/util/SessionKey;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "isEncryptedFor", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "toString", "Builder", "Companion", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nEncryptionResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionResult.kt\norg/pgpainless/encryption_signing/EncryptionResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1549#2:133\n1620#2,3:134\n1855#2,2:137\n1747#2,3:139\n1747#2,3:142\n*S KotlinDebug\n*F\n+ 1 EncryptionResult.kt\norg/pgpainless/encryption_signing/EncryptionResult\n*L\n45#1:133\n45#1:134,3\n46#1:137,2\n60#1:139,3\n68#1:142,3\n*E\n"})
public final class EncryptionResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageEncryptionMechanism encryptionMechanism;
    @Nullable
    private final SessionKey sessionKey;
    @NotNull
    private final CompressionAlgorithm compressionAlgorithm;
    @NotNull
    private final OpenPGPSignatureSet<OpenPGPSignature.OpenPGPDocumentSignature> detachedDocumentSignatures;
    @NotNull
    private final Set<SubkeyIdentifier> recipients;
    @NotNull
    private final String fileName;
    @NotNull
    private final Date modificationDate;
    @NotNull
    private final StreamEncoding fileEncoding;

    public EncryptionResult(@NotNull MessageEncryptionMechanism encryptionMechanism, @Nullable SessionKey sessionKey, @NotNull CompressionAlgorithm compressionAlgorithm, @NotNull OpenPGPSignatureSet<OpenPGPSignature.OpenPGPDocumentSignature> detachedDocumentSignatures, @NotNull Set<SubkeyIdentifier> recipients, @NotNull String fileName, @NotNull Date modificationDate, @NotNull StreamEncoding fileEncoding) {
        Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
        Intrinsics.checkNotNullParameter((Object)((Object)compressionAlgorithm), (String)"compressionAlgorithm");
        Intrinsics.checkNotNullParameter(detachedDocumentSignatures, (String)"detachedDocumentSignatures");
        Intrinsics.checkNotNullParameter(recipients, (String)"recipients");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)modificationDate, (String)"modificationDate");
        Intrinsics.checkNotNullParameter((Object)((Object)fileEncoding), (String)"fileEncoding");
        this.encryptionMechanism = encryptionMechanism;
        this.sessionKey = sessionKey;
        this.compressionAlgorithm = compressionAlgorithm;
        this.detachedDocumentSignatures = detachedDocumentSignatures;
        this.recipients = recipients;
        this.fileName = fileName;
        this.modificationDate = modificationDate;
        this.fileEncoding = fileEncoding;
    }

    @NotNull
    public final MessageEncryptionMechanism getEncryptionMechanism() {
        return this.encryptionMechanism;
    }

    @Nullable
    public final SessionKey getSessionKey() {
        return this.sessionKey;
    }

    @NotNull
    public final CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @NotNull
    public final OpenPGPSignatureSet<OpenPGPSignature.OpenPGPDocumentSignature> getDetachedDocumentSignatures() {
        return this.detachedDocumentSignatures;
    }

    @NotNull
    public final Set<SubkeyIdentifier> getRecipients() {
        return this.recipients;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final Date getModificationDate() {
        return this.modificationDate;
    }

    @NotNull
    public final StreamEncoding getFileEncoding() {
        return this.fileEncoding;
    }

    @Nullable
    public final SymmetricKeyAlgorithm getEncryptionAlgorithm() {
        return SymmetricKeyAlgorithm.Companion.fromId(this.encryptionMechanism.getSymmetricKeyAlgorithm());
    }

    @Deprecated(message="Use encryptionMechanism instead.", replaceWith=@ReplaceWith(expression="encryptionMechanism", imports={}))
    public static /* synthetic */ void getEncryptionAlgorithm$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MultiMap<SubkeyIdentifier, PGPSignature> getDetachedSignatures() {
        void $this$mapTo$iv$iv;
        MultiMap<SubkeyIdentifier, PGPSignature> map = new MultiMap<SubkeyIdentifier, PGPSignature>();
        Iterable $this$map$iv = this.detachedDocumentSignatures.getSignatures();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OpenPGPSignature.OpenPGPDocumentSignature openPGPDocumentSignature = (OpenPGPSignature.OpenPGPDocumentSignature)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey = it.getIssuer();
            Intrinsics.checkNotNullExpressionValue((Object)openPGPComponentKey, (String)"getIssuer(...)");
            collection.add(TuplesKt.to((Object)new SubkeyIdentifier(openPGPComponentKey), (Object)it.getSignature()));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object object = it.getFirst();
            Object object2 = it.getSecond();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-second>(...)");
            map.put((SubkeyIdentifier)object, (PGPSignature)object2);
        }
        return map;
    }

    @Deprecated(message="Use detachedSignatures instead", replaceWith=@ReplaceWith(expression="detachedDocumentSignatures", imports={}))
    public static /* synthetic */ void getDetachedSignatures$annotations() {
    }

    public final boolean isForYourEyesOnly() {
        return Intrinsics.areEqual((Object)"_CONSOLE", (Object)this.fileName);
    }

    public final boolean isEncryptedFor(@NotNull OpenPGPCertificate certificate) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Iterable $this$any$iv = this.recipients;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SubkeyIdentifier it = (SubkeyIdentifier)element$iv;
                    boolean bl2 = false;
                    if (!(certificate.getKey(it.getKeyIdentifier()) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isEncryptedFor(@NotNull PGPPublicKeyRing certificate) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            Iterable $this$any$iv = this.recipients;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SubkeyIdentifier it = (SubkeyIdentifier)element$iv;
                    boolean bl2 = false;
                    if (!PGPKeyRingExtensionsKt.matches((PGPKeyRing)certificate, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final MessageEncryptionMechanism component1() {
        return this.encryptionMechanism;
    }

    @Nullable
    public final SessionKey component2() {
        return this.sessionKey;
    }

    @NotNull
    public final CompressionAlgorithm component3() {
        return this.compressionAlgorithm;
    }

    @NotNull
    public final OpenPGPSignatureSet<OpenPGPSignature.OpenPGPDocumentSignature> component4() {
        return this.detachedDocumentSignatures;
    }

    @NotNull
    public final Set<SubkeyIdentifier> component5() {
        return this.recipients;
    }

    @NotNull
    public final String component6() {
        return this.fileName;
    }

    @NotNull
    public final Date component7() {
        return this.modificationDate;
    }

    @NotNull
    public final StreamEncoding component8() {
        return this.fileEncoding;
    }

    @NotNull
    public final EncryptionResult copy(@NotNull MessageEncryptionMechanism encryptionMechanism, @Nullable SessionKey sessionKey, @NotNull CompressionAlgorithm compressionAlgorithm, @NotNull OpenPGPSignatureSet<OpenPGPSignature.OpenPGPDocumentSignature> detachedDocumentSignatures, @NotNull Set<SubkeyIdentifier> recipients, @NotNull String fileName, @NotNull Date modificationDate, @NotNull StreamEncoding fileEncoding) {
        Intrinsics.checkNotNullParameter((Object)encryptionMechanism, (String)"encryptionMechanism");
        Intrinsics.checkNotNullParameter((Object)((Object)compressionAlgorithm), (String)"compressionAlgorithm");
        Intrinsics.checkNotNullParameter(detachedDocumentSignatures, (String)"detachedDocumentSignatures");
        Intrinsics.checkNotNullParameter(recipients, (String)"recipients");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)modificationDate, (String)"modificationDate");
        Intrinsics.checkNotNullParameter((Object)((Object)fileEncoding), (String)"fileEncoding");
        return new EncryptionResult(encryptionMechanism, sessionKey, compressionAlgorithm, detachedDocumentSignatures, recipients, fileName, modificationDate, fileEncoding);
    }

    public static /* synthetic */ EncryptionResult copy$default(EncryptionResult encryptionResult, MessageEncryptionMechanism messageEncryptionMechanism, SessionKey sessionKey, CompressionAlgorithm compressionAlgorithm, OpenPGPSignatureSet openPGPSignatureSet, Set set, String string, Date date, StreamEncoding streamEncoding, int n, Object object) {
        if ((n & 1) != 0) {
            messageEncryptionMechanism = encryptionResult.encryptionMechanism;
        }
        if ((n & 2) != 0) {
            sessionKey = encryptionResult.sessionKey;
        }
        if ((n & 4) != 0) {
            compressionAlgorithm = encryptionResult.compressionAlgorithm;
        }
        if ((n & 8) != 0) {
            openPGPSignatureSet = encryptionResult.detachedDocumentSignatures;
        }
        if ((n & 0x10) != 0) {
            set = encryptionResult.recipients;
        }
        if ((n & 0x20) != 0) {
            string = encryptionResult.fileName;
        }
        if ((n & 0x40) != 0) {
            date = encryptionResult.modificationDate;
        }
        if ((n & 0x80) != 0) {
            streamEncoding = encryptionResult.fileEncoding;
        }
        return encryptionResult.copy(messageEncryptionMechanism, sessionKey, compressionAlgorithm, openPGPSignatureSet, set, string, date, streamEncoding);
    }

    @NotNull
    public String toString() {
        return "EncryptionResult(encryptionMechanism=" + this.encryptionMechanism + ", sessionKey=" + this.sessionKey + ", compressionAlgorithm=" + this.compressionAlgorithm + ", detachedDocumentSignatures=" + this.detachedDocumentSignatures + ", recipients=" + this.recipients + ", fileName=" + this.fileName + ", modificationDate=" + this.modificationDate + ", fileEncoding=" + this.fileEncoding + ")";
    }

    public int hashCode() {
        int result = this.encryptionMechanism.hashCode();
        result = result * 31 + (this.sessionKey == null ? 0 : this.sessionKey.hashCode());
        result = result * 31 + this.compressionAlgorithm.hashCode();
        result = result * 31 + this.detachedDocumentSignatures.hashCode();
        result = result * 31 + ((Object)this.recipients).hashCode();
        result = result * 31 + this.fileName.hashCode();
        result = result * 31 + this.modificationDate.hashCode();
        result = result * 31 + this.fileEncoding.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EncryptionResult)) {
            return false;
        }
        EncryptionResult encryptionResult = (EncryptionResult)other;
        if (!Intrinsics.areEqual((Object)this.encryptionMechanism, (Object)encryptionResult.encryptionMechanism)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sessionKey, (Object)encryptionResult.sessionKey)) {
            return false;
        }
        if (this.compressionAlgorithm != encryptionResult.compressionAlgorithm) {
            return false;
        }
        if (!Intrinsics.areEqual(this.detachedDocumentSignatures, encryptionResult.detachedDocumentSignatures)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.recipients, encryptionResult.recipients)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fileName, (Object)encryptionResult.fileName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.modificationDate, (Object)encryptionResult.modificationDate)) {
            return false;
        }
        return this.fileEncoding == encryptionResult.fileEncoding;
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0019J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\fJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\nJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0012J\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0014J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00063"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionResult$Builder;", "", "()V", "_compressionAlgorithm", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "get_compressionAlgorithm", "()Lorg/pgpainless/algorithm/CompressionAlgorithm;", "set_compressionAlgorithm", "(Lorg/pgpainless/algorithm/CompressionAlgorithm;)V", "_encoding", "Lorg/pgpainless/algorithm/StreamEncoding;", "_encryptionMechanism", "Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "get_encryptionMechanism", "()Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "set_encryptionMechanism", "(Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;)V", "_fileName", "", "_modificationDate", "Ljava/util/Date;", "_sessionKey", "Lorg/pgpainless/util/SessionKey;", "detachedSignatures", "", "Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;", "getDetachedSignatures", "()Ljava/util/List;", "recipients", "", "Lorg/pgpainless/key/SubkeyIdentifier;", "getRecipients", "()Ljava/util/Set;", "addDetachedSignature", "signature", "addRecipient", "recipient", "build", "Lorg/pgpainless/encryption_signing/EncryptionResult;", "setCompressionAlgorithm", "compressionAlgorithm", "setEncryptionMechanism", "mechanism", "setFileEncoding", "encoding", "setFileName", "fileName", "setModificationDate", "modificationDate", "setSessionKey", "sessionKey", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nEncryptionResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionResult.kt\norg/pgpainless/encryption_signing/EncryptionResult$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1#2:133\n*E\n"})
    public static final class Builder {
        @NotNull
        private MessageEncryptionMechanism _encryptionMechanism;
        @Nullable
        private CompressionAlgorithm _compressionAlgorithm;
        @NotNull
        private final List<OpenPGPSignature.OpenPGPDocumentSignature> detachedSignatures;
        @NotNull
        private final Set<SubkeyIdentifier> recipients;
        @NotNull
        private String _fileName;
        @NotNull
        private Date _modificationDate;
        @NotNull
        private StreamEncoding _encoding;
        @Nullable
        private SessionKey _sessionKey;

        public Builder() {
            MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.unencrypted();
            Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"unencrypted(...)");
            this._encryptionMechanism = messageEncryptionMechanism;
            this.detachedSignatures = new ArrayList();
            this.recipients = new LinkedHashSet();
            this._fileName = "";
            this._modificationDate = new Date(0L);
            this._encoding = StreamEncoding.BINARY;
        }

        @NotNull
        public final MessageEncryptionMechanism get_encryptionMechanism() {
            return this._encryptionMechanism;
        }

        public final void set_encryptionMechanism(@NotNull MessageEncryptionMechanism messageEncryptionMechanism) {
            Intrinsics.checkNotNullParameter((Object)messageEncryptionMechanism, (String)"<set-?>");
            this._encryptionMechanism = messageEncryptionMechanism;
        }

        @Nullable
        public final CompressionAlgorithm get_compressionAlgorithm() {
            return this._compressionAlgorithm;
        }

        public final void set_compressionAlgorithm(@Nullable CompressionAlgorithm compressionAlgorithm) {
            this._compressionAlgorithm = compressionAlgorithm;
        }

        @NotNull
        public final List<OpenPGPSignature.OpenPGPDocumentSignature> getDetachedSignatures() {
            return this.detachedSignatures;
        }

        @NotNull
        public final Set<SubkeyIdentifier> getRecipients() {
            return this.recipients;
        }

        @NotNull
        public final Builder setEncryptionMechanism(@NotNull MessageEncryptionMechanism mechanism) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)mechanism, (String)"mechanism");
            Builder $this$setEncryptionMechanism_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$setEncryptionMechanism_u24lambda_u240._encryptionMechanism = mechanism;
            return builder;
        }

        @NotNull
        public final Builder setCompressionAlgorithm(@NotNull CompressionAlgorithm compressionAlgorithm) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)compressionAlgorithm), (String)"compressionAlgorithm");
            Builder $this$setCompressionAlgorithm_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$setCompressionAlgorithm_u24lambda_u241._compressionAlgorithm = compressionAlgorithm;
            return builder;
        }

        @NotNull
        public final Builder setFileName(@NotNull String fileName) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Builder $this$setFileName_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$setFileName_u24lambda_u242._fileName = fileName;
            return builder;
        }

        @NotNull
        public final Builder setModificationDate(@NotNull Date modificationDate) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)modificationDate, (String)"modificationDate");
            Builder $this$setModificationDate_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$setModificationDate_u24lambda_u243._modificationDate = modificationDate;
            return builder;
        }

        @NotNull
        public final Builder setFileEncoding(@NotNull StreamEncoding encoding) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
            Builder $this$setFileEncoding_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$setFileEncoding_u24lambda_u244._encoding = encoding;
            return builder;
        }

        @NotNull
        public final Builder addRecipient(@NotNull SubkeyIdentifier recipient) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)recipient, (String)"recipient");
            Builder $this$addRecipient_u24lambda_u245 = builder = this;
            boolean bl = false;
            Set<SubkeyIdentifier> set = $this$addRecipient_u24lambda_u245.recipients;
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<org.pgpainless.key.SubkeyIdentifier>");
            TypeIntrinsics.asMutableSet(set).add(recipient);
            return builder;
        }

        @NotNull
        public final Builder setSessionKey(@NotNull SessionKey sessionKey) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)sessionKey, (String)"sessionKey");
            Builder $this$setSessionKey_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$setSessionKey_u24lambda_u246._sessionKey = sessionKey;
            return builder;
        }

        @NotNull
        public final Builder addDetachedSignature(@NotNull OpenPGPSignature.OpenPGPDocumentSignature signature) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Builder $this$addDetachedSignature_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$addDetachedSignature_u24lambda_u247.detachedSignatures.add(signature);
            return builder;
        }

        @NotNull
        public final EncryptionResult build() {
            if (this._compressionAlgorithm == null) {
                boolean bl = false;
                String string = "Compression algorithm not set.";
                throw new IllegalStateException(string.toString());
            }
            CompressionAlgorithm compressionAlgorithm = this._compressionAlgorithm;
            Intrinsics.checkNotNull((Object)((Object)compressionAlgorithm));
            return new EncryptionResult(this._encryptionMechanism, this._sessionKey, compressionAlgorithm, new OpenPGPSignatureSet<OpenPGPSignature.OpenPGPDocumentSignature>(this.detachedSignatures), this.recipients, this._fileName, this._modificationDate, this._encoding);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionResult$Companion;", "", "()V", "builder", "Lorg/pgpainless/encryption_signing/EncryptionResult$Builder;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

