/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.MarkerPacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.OpenPgpPacket;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/decryption_verification/TeeBCPGInputStream;", "", "inputStream", "Lorg/bouncycastle/bcpg/BCPGInputStream;", "outputStream", "Ljava/io/OutputStream;", "(Lorg/bouncycastle/bcpg/BCPGInputStream;Ljava/io/OutputStream;)V", "delayedTee", "Lorg/pgpainless/decryption_verification/TeeBCPGInputStream$DelayedTeeInputStream;", "packetInputStream", "close", "", "nextPacketTag", "Lorg/pgpainless/algorithm/OpenPgpPacket;", "readCompressedData", "Lorg/bouncycastle/openpgp/PGPCompressedData;", "readEncryptedDataList", "Lorg/bouncycastle/openpgp/PGPEncryptedDataList;", "readLiteralData", "Lorg/bouncycastle/openpgp/PGPLiteralData;", "readMarker", "Lorg/bouncycastle/bcpg/MarkerPacket;", "readOnePassSignature", "Lorg/bouncycastle/openpgp/PGPOnePassSignature;", "readPacket", "Lorg/bouncycastle/bcpg/Packet;", "readPadding", "Lorg/bouncycastle/openpgp/PGPPadding;", "readSignature", "Lorg/bouncycastle/openpgp/PGPSignature;", "DelayedTeeInputStream", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nTeeBCPGInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeeBCPGInputStream.kt\norg/pgpainless/decryption_verification/TeeBCPGInputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class TeeBCPGInputStream {
    @NotNull
    private final DelayedTeeInputStream delayedTee;
    @NotNull
    private final BCPGInputStream packetInputStream;

    public TeeBCPGInputStream(@NotNull BCPGInputStream inputStream, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.delayedTee = new DelayedTeeInputStream((InputStream)inputStream, outputStream);
        this.packetInputStream = new BCPGInputStream((InputStream)this.delayedTee);
    }

    @Nullable
    public final OpenPgpPacket nextPacketTag() {
        int it = this.packetInputStream.nextPacketTag();
        boolean bl = false;
        return it == -1 ? null : OpenPgpPacket.Companion.requireFromTag(it);
    }

    @NotNull
    public final Packet readPacket() {
        Packet packet = this.packetInputStream.readPacket();
        Intrinsics.checkNotNullExpressionValue((Object)packet, (String)"readPacket(...)");
        return packet;
    }

    @NotNull
    public final PGPCompressedData readCompressedData() {
        this.delayedTee.squeeze();
        return new PGPCompressedData(this.packetInputStream);
    }

    @NotNull
    public final PGPLiteralData readLiteralData() {
        this.delayedTee.squeeze();
        return new PGPLiteralData(this.packetInputStream);
    }

    @NotNull
    public final PGPEncryptedDataList readEncryptedDataList() {
        this.delayedTee.squeeze();
        return new PGPEncryptedDataList(this.packetInputStream);
    }

    @NotNull
    public final PGPOnePassSignature readOnePassSignature() {
        PGPOnePassSignature pGPOnePassSignature;
        PGPOnePassSignature it = pGPOnePassSignature = new PGPOnePassSignature(this.packetInputStream);
        boolean bl = false;
        this.delayedTee.squeeze();
        return pGPOnePassSignature;
    }

    @NotNull
    public final PGPSignature readSignature() {
        PGPSignature pGPSignature;
        PGPSignature it = pGPSignature = new PGPSignature(this.packetInputStream);
        boolean bl = false;
        this.delayedTee.squeeze();
        return pGPSignature;
    }

    @NotNull
    public final MarkerPacket readMarker() {
        MarkerPacket markerPacket;
        Packet packet = this.readPacket();
        Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.MarkerPacket");
        MarkerPacket it = markerPacket = (MarkerPacket)packet;
        boolean bl = false;
        this.delayedTee.squeeze();
        return markerPacket;
    }

    @NotNull
    public final PGPPadding readPadding() {
        PGPPadding pGPPadding;
        PGPPadding it = pGPPadding = new PGPPadding(this.packetInputStream);
        boolean bl = false;
        this.delayedTee.squeeze();
        return pGPPadding;
    }

    public final void close() {
        this.packetInputStream.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0006\u0010\u000f\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/decryption_verification/TeeBCPGInputStream$DelayedTeeInputStream;", "Ljava/io/InputStream;", "inputStream", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/InputStream;Ljava/io/OutputStream;)V", "last", "", "close", "", "read", "b", "", "off", "len", "squeeze", "pgpainless-core"})
    public static final class DelayedTeeInputStream
    extends InputStream {
        @NotNull
        private final InputStream inputStream;
        @NotNull
        private final OutputStream outputStream;
        private int last;

        public DelayedTeeInputStream(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            this.inputStream = inputStream;
            this.outputStream = outputStream;
            this.last = -1;
        }

        @Override
        public int read() {
            int n;
            if (this.last != -1) {
                this.outputStream.write(this.last);
            }
            try {
                n = this.last = this.inputStream.read();
            }
            catch (IOException e) {
                String string = e.getMessage();
                boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"crc check failed in armored message", (boolean)false, (int)2, null) : false;
                if (bl) {
                    throw e;
                }
                n = -1;
            }
            return n;
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            int n;
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (this.last != -1) {
                this.outputStream.write(this.last);
            }
            int r = this.inputStream.read(b, off, len);
            boolean bl = false;
            if (r > 0) {
                this.outputStream.write(b, off, r - 1);
                n = b[off + r - 1];
            } else {
                n = -1;
            }
            this.last = n;
            return r;
        }

        public final void squeeze() {
            if (this.last != -1) {
                this.outputStream.write(this.last);
            }
            this.last = -1;
        }

        @Override
        public void close() {
            this.inputStream.close();
            this.outputStream.close();
        }
    }
}

