/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.exception.SignatureValidationException;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.signature.SignatureUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/pgpainless/decryption_verification/SignatureVerification;", "", "documentSignature", "Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;", "(Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;)V", "getDocumentSignature", "()Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "getSignature", "()Lorg/bouncycastle/openpgp/PGPSignature;", "signingKey", "Lorg/pgpainless/key/SubkeyIdentifier;", "getSigningKey", "()Lorg/pgpainless/key/SubkeyIdentifier;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Failure", "pgpainless-core"})
public final class SignatureVerification {
    @NotNull
    private final OpenPGPSignature.OpenPGPDocumentSignature documentSignature;
    @NotNull
    private final PGPSignature signature;
    @NotNull
    private final SubkeyIdentifier signingKey;

    public SignatureVerification(@NotNull OpenPGPSignature.OpenPGPDocumentSignature documentSignature) {
        Intrinsics.checkNotNullParameter((Object)documentSignature, (String)"documentSignature");
        this.documentSignature = documentSignature;
        PGPSignature pGPSignature = this.documentSignature.getSignature();
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
        this.signature = pGPSignature;
        OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey = this.documentSignature.getIssuer();
        Intrinsics.checkNotNullExpressionValue((Object)openPGPComponentKey, (String)"getIssuer(...)");
        this.signingKey = new SubkeyIdentifier(openPGPComponentKey);
    }

    @NotNull
    public final OpenPGPSignature.OpenPGPDocumentSignature getDocumentSignature() {
        return this.documentSignature;
    }

    @NotNull
    public final PGPSignature getSignature() {
        return this.signature;
    }

    @NotNull
    public final SubkeyIdentifier getSigningKey() {
        return this.signingKey;
    }

    @NotNull
    public String toString() {
        return "Signature: " + SignatureUtils.Companion.getSignatureDigestPrefix(this.signature) + "; Key: " + this.signingKey + ";";
    }

    @NotNull
    public final OpenPGPSignature.OpenPGPDocumentSignature component1() {
        return this.documentSignature;
    }

    @NotNull
    public final SignatureVerification copy(@NotNull OpenPGPSignature.OpenPGPDocumentSignature documentSignature) {
        Intrinsics.checkNotNullParameter((Object)documentSignature, (String)"documentSignature");
        return new SignatureVerification(documentSignature);
    }

    public static /* synthetic */ SignatureVerification copy$default(SignatureVerification signatureVerification, OpenPGPSignature.OpenPGPDocumentSignature openPGPDocumentSignature, int n, Object object) {
        if ((n & 1) != 0) {
            openPGPDocumentSignature = signatureVerification.documentSignature;
        }
        return signatureVerification.copy(openPGPDocumentSignature);
    }

    public int hashCode() {
        return this.documentSignature.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SignatureVerification)) {
            return false;
        }
        SignatureVerification signatureVerification = (SignatureVerification)other;
        return Intrinsics.areEqual((Object)this.documentSignature, (Object)signatureVerification.documentSignature);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lorg/pgpainless/decryption_verification/SignatureVerification$Failure;", "", "verification", "Lorg/pgpainless/decryption_verification/SignatureVerification;", "validationException", "Lorg/pgpainless/exception/SignatureValidationException;", "(Lorg/pgpainless/decryption_verification/SignatureVerification;Lorg/pgpainless/exception/SignatureValidationException;)V", "documentSignature", "Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;", "(Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;Lorg/pgpainless/exception/SignatureValidationException;)V", "getDocumentSignature", "()Lorg/bouncycastle/openpgp/api/OpenPGPSignature$OpenPGPDocumentSignature;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "getSignature", "()Lorg/bouncycastle/openpgp/PGPSignature;", "signingKey", "Lorg/pgpainless/key/SubkeyIdentifier;", "getSigningKey", "()Lorg/pgpainless/key/SubkeyIdentifier;", "getValidationException", "()Lorg/pgpainless/exception/SignatureValidationException;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nSignatureVerification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignatureVerification.kt\norg/pgpainless/decryption_verification/SignatureVerification$Failure\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
    public static final class Failure {
        @NotNull
        private final OpenPGPSignature.OpenPGPDocumentSignature documentSignature;
        @NotNull
        private final SignatureValidationException validationException;
        @NotNull
        private final PGPSignature signature;
        @Nullable
        private final SubkeyIdentifier signingKey;

        /*
         * WARNING - void declaration
         */
        public Failure(@NotNull OpenPGPSignature.OpenPGPDocumentSignature documentSignature, @NotNull SignatureValidationException validationException) {
            SubkeyIdentifier subkeyIdentifier;
            Intrinsics.checkNotNullParameter((Object)documentSignature, (String)"documentSignature");
            Intrinsics.checkNotNullParameter((Object)((Object)validationException), (String)"validationException");
            this.documentSignature = documentSignature;
            this.validationException = validationException;
            PGPSignature pGPSignature = this.documentSignature.getSignature();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"getSignature(...)");
            this.signature = pGPSignature;
            Failure failure = this;
            OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey = this.documentSignature.getIssuer();
            if (openPGPComponentKey != null) {
                void it;
                OpenPGPCertificate.OpenPGPComponentKey openPGPComponentKey2 = openPGPComponentKey;
                Failure failure2 = failure;
                boolean bl = false;
                subkeyIdentifier = new SubkeyIdentifier((OpenPGPCertificate.OpenPGPComponentKey)it);
                failure = failure2;
            } else {
                subkeyIdentifier = null;
            }
            failure.signingKey = subkeyIdentifier;
        }

        @NotNull
        public final OpenPGPSignature.OpenPGPDocumentSignature getDocumentSignature() {
            return this.documentSignature;
        }

        @NotNull
        public final SignatureValidationException getValidationException() {
            return this.validationException;
        }

        @NotNull
        public final PGPSignature getSignature() {
            return this.signature;
        }

        @Nullable
        public final SubkeyIdentifier getSigningKey() {
            return this.signingKey;
        }

        public Failure(@NotNull SignatureVerification verification, @NotNull SignatureValidationException validationException) {
            Intrinsics.checkNotNullParameter((Object)verification, (String)"verification");
            Intrinsics.checkNotNullParameter((Object)((Object)validationException), (String)"validationException");
            this(verification.getDocumentSignature(), validationException);
        }

        @NotNull
        public String toString() {
            String string = SignatureUtils.Companion.getSignatureDigestPrefix(this.signature);
            Object object = this.signingKey;
            if (object == null || (object = ((SubkeyIdentifier)object).toString()) == null) {
                object = "null";
            }
            return "Signature: " + string + "; Key: " + (String)object + "; Failure: " + this.validationException.getMessage();
        }

        @NotNull
        public final OpenPGPSignature.OpenPGPDocumentSignature component1() {
            return this.documentSignature;
        }

        @NotNull
        public final SignatureValidationException component2() {
            return this.validationException;
        }

        @NotNull
        public final Failure copy(@NotNull OpenPGPSignature.OpenPGPDocumentSignature documentSignature, @NotNull SignatureValidationException validationException) {
            Intrinsics.checkNotNullParameter((Object)documentSignature, (String)"documentSignature");
            Intrinsics.checkNotNullParameter((Object)((Object)validationException), (String)"validationException");
            return new Failure(documentSignature, validationException);
        }

        public static /* synthetic */ Failure copy$default(Failure failure, OpenPGPSignature.OpenPGPDocumentSignature openPGPDocumentSignature, SignatureValidationException signatureValidationException, int n, Object object) {
            if ((n & 1) != 0) {
                openPGPDocumentSignature = failure.documentSignature;
            }
            if ((n & 2) != 0) {
                signatureValidationException = failure.validationException;
            }
            return failure.copy(openPGPDocumentSignature, signatureValidationException);
        }

        public int hashCode() {
            int result = this.documentSignature.hashCode();
            result = result * 31 + this.validationException.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failure)) {
                return false;
            }
            Failure failure = (Failure)other;
            if (!Intrinsics.areEqual((Object)this.documentSignature, (Object)failure.documentSignature)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((Object)this.validationException), (Object)((Object)failure.validationException));
        }
    }
}

