/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.CompressedDataPacket;
import org.bouncycastle.bcpg.LiteralDataPacket;
import org.bouncycastle.bcpg.MarkerPacket;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.AEADAlgorithm;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/pgpainless/decryption_verification/OpenPGPAnimalSnifferInputStream;", "Ljava/io/BufferedInputStream;", "input", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "check", "", "(Ljava/io/InputStream;Z)V", "buffer", "", "bufferLen", "", "containsArmorHeader", "containsOpenPgpPackets", "isAsciiArmored", "()Z", "isBinaryOpenPgp", "isLikelyOpenPgpMessage", "isNonOpenPgp", "resemblesMessage", "checkForAsciiArmor", "checkForBinaryOpenPgp", "", "inspectBuffer", "nonExhaustiveParseAndCheckPlausibility", "packetIn", "Lorg/bouncycastle/bcpg/BCPGInputStream;", "startsWithIgnoringWhitespace", "bytes", "subSequence", "", "Companion", "pgpainless-core"})
public final class OpenPGPAnimalSnifferInputStream
extends BufferedInputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] buffer;
    private final int bufferLen;
    private boolean containsArmorHeader;
    private boolean containsOpenPgpPackets;
    private boolean resemblesMessage;
    @NotNull
    public static final String ARMOR_HEADER = "-----BEGIN PGP ";
    public static final int MAX_BUFFER_SIZE = 16384;

    public OpenPGPAnimalSnifferInputStream(@NotNull InputStream input, boolean check) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super(input);
        this.mark(16384);
        this.buffer = new byte[16384];
        this.bufferLen = this.read(this.buffer);
        this.reset();
        if (check) {
            this.inspectBuffer();
        }
    }

    public OpenPGPAnimalSnifferInputStream(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this(input, true);
    }

    public final boolean isAsciiArmored() {
        return this.containsArmorHeader;
    }

    public final boolean isBinaryOpenPgp() {
        return this.containsOpenPgpPackets;
    }

    public final boolean isLikelyOpenPgpMessage() {
        return this.resemblesMessage;
    }

    public final boolean isNonOpenPgp() {
        return !this.isAsciiArmored() && !this.isBinaryOpenPgp();
    }

    public final void inspectBuffer() {
        if (this.checkForAsciiArmor()) {
            return;
        }
        this.checkForBinaryOpenPgp();
    }

    private final boolean checkForAsciiArmor() {
        if (this.startsWithIgnoringWhitespace(this.buffer, ARMOR_HEADER, this.bufferLen)) {
            this.containsArmorHeader = true;
            return true;
        }
        return false;
    }

    private final void checkForBinaryOpenPgp() {
        if (this.bufferLen == -1) {
            return;
        }
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(this.buffer, 0, this.bufferLen);
        BCPGInputStream pIn = new BCPGInputStream((InputStream)bufferIn);
        try {
            this.nonExhaustiveParseAndCheckPlausibility(pIn);
        }
        catch (Exception e) {
            return;
        }
    }

    private final void nonExhaustiveParseAndCheckPlausibility(BCPGInputStream packetIn) {
        Packet packet = packetIn.readPacket();
        switch (packet.getPacketTag()) {
            case 1: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.PublicKeyEncSessionPacket");
                PublicKeyEncSessionPacket cfr_ignored_0 = (PublicKeyEncSessionPacket)packet;
                if (PublicKeyAlgorithm.Companion.fromId(((PublicKeyEncSessionPacket)packet).getAlgorithm()) != null) break;
                return;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.SignaturePacket");
                SignaturePacket cfr_ignored_1 = (SignaturePacket)packet;
                if (SignatureType.Companion.fromCode(((SignaturePacket)packet).getSignatureType()) == null) {
                    return;
                }
                if (PublicKeyAlgorithm.Companion.fromId(((SignaturePacket)packet).getKeyAlgorithm()) == null) {
                    return;
                }
                if (HashAlgorithm.Companion.fromId(((SignaturePacket)packet).getHashAlgorithm()) != null) break;
                return;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.OnePassSignaturePacket");
                OnePassSignaturePacket cfr_ignored_2 = (OnePassSignaturePacket)packet;
                if (SignatureType.Companion.fromCode(((OnePassSignaturePacket)packet).getSignatureType()) == null) {
                    return;
                }
                if (PublicKeyAlgorithm.Companion.fromId(((OnePassSignaturePacket)packet).getKeyAlgorithm()) == null) {
                    return;
                }
                if (HashAlgorithm.Companion.fromId(((OnePassSignaturePacket)packet).getHashAlgorithm()) != null) break;
                return;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket");
                SymmetricKeyEncSessionPacket cfr_ignored_3 = (SymmetricKeyEncSessionPacket)packet;
                if (SymmetricKeyAlgorithm.Companion.fromId(((SymmetricKeyEncSessionPacket)packet).getEncAlgorithm()) != null) break;
                return;
            }
            case 5: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.SecretKeyPacket");
                SecretKeyPacket cfr_ignored_4 = (SecretKeyPacket)packet;
                PublicKeyPacket publicKey = ((SecretKeyPacket)packet).getPublicKeyPacket();
                if (PublicKeyAlgorithm.Companion.fromId(publicKey.getAlgorithm()) == null) {
                    return;
                }
                int n = publicKey.getVersion();
                if (3 <= n ? n < 7 : false) break;
                return;
            }
            case 6: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.PublicKeyPacket");
                PublicKeyPacket cfr_ignored_5 = (PublicKeyPacket)packet;
                if (PublicKeyAlgorithm.Companion.fromId(((PublicKeyPacket)packet).getAlgorithm()) == null) {
                    return;
                }
                int n = ((PublicKeyPacket)packet).getVersion();
                if (3 <= n ? n < 7 : false) break;
                return;
            }
            case 8: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.CompressedDataPacket");
                CompressedDataPacket cfr_ignored_6 = (CompressedDataPacket)packet;
                if (CompressionAlgorithm.Companion.fromId(((CompressedDataPacket)packet).getAlgorithm()) != null) break;
                return;
            }
            case 9: {
                break;
            }
            case 10: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.MarkerPacket");
                MarkerPacket cfr_ignored_7 = (MarkerPacket)packet;
                byte[] byArray = new byte[]{-54, 3, 80, 71, 80};
                if (Arrays.areEqual((byte[])((MarkerPacket)packet).getEncoded(PacketFormat.CURRENT), (byte[])byArray)) break;
                return;
            }
            case 11: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.LiteralDataPacket");
                LiteralDataPacket cfr_ignored_8 = (LiteralDataPacket)packet;
                char[] cArray = new char[]{'b', 'u', 't', 'l', '1', 'm'};
                if (ArraysKt.contains((char[])cArray, (char)((char)((LiteralDataPacket)packet).getFormat()))) break;
                return;
            }
            case 18: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.SymmetricEncIntegrityPacket");
                SymmetricEncIntegrityPacket cfr_ignored_9 = (SymmetricEncIntegrityPacket)packet;
                int[] nArray = new int[]{1, 2};
                if (!ArraysKt.contains((int[])nArray, (int)((SymmetricEncIntegrityPacket)packet).getVersion())) {
                    return;
                }
                if (((SymmetricEncIntegrityPacket)packet).getVersion() != 2) break;
                if (SymmetricKeyAlgorithm.Companion.fromId(((SymmetricEncIntegrityPacket)packet).getCipherAlgorithm()) == null) {
                    return;
                }
                if (AEADAlgorithm.Companion.fromId(((SymmetricEncIntegrityPacket)packet).getAeadAlgorithm()) != null) break;
                return;
            }
            case 20: {
                Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.AEADEncDataPacket");
                AEADEncDataPacket cfr_ignored_10 = (AEADEncDataPacket)packet;
                if (SymmetricKeyAlgorithm.Companion.fromId(((AEADEncDataPacket)packet).getAlgorithm()) != null) break;
                return;
            }
            case 0: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                this.containsOpenPgpPackets = true;
                this.resemblesMessage = false;
                return;
            }
            default: {
                return;
            }
        }
        this.containsOpenPgpPackets = true;
        if (packet.getPacketTag() != 9) {
            this.resemblesMessage = true;
        }
    }

    private final boolean startsWithIgnoringWhitespace(byte[] bytes, CharSequence subSequence, int bufferLen) {
        if (bufferLen == -1) {
            return false;
        }
        for (int i = 0; i < bufferLen; ++i) {
            if (Character.isWhitespace(bytes[i])) continue;
            if (i + subSequence.length() > bytes.length) {
                return false;
            }
            int n = subSequence.length();
            for (int j = 0; j < n; ++j) {
                if ((char)bytes[i + j] == subSequence.charAt(j)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/decryption_verification/OpenPGPAnimalSnifferInputStream$Companion;", "", "()V", "ARMOR_HEADER", "", "MAX_BUFFER_SIZE", "", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

