/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.decryption_verification.CustomPublicKeyDataDecryptorFactory;
import org.pgpainless.key.SubkeyIdentifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lorg/pgpainless/decryption_verification/HardwareSecurity;", "", "()V", "DecryptionCallback", "HardwareDataDecryptorFactory", "HardwareSecurityException", "pgpainless-core"})
public final class HardwareSecurity {

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0017J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H&\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lorg/pgpainless/decryption_verification/HardwareSecurity$DecryptionCallback;", "", "decryptSessionKey", "", "keyId", "", "keyAlgorithm", "", "sessionKeyData", "pkeskVersion", "keyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "pgpainless-core"})
    public static interface DecryptionCallback {
        @kotlin.Deprecated(message="Pass in a KeyIdentifier instead of a Long keyId.")
        @NotNull
        default public byte[] decryptSessionKey(long keyId, int keyAlgorithm, @NotNull byte[] sessionKeyData, int pkeskVersion) throws HardwareSecurityException {
            Intrinsics.checkNotNullParameter((Object)sessionKeyData, (String)"sessionKeyData");
            return this.decryptSessionKey(new KeyIdentifier(keyId), keyAlgorithm, sessionKeyData, pkeskVersion);
        }

        @NotNull
        public byte[] decryptSessionKey(@NotNull KeyIdentifier var1, int var2, @NotNull byte[] var3, int var4) throws HardwareSecurityException;

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @kotlin.Deprecated(message="Pass in a KeyIdentifier instead of a Long keyId.")
            @Deprecated
            @NotNull
            public static byte[] decryptSessionKey(@NotNull DecryptionCallback $this, long keyId, int keyAlgorithm, @NotNull byte[] sessionKeyData, int pkeskVersion) throws HardwareSecurityException {
                Intrinsics.checkNotNullParameter((Object)sessionKeyData, (String)"sessionKeyData");
                return $this.decryptSessionKey(keyId, keyAlgorithm, sessionKeyData, pkeskVersion);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J-\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00102\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0017\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/decryption_verification/HardwareSecurity$HardwareDataDecryptorFactory;", "Lorg/pgpainless/decryption_verification/CustomPublicKeyDataDecryptorFactory;", "subkeyIdentifier", "Lorg/pgpainless/key/SubkeyIdentifier;", "callback", "Lorg/pgpainless/decryption_verification/HardwareSecurity$DecryptionCallback;", "(Lorg/pgpainless/key/SubkeyIdentifier;Lorg/pgpainless/decryption_verification/HardwareSecurity$DecryptionCallback;)V", "factory", "Lorg/bouncycastle/openpgp/operator/PublicKeyDataDecryptorFactory;", "getSubkeyIdentifier", "()Lorg/pgpainless/key/SubkeyIdentifier;", "createDataDecryptor", "Lorg/bouncycastle/openpgp/operator/PGPDataDecryptor;", "withIntegrityPacket", "", "encAlgorithm", "", "key", "", "aeadEncDataPacket", "Lorg/bouncycastle/bcpg/AEADEncDataPacket;", "sessionKey", "Lorg/bouncycastle/openpgp/PGPSessionKey;", "seipd", "Lorg/bouncycastle/bcpg/SymmetricEncIntegrityPacket;", "recoverSessionData", "keyAlgorithm", "secKeyData", "", "pkeskVersion", "(I[[BI)[B", "pgpainless-core"})
    public static final class HardwareDataDecryptorFactory
    extends CustomPublicKeyDataDecryptorFactory {
        @NotNull
        private final SubkeyIdentifier subkeyIdentifier;
        @NotNull
        private final DecryptionCallback callback;
        @NotNull
        private final PublicKeyDataDecryptorFactory factory;

        public HardwareDataDecryptorFactory(@NotNull SubkeyIdentifier subkeyIdentifier, @NotNull DecryptionCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)subkeyIdentifier, (String)"subkeyIdentifier");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            this.subkeyIdentifier = subkeyIdentifier;
            this.callback = callback2;
            this.factory = (PublicKeyDataDecryptorFactory)new BcPublicKeyDataDecryptorFactory(null);
        }

        @Override
        @NotNull
        public SubkeyIdentifier getSubkeyIdentifier() {
            return this.subkeyIdentifier;
        }

        @NotNull
        public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, @Nullable byte[] key) {
            PGPDataDecryptor pGPDataDecryptor = this.factory.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            Intrinsics.checkNotNullExpressionValue((Object)pGPDataDecryptor, (String)"createDataDecryptor(...)");
            return pGPDataDecryptor;
        }

        @NotNull
        public PGPDataDecryptor createDataDecryptor(@Nullable AEADEncDataPacket aeadEncDataPacket, @Nullable PGPSessionKey sessionKey) {
            PGPDataDecryptor pGPDataDecryptor = this.factory.createDataDecryptor(aeadEncDataPacket, sessionKey);
            Intrinsics.checkNotNullExpressionValue((Object)pGPDataDecryptor, (String)"createDataDecryptor(...)");
            return pGPDataDecryptor;
        }

        @NotNull
        public PGPDataDecryptor createDataDecryptor(@Nullable SymmetricEncIntegrityPacket seipd, @Nullable PGPSessionKey sessionKey) {
            PGPDataDecryptor pGPDataDecryptor = this.factory.createDataDecryptor(seipd, sessionKey);
            Intrinsics.checkNotNullExpressionValue((Object)pGPDataDecryptor, (String)"createDataDecryptor(...)");
            return pGPDataDecryptor;
        }

        @kotlin.Deprecated(message="Deprecated in Java")
        @NotNull
        public byte[] recoverSessionData(int keyAlgorithm, @NotNull byte[][] secKeyData, int pkeskVersion) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)secKeyData, (String)"secKeyData");
            try {
                byArray = this.callback.decryptSessionKey(this.getSubkeyIdentifier().getKeyIdentifier(), keyAlgorithm, secKeyData[0], pkeskVersion);
            }
            catch (HardwareSecurityException e) {
                throw new PGPException("Hardware-backed decryption failed.", (Exception)e);
            }
            return byArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/decryption_verification/HardwareSecurity$HardwareSecurityException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "pgpainless-core"})
    public static final class HardwareSecurityException
    extends Exception {
    }
}

