/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionBuilderInterface;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMessageInputStream;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/pgpainless/decryption_verification/DecryptionBuilder;", "Lorg/pgpainless/decryption_verification/DecryptionBuilderInterface;", "api", "Lorg/pgpainless/PGPainless;", "(Lorg/pgpainless/PGPainless;)V", "onInputStream", "Lorg/pgpainless/decryption_verification/DecryptionBuilderInterface$DecryptWith;", "inputStream", "Ljava/io/InputStream;", "DecryptWithImpl", "pgpainless-core"})
public final class DecryptionBuilder
implements DecryptionBuilderInterface {
    @NotNull
    private final PGPainless api;

    public DecryptionBuilder(@NotNull PGPainless api) {
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.api = api;
    }

    @Override
    @NotNull
    public DecryptionBuilderInterface.DecryptWith onInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return new DecryptWithImpl(inputStream, this.api);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/decryption_verification/DecryptionBuilder$DecryptWithImpl;", "Lorg/pgpainless/decryption_verification/DecryptionBuilderInterface$DecryptWith;", "inputStream", "Ljava/io/InputStream;", "api", "Lorg/pgpainless/PGPainless;", "(Ljava/io/InputStream;Lorg/pgpainless/PGPainless;)V", "getApi", "()Lorg/pgpainless/PGPainless;", "getInputStream", "()Ljava/io/InputStream;", "withOptions", "Lorg/pgpainless/decryption_verification/DecryptionStream;", "consumerOptions", "Lorg/pgpainless/decryption_verification/ConsumerOptions;", "pgpainless-core"})
    public static final class DecryptWithImpl
    implements DecryptionBuilderInterface.DecryptWith {
        @NotNull
        private final InputStream inputStream;
        @NotNull
        private final PGPainless api;

        public DecryptWithImpl(@NotNull InputStream inputStream, @NotNull PGPainless api) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            this.inputStream = inputStream;
            this.api = api;
        }

        @NotNull
        public final InputStream getInputStream() {
            return this.inputStream;
        }

        @NotNull
        public final PGPainless getApi() {
            return this.api;
        }

        @Override
        @NotNull
        public DecryptionStream withOptions(@NotNull ConsumerOptions consumerOptions) {
            Intrinsics.checkNotNullParameter((Object)consumerOptions, (String)"consumerOptions");
            return OpenPgpMessageInputStream.Companion.create(this.inputStream, consumerOptions, this.api);
        }
    }
}

