/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0004\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0004\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"getSecretKey", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPSecretKey;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "getSecretKeyFor", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "pkesk", "Lorg/bouncycastle/openpgp/PGPPublicKeyEncryptedData;", "isFullyDecrypted", "", "isFullyEncrypted", "unlock", "Lorg/bouncycastle/openpgp/api/OpenPGPKey$OpenPGPPrivateKey;", "passphrase", "Lorg/pgpainless/util/Passphrase;", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nOpenPGPKeyExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenPGPKeyExtensions.kt\norg/pgpainless/bouncycastle/extensions/OpenPGPKeyExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n2624#2,3:47\n1726#2,3:50\n*S KotlinDebug\n*F\n+ 1 OpenPGPKeyExtensions.kt\norg/pgpainless/bouncycastle/extensions/OpenPGPKeyExtensionsKt\n*L\n40#1:47,3\n44#1:50,3\n*E\n"})
public final class OpenPGPKeyExtensionsKt {
    @Nullable
    public static final OpenPGPKey.OpenPGPSecretKey getSecretKeyFor(@NotNull OpenPGPKey $this$getSecretKeyFor, @NotNull PGPPublicKeyEncryptedData pkesk) {
        Intrinsics.checkNotNullParameter((Object)$this$getSecretKeyFor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pkesk, (String)"pkesk");
        return $this$getSecretKeyFor.getSecretKey(pkesk.getKeyIdentifier());
    }

    @Nullable
    public static final OpenPGPKey.OpenPGPSecretKey getSecretKey(@NotNull OpenPGPCertificate.OpenPGPComponentKey $this$getSecretKey) {
        OpenPGPKey.OpenPGPSecretKey openPGPSecretKey;
        Intrinsics.checkNotNullParameter((Object)$this$getSecretKey, (String)"<this>");
        if ($this$getSecretKey.getCertificate() instanceof OpenPGPKey) {
            OpenPGPCertificate openPGPCertificate = $this$getSecretKey.getCertificate();
            Intrinsics.checkNotNull((Object)openPGPCertificate, (String)"null cannot be cast to non-null type org.bouncycastle.openpgp.api.OpenPGPKey");
            openPGPSecretKey = ((OpenPGPKey)openPGPCertificate).getSecretKey($this$getSecretKey);
        } else {
            openPGPSecretKey = null;
        }
        return openPGPSecretKey;
    }

    @NotNull
    public static final OpenPGPKey.OpenPGPPrivateKey unlock(@NotNull OpenPGPKey.OpenPGPSecretKey $this$unlock, @NotNull Passphrase passphrase) {
        Intrinsics.checkNotNullParameter((Object)$this$unlock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        OpenPGPKey.OpenPGPPrivateKey openPGPPrivateKey = $this$unlock.unlock(passphrase.getChars());
        Intrinsics.checkNotNullExpressionValue((Object)openPGPPrivateKey, (String)"unlock(...)");
        return openPGPPrivateKey;
    }

    public static final boolean isFullyDecrypted(@NotNull OpenPGPKey $this$isFullyDecrypted) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isFullyDecrypted, (String)"<this>");
            Iterable $this$none$iv = $this$isFullyDecrypted.getSecretKeys().values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    OpenPGPKey.OpenPGPSecretKey it = (OpenPGPKey.OpenPGPSecretKey)element$iv;
                    boolean bl2 = false;
                    if (!it.isLocked()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isFullyEncrypted(@NotNull OpenPGPKey $this$isFullyEncrypted) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isFullyEncrypted, (String)"<this>");
            Iterable $this$all$iv = $this$isFullyEncrypted.getSecretKeys().values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    OpenPGPKey.OpenPGPSecretKey it = (OpenPGPKey.OpenPGPSecretKey)element$iv;
                    boolean bl2 = false;
                    if (it.isLocked()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

