/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.api.EncryptedDataPacketType;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.bouncycastle.openpgp.api.OpenPGPImplementation;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"checksumCalculator", "Lorg/bouncycastle/openpgp/operator/PGPDigestCalculator;", "Lorg/bouncycastle/openpgp/api/OpenPGPImplementation;", "pgpDataEncryptorBuilder", "Lorg/bouncycastle/openpgp/operator/PGPDataEncryptorBuilder;", "mechanism", "Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nOpenPGPImplementationExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenPGPImplementationExtensions.kt\norg/pgpainless/bouncycastle/extensions/OpenPGPImplementationExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class OpenPGPImplementationExtensionsKt {
    @NotNull
    public static final PGPDigestCalculator checksumCalculator(@NotNull OpenPGPImplementation $this$checksumCalculator) {
        Intrinsics.checkNotNullParameter((Object)$this$checksumCalculator, (String)"<this>");
        PGPDigestCalculator pGPDigestCalculator = $this$checksumCalculator.pgpDigestCalculatorProvider().get(2);
        Intrinsics.checkNotNullExpressionValue((Object)pGPDigestCalculator, (String)"get(...)");
        return pGPDigestCalculator;
    }

    @NotNull
    public static final PGPDataEncryptorBuilder pgpDataEncryptorBuilder(@NotNull OpenPGPImplementation $this$pgpDataEncryptorBuilder, @NotNull MessageEncryptionMechanism mechanism) {
        PGPDataEncryptorBuilder pGPDataEncryptorBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$pgpDataEncryptorBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mechanism, (String)"mechanism");
        if (!mechanism.isEncrypted()) {
            boolean bl = false;
            String string = "Cannot create PGPDataEncryptorBuilder for NULL algorithm.";
            throw new IllegalArgumentException(string.toString());
        }
        PGPDataEncryptorBuilder it = pGPDataEncryptorBuilder = $this$pgpDataEncryptorBuilder.pgpDataEncryptorBuilder(mechanism.getSymmetricKeyAlgorithm());
        boolean bl = false;
        EncryptedDataPacketType encryptedDataPacketType = mechanism.getMode();
        Intrinsics.checkNotNull((Object)encryptedDataPacketType);
        switch (WhenMappings.$EnumSwitchMapping$0[encryptedDataPacketType.ordinal()]) {
            case 1: {
                it.setWithIntegrityPacket(false);
                break;
            }
            case 2: {
                it.setWithIntegrityPacket(true);
                break;
            }
            case 3: {
                it.setWithAEAD(mechanism.getAeadAlgorithm(), mechanism.getSymmetricKeyAlgorithm());
                it.setUseV6AEAD();
                break;
            }
            case 4: {
                it.setWithAEAD(mechanism.getAeadAlgorithm(), mechanism.getSymmetricKeyAlgorithm());
                it.setUseV5AEAD();
            }
        }
        PGPDataEncryptorBuilder pGPDataEncryptorBuilder2 = pGPDataEncryptorBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)pGPDataEncryptorBuilder2, (String)"also(...)");
        return pGPDataEncryptorBuilder2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EncryptedDataPacketType.values().length];
            try {
                nArray[EncryptedDataPacketType.SED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptedDataPacketType.SEIPDv1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptedDataPacketType.SEIPDv2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EncryptedDataPacketType.LIBREPGP_OED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

