/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.OpenPGPKeyVersion;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"asciiArmor", "", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "outputStream", "Ljava/io/OutputStream;", "format", "Lorg/bouncycastle/bcpg/PacketFormat;", "armorBuilder", "Lorg/bouncycastle/bcpg/ArmoredOutputStream$Builder;", "encode", "getKeyVersion", "Lorg/pgpainless/algorithm/OpenPGPKeyVersion;", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate$OpenPGPComponentKey;", "getSigningKeyFor", "ops", "Lorg/bouncycastle/openpgp/PGPOnePassSignature;", "pgpainless-core"})
public final class OpenPGPCertificateExtensionsKt {
    @Nullable
    public static final OpenPGPCertificate.OpenPGPComponentKey getSigningKeyFor(@NotNull OpenPGPCertificate $this$getSigningKeyFor, @NotNull PGPOnePassSignature ops) {
        Intrinsics.checkNotNullParameter((Object)$this$getSigningKeyFor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ops, (String)"ops");
        return $this$getSigningKeyFor.getKey(ops.getKeyIdentifier());
    }

    @NotNull
    public static final OpenPGPKeyVersion getKeyVersion(@NotNull OpenPGPCertificate $this$getKeyVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$getKeyVersion, (String)"<this>");
        OpenPGPCertificate.OpenPGPPrimaryKey openPGPPrimaryKey = $this$getKeyVersion.getPrimaryKey();
        Intrinsics.checkNotNullExpressionValue((Object)openPGPPrimaryKey, (String)"getPrimaryKey(...)");
        return OpenPGPCertificateExtensionsKt.getKeyVersion((OpenPGPCertificate.OpenPGPComponentKey)openPGPPrimaryKey);
    }

    @NotNull
    public static final OpenPGPKeyVersion getKeyVersion(@NotNull OpenPGPCertificate.OpenPGPComponentKey $this$getKeyVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$getKeyVersion, (String)"<this>");
        return OpenPGPKeyVersion.Companion.from($this$getKeyVersion.getVersion());
    }

    public static final void asciiArmor(@NotNull OpenPGPCertificate $this$asciiArmor, @NotNull OutputStream outputStream, @NotNull PacketFormat format) {
        Intrinsics.checkNotNullParameter((Object)$this$asciiArmor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String string = $this$asciiArmor.toAsciiArmoredString(format);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toAsciiArmoredString(...)");
        outputStream.write(StringsKt.encodeToByteArray((String)string));
    }

    public static /* synthetic */ void asciiArmor$default(OpenPGPCertificate openPGPCertificate, OutputStream outputStream, PacketFormat packetFormat, int n, Object object) {
        if ((n & 2) != 0) {
            packetFormat = PacketFormat.ROUNDTRIP;
        }
        OpenPGPCertificateExtensionsKt.asciiArmor(openPGPCertificate, outputStream, packetFormat);
    }

    public static final void asciiArmor(@NotNull OpenPGPCertificate $this$asciiArmor, @NotNull OutputStream outputStream, @NotNull PacketFormat format, @NotNull ArmoredOutputStream.Builder armorBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$asciiArmor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)armorBuilder, (String)"armorBuilder");
        String string = $this$asciiArmor.toAsciiArmoredString(format, armorBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toAsciiArmoredString(...)");
        outputStream.write(StringsKt.encodeToByteArray((String)string));
    }

    public static final void encode(@NotNull OpenPGPCertificate $this$encode, @NotNull OutputStream outputStream, @NotNull PacketFormat format) {
        Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        outputStream.write($this$encode.getEncoded(format));
    }

    public static /* synthetic */ void encode$default(OpenPGPCertificate openPGPCertificate, OutputStream outputStream, PacketFormat packetFormat, int n, Object object) {
        if ((n & 2) != 0) {
            packetFormat = PacketFormat.ROUNDTRIP;
        }
        OpenPGPCertificateExtensionsKt.encode(openPGPCertificate, outputStream, packetFormat);
    }
}

