/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.authentication;

import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.api.OpenPGPCertificate;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.authentication.CertificationChain;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\u0018\u00002\u00020\u0001B3\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bB1\u0012\u0006\u0010\u0002\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\r\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010$\u001a\u00020\u0010R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010 \u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lorg/pgpainless/authentication/CertificateAuthenticity;", "", "userId", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "certificationChains", "", "Lorg/pgpainless/authentication/CertificationChain;", "", "targetAmount", "(Ljava/lang/String;Lorg/bouncycastle/openpgp/PGPPublicKeyRing;Ljava/util/Map;I)V", "", "Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "(Ljava/lang/CharSequence;Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;Ljava/util/Map;I)V", "authenticated", "", "getAuthenticated", "()Z", "authenticityPercentage", "getAuthenticityPercentage", "()I", "getCertificate", "()Lorg/bouncycastle/openpgp/api/OpenPGPCertificate;", "getCertificationChains", "()Ljava/util/Map;", "pgpPublicKeyRing", "getPgpPublicKeyRing$annotations", "()V", "getPgpPublicKeyRing", "()Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "getTargetAmount", "totalTrustAmount", "getTotalTrustAmount", "getUserId", "()Ljava/lang/CharSequence;", "isAuthenticated", "pgpainless-core"})
public final class CertificateAuthenticity {
    @NotNull
    private final CharSequence userId;
    @NotNull
    private final OpenPGPCertificate certificate;
    @NotNull
    private final Map<CertificationChain, Integer> certificationChains;
    private final int targetAmount;
    @NotNull
    private final PGPPublicKeyRing pgpPublicKeyRing;

    public CertificateAuthenticity(@NotNull CharSequence userId, @NotNull OpenPGPCertificate certificate, @NotNull Map<CertificationChain, Integer> certificationChains, int targetAmount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter(certificationChains, (String)"certificationChains");
        this.userId = userId;
        this.certificate = certificate;
        this.certificationChains = certificationChains;
        this.targetAmount = targetAmount;
        PGPPublicKeyRing pGPPublicKeyRing = this.certificate.getPGPPublicKeyRing();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKeyRing, (String)"getPGPPublicKeyRing(...)");
        this.pgpPublicKeyRing = pGPPublicKeyRing;
    }

    @NotNull
    public final CharSequence getUserId() {
        return this.userId;
    }

    @NotNull
    public final OpenPGPCertificate getCertificate() {
        return this.certificate;
    }

    @NotNull
    public final Map<CertificationChain, Integer> getCertificationChains() {
        return this.certificationChains;
    }

    public final int getTargetAmount() {
        return this.targetAmount;
    }

    @Deprecated(message="Pass in an OpenPGPCertificate instead of a PGPPublicKeyRing.")
    public CertificateAuthenticity(@NotNull String userId, @NotNull PGPPublicKeyRing certificate, @NotNull Map<CertificationChain, Integer> certificationChains, int targetAmount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        Intrinsics.checkNotNullParameter(certificationChains, (String)"certificationChains");
        this((CharSequence)userId, PGPainless.Companion.getInstance().toCertificate(certificate), certificationChains, targetAmount);
    }

    @NotNull
    public final PGPPublicKeyRing getPgpPublicKeyRing() {
        return this.pgpPublicKeyRing;
    }

    @Deprecated(message="Use certificate instead.", replaceWith=@ReplaceWith(expression="certificate", imports={}))
    public static /* synthetic */ void getPgpPublicKeyRing$annotations() {
    }

    public final int getTotalTrustAmount() {
        return CollectionsKt.sumOfInt((Iterable)this.certificationChains.values());
    }

    public final int getAuthenticityPercentage() {
        return this.targetAmount * 100 / this.getTotalTrustAmount();
    }

    public final boolean getAuthenticated() {
        return this.targetAmount <= this.getTotalTrustAmount();
    }

    public final boolean isAuthenticated() {
        return this.getAuthenticated();
    }
}

