/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm.negotiation;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.api.MessageEncryptionMechanism;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.AEADAlgorithm;
import org.pgpainless.algorithm.AEADCipherMode;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.SymmetricKeyAlgorithmNegotiator;
import org.pgpainless.policy.Policy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fJV\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\t0\b2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\t0\bH&\u00a8\u0006\u0010\u00c0\u0006\u0003"}, d2={"Lorg/pgpainless/algorithm/negotiation/EncryptionMechanismNegotiator;", "", "negotiate", "Lorg/bouncycastle/openpgp/api/MessageEncryptionMechanism;", "policy", "Lorg/pgpainless/policy/Policy;", "override", "features", "", "", "Lorg/pgpainless/algorithm/Feature;", "aeadAlgorithmPreferences", "Lorg/pgpainless/algorithm/AEADCipherMode;", "symmetricAlgorithmPreferences", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "Companion", "pgpainless-core"})
public interface EncryptionMechanismNegotiator {
    @NotNull
    public static final Companion Companion = org.pgpainless.algorithm.negotiation.EncryptionMechanismNegotiator$Companion.$$INSTANCE;

    @NotNull
    public MessageEncryptionMechanism negotiate(@NotNull Policy var1, @Nullable MessageEncryptionMechanism var2, @NotNull List<? extends Set<? extends Feature>> var3, @NotNull List<? extends Set<AEADCipherMode>> var4, @NotNull List<? extends Set<? extends SymmetricKeyAlgorithm>> var5);

    @JvmStatic
    @NotNull
    public static EncryptionMechanismNegotiator modificationDetectionOrBetter(@NotNull SymmetricKeyAlgorithmNegotiator symmetricKeyAlgorithmNegotiator) {
        return Companion.modificationDetectionOrBetter(symmetricKeyAlgorithmNegotiator);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/algorithm/negotiation/EncryptionMechanismNegotiator$Companion;", "", "()V", "modificationDetectionOrBetter", "Lorg/pgpainless/algorithm/negotiation/EncryptionMechanismNegotiator;", "symmetricKeyAlgorithmNegotiator", "Lorg/pgpainless/algorithm/negotiation/SymmetricKeyAlgorithmNegotiator;", "pgpainless-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EncryptionMechanismNegotiator modificationDetectionOrBetter(@NotNull SymmetricKeyAlgorithmNegotiator symmetricKeyAlgorithmNegotiator) {
            Intrinsics.checkNotNullParameter((Object)symmetricKeyAlgorithmNegotiator, (String)"symmetricKeyAlgorithmNegotiator");
            return new EncryptionMechanismNegotiator(symmetricKeyAlgorithmNegotiator){
                final /* synthetic */ SymmetricKeyAlgorithmNegotiator $symmetricKeyAlgorithmNegotiator;
                {
                    this.$symmetricKeyAlgorithmNegotiator = $symmetricKeyAlgorithmNegotiator;
                }

                @NotNull
                public MessageEncryptionMechanism negotiate(@NotNull Policy policy, @Nullable MessageEncryptionMechanism override, @NotNull List<? extends Set<? extends Feature>> features, @NotNull List<? extends Set<AEADCipherMode>> aeadAlgorithmPreferences, @NotNull List<? extends Set<? extends SymmetricKeyAlgorithm>> symmetricAlgorithmPreferences) {
                    boolean bl;
                    block23: {
                        boolean bl2;
                        Set it;
                        boolean $i$f$all;
                        Iterable $this$all$iv;
                        block22: {
                            boolean bl3;
                            block21: {
                                Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
                                Intrinsics.checkNotNullParameter(features, (String)"features");
                                Intrinsics.checkNotNullParameter(aeadAlgorithmPreferences, (String)"aeadAlgorithmPreferences");
                                Intrinsics.checkNotNullParameter(symmetricAlgorithmPreferences, (String)"symmetricAlgorithmPreferences");
                                if (override != null) {
                                    return override;
                                }
                                $this$all$iv = features;
                                $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    bl3 = true;
                                } else {
                                    for (Object element$iv : $this$all$iv) {
                                        it = (Set)element$iv;
                                        boolean bl4 = false;
                                        if (it.contains((Object)((Object)Feature.MODIFICATION_DETECTION_2))) continue;
                                        bl3 = false;
                                        break block21;
                                    }
                                    bl3 = true;
                                }
                            }
                            if (bl3) {
                                Object v3;
                                Iterator<T> $this$filterTo$iv$iv;
                                AEADCipherMode $this$filter$iv;
                                Object element$iv;
                                Map counted = new LinkedHashMap<K, V>();
                                for (Set<AEADCipherMode> set : aeadAlgorithmPreferences) {
                                    for (AEADCipherMode mode : set) {
                                        counted.put(mode, ((Number)counted.getOrDefault(mode, 0)).intValue() + 1);
                                    }
                                }
                                element$iv = counted;
                                boolean $i$f$filter232 = false;
                                void bl4 = $this$filter$iv;
                                Map destination$iv$iv = new LinkedHashMap<K, V>();
                                boolean $i$f$filterTo = false;
                                Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    Map.Entry<K, V> element$iv$iv;
                                    Map.Entry<K, V> it2 = element$iv$iv = iterator.next();
                                    boolean bl5 = false;
                                    Policy.MessageEncryptionMechanismPolicy messageEncryptionMechanismPolicy = policy.getMessageEncryptionAlgorithmPolicy();
                                    MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.aead((int)((AEADCipherMode)it2.getKey()).getCiphermode().getAlgorithmId(), (int)((AEADCipherMode)it2.getKey()).getAeadAlgorithm().getAlgorithmId());
                                    Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"aead(...)");
                                    if (!messageEncryptionMechanismPolicy.isAcceptable(messageEncryptionMechanism)) continue;
                                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                }
                                Iterable $i$f$filter232 = destination$iv$iv.entrySet();
                                $this$filterTo$iv$iv = $i$f$filter232.iterator();
                                if (!$this$filterTo$iv$iv.hasNext()) {
                                    v3 = null;
                                } else {
                                    T t = $this$filterTo$iv$iv.next();
                                    if (!$this$filterTo$iv$iv.hasNext()) {
                                        v3 = t;
                                    } else {
                                        Map.Entry it3 = (Map.Entry)t;
                                        boolean bl6 = false;
                                        int n = ((Number)it3.getValue()).intValue();
                                        do {
                                            T t2 = $this$filterTo$iv$iv.next();
                                            Map.Entry it4 = (Map.Entry)t2;
                                            boolean bl5 = false;
                                            int n2 = ((Number)it4.getValue()).intValue();
                                            if (n >= n2) continue;
                                            t = t2;
                                            n = n2;
                                        } while ($this$filterTo$iv$iv.hasNext());
                                        v3 = t;
                                    }
                                }
                                Map.Entry entry = v3;
                                AEADCipherMode bestSupportedMode = entry != null && ($this$filter$iv = (AEADCipherMode)entry.getKey()) != null ? $this$filter$iv : new AEADCipherMode(AEADAlgorithm.OCB, SymmetricKeyAlgorithm.AES_128);
                                MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.aead((int)bestSupportedMode.getCiphermode().getAlgorithmId(), (int)bestSupportedMode.getAeadAlgorithm().getAlgorithmId());
                                Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"aead(...)");
                                return messageEncryptionMechanism;
                            }
                            $this$all$iv = features;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    it = (Set)element$iv;
                                    boolean bl7 = false;
                                    if (it.contains((Object)((Object)Feature.LIBREPGP_OCB_ENCRYPTED_DATA))) continue;
                                    bl2 = false;
                                    break block22;
                                }
                                bl2 = true;
                            }
                        }
                        if (bl2) {
                            MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.librePgp((int)this.$symmetricKeyAlgorithmNegotiator.negotiate(policy.getMessageEncryptionAlgorithmPolicy().getSymmetricAlgorithmPolicy(), null, symmetricAlgorithmPreferences).getAlgorithmId());
                            Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"librePgp(...)");
                            return messageEncryptionMechanism;
                        }
                        $this$all$iv = features;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                it = (Set)element$iv;
                                boolean bl8 = false;
                                if (it.contains((Object)((Object)Feature.MODIFICATION_DETECTION))) continue;
                                bl = false;
                                break block23;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        MessageEncryptionMechanism messageEncryptionMechanism = MessageEncryptionMechanism.integrityProtected((int)this.$symmetricKeyAlgorithmNegotiator.negotiate(policy.getMessageEncryptionAlgorithmPolicy().getSymmetricAlgorithmPolicy(), null, symmetricAlgorithmPreferences).getAlgorithmId());
                        Intrinsics.checkNotNullExpressionValue((Object)messageEncryptionMechanism, (String)"integrityProtected(...)");
                        return messageEncryptionMechanism;
                    }
                    return policy.getMessageEncryptionAlgorithmPolicy().getAsymmetricFallbackMechanism();
                }
            };
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

