/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Date;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.RevocationStateType;
import org.pgpainless.util.DateUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0011J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/algorithm/RevocationState;", "", "type", "Lorg/pgpainless/algorithm/RevocationStateType;", "(Lorg/pgpainless/algorithm/RevocationStateType;)V", "_date", "Ljava/util/Date;", "(Lorg/pgpainless/algorithm/RevocationStateType;Ljava/util/Date;)V", "date", "getDate", "()Ljava/util/Date;", "getType", "()Lorg/pgpainless/algorithm/RevocationStateType;", "compareTo", "", "other", "equals", "", "", "hashCode", "isHardRevocation", "isNotRevoked", "isSoftRevocation", "toString", "", "Companion", "pgpainless-core"})
public final class RevocationState
implements Comparable<RevocationState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RevocationStateType type;
    @Nullable
    private final Date _date;

    private RevocationState(RevocationStateType type, Date _date) {
        this.type = type;
        this._date = _date;
    }

    @NotNull
    public final RevocationStateType getType() {
        return this.type;
    }

    @NotNull
    public final Date getDate() {
        if (!this.isSoftRevocation()) {
            throw new NoSuchElementException("RevocationStateType is not equal to 'softRevoked'. Cannot extract date.");
        }
        Date date = this._date;
        Intrinsics.checkNotNull((Object)date);
        return date;
    }

    private RevocationState(RevocationStateType type) {
        this(type, (Date)null);
    }

    public final boolean isSoftRevocation() {
        return this.type == RevocationStateType.softRevoked;
    }

    public final boolean isHardRevocation() {
        return this.type == RevocationStateType.hardRevoked;
    }

    public final boolean isNotRevoked() {
        return this.type == RevocationStateType.notRevoked;
    }

    @Override
    public int compareTo(@NotNull RevocationState other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                if (other.isNotRevoked()) {
                    n = 0;
                    break;
                }
                n = -1;
                break;
            }
            case 2: {
                if (other.isNotRevoked()) {
                    n = 1;
                    break;
                }
                if (other.isSoftRevocation()) {
                    n = other.getDate().compareTo(this.getDate());
                    break;
                }
                n = -1;
                break;
            }
            case 3: {
                if (other.isHardRevocation()) {
                    n = 0;
                    break;
                }
                n = 1;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type: " + this.type));
            }
        }
        return n;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append((Object)this.type);
        if (this.isSoftRevocation()) {
            $this$toString_u24lambda_u240.append(" (" + DateUtil.Companion.formatUTCDate(this.getDate()) + ")");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public int hashCode() {
        return this.type.hashCode() * 31 + (this.isSoftRevocation() ? this.getDate().hashCode() : 0);
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RevocationState)) {
            return false;
        }
        if (this.type != ((RevocationState)other).type) {
            return false;
        }
        if (this.isSoftRevocation()) {
            return DateUtil.Companion.toSecondsPrecision(this.getDate()).getTime() == DateUtil.Companion.toSecondsPrecision(((RevocationState)other).getDate()).getTime();
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final RevocationState notRevoked() {
        return Companion.notRevoked();
    }

    @JvmStatic
    @NotNull
    public static final RevocationState softRevoked(@NotNull Date date) {
        return Companion.softRevoked(date);
    }

    @JvmStatic
    @NotNull
    public static final RevocationState hardRevoked() {
        return Companion.hardRevoked();
    }

    public /* synthetic */ RevocationState(RevocationStateType type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    public /* synthetic */ RevocationState(RevocationStateType type, Date _date, DefaultConstructorMarker $constructor_marker) {
        this(type, _date);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/pgpainless/algorithm/RevocationState$Companion;", "", "()V", "hardRevoked", "Lorg/pgpainless/algorithm/RevocationState;", "notRevoked", "softRevoked", "date", "Ljava/util/Date;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RevocationState notRevoked() {
            return new RevocationState(RevocationStateType.notRevoked, null);
        }

        @JvmStatic
        @NotNull
        public final RevocationState softRevoked(@NotNull Date date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new RevocationState(RevocationStateType.softRevoked, date, null);
        }

        @JvmStatic
        @NotNull
        public final RevocationState hardRevoked() {
            return new RevocationState(RevocationStateType.hardRevoked, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RevocationStateType.values().length];
            try {
                nArray[RevocationStateType.notRevoked.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RevocationStateType.softRevoked.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RevocationStateType.hardRevoked.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

