/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.AEADAlgorithm;
import org.pgpainless.algorithm.AEADCipherMode;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019BW\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0003\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rBW\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000e\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000e\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0016\u001a\u00020\u0017R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/pgpainless/algorithm/AlgorithmSuite;", "", "symmetricKeyAlgorithms", "", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "hashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "compressionAlgorithms", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "aeadAlgorithms", "Lorg/pgpainless/algorithm/AEADCipherMode;", "features", "Lorg/pgpainless/algorithm/Feature;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getAeadAlgorithms", "()Ljava/util/Set;", "getCompressionAlgorithms", "getFeatures", "getHashAlgorithms", "getSymmetricKeyAlgorithms", "modify", "Lorg/pgpainless/algorithm/AlgorithmSuite$Builder;", "Builder", "Companion", "pgpainless-core"})
public final class AlgorithmSuite {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Set<SymmetricKeyAlgorithm> symmetricKeyAlgorithms;
    @Nullable
    private final Set<HashAlgorithm> hashAlgorithms;
    @Nullable
    private final Set<CompressionAlgorithm> compressionAlgorithms;
    @Nullable
    private final Set<AEADCipherMode> aeadAlgorithms;
    @Nullable
    private final Set<Feature> features;
    @NotNull
    private static final List<SymmetricKeyAlgorithm> defaultSymmetricKeyAlgorithms;
    @NotNull
    private static final List<HashAlgorithm> defaultHashAlgorithms;
    @NotNull
    private static final List<CompressionAlgorithm> defaultCompressionAlgorithms;
    @NotNull
    private static final List<AEADCipherMode> defaultAEADAlgorithmSuites;
    @NotNull
    private static final List<Feature> defaultFeatures;
    @NotNull
    private static final AlgorithmSuite defaultAlgorithmSuite;

    private AlgorithmSuite(Set<? extends SymmetricKeyAlgorithm> symmetricKeyAlgorithms, Set<? extends HashAlgorithm> hashAlgorithms, Set<? extends CompressionAlgorithm> compressionAlgorithms2, Set<AEADCipherMode> aeadAlgorithms, Set<? extends Feature> features) {
        this.symmetricKeyAlgorithms = symmetricKeyAlgorithms;
        this.hashAlgorithms = hashAlgorithms;
        this.compressionAlgorithms = compressionAlgorithms2;
        this.aeadAlgorithms = aeadAlgorithms;
        this.features = features;
    }

    @Nullable
    public final Set<SymmetricKeyAlgorithm> getSymmetricKeyAlgorithms() {
        return this.symmetricKeyAlgorithms;
    }

    @Nullable
    public final Set<HashAlgorithm> getHashAlgorithms() {
        return this.hashAlgorithms;
    }

    @Nullable
    public final Set<CompressionAlgorithm> getCompressionAlgorithms() {
        return this.compressionAlgorithms;
    }

    @Nullable
    public final Set<AEADCipherMode> getAeadAlgorithms() {
        return this.aeadAlgorithms;
    }

    @Nullable
    public final Set<Feature> getFeatures() {
        return this.features;
    }

    public AlgorithmSuite(@Nullable List<? extends SymmetricKeyAlgorithm> symmetricKeyAlgorithms, @Nullable List<? extends HashAlgorithm> hashAlgorithms, @Nullable List<? extends CompressionAlgorithm> compressionAlgorithms2, @Nullable List<AEADCipherMode> aeadAlgorithms, @Nullable List<? extends Feature> features) {
        List<? extends SymmetricKeyAlgorithm> list = symmetricKeyAlgorithms;
        List<? extends HashAlgorithm> list2 = hashAlgorithms;
        List<? extends CompressionAlgorithm> list3 = compressionAlgorithms2;
        List<AEADCipherMode> list4 = aeadAlgorithms;
        List<? extends Feature> list5 = features;
        this(list != null ? CollectionsKt.toSet((Iterable)list) : null, list2 != null ? CollectionsKt.toSet((Iterable)list2) : null, list3 != null ? CollectionsKt.toSet((Iterable)list3) : null, list4 != null ? CollectionsKt.toSet((Iterable)list4) : null, list5 != null ? CollectionsKt.toSet((Iterable)list5) : null);
    }

    @NotNull
    public final Builder modify() {
        return new Builder(this);
    }

    @JvmStatic
    @NotNull
    public static final Builder emptyBuilder() {
        return Companion.emptyBuilder();
    }

    @NotNull
    public static final List<SymmetricKeyAlgorithm> getDefaultSymmetricKeyAlgorithms() {
        return Companion.getDefaultSymmetricKeyAlgorithms();
    }

    @NotNull
    public static final List<HashAlgorithm> getDefaultHashAlgorithms() {
        return Companion.getDefaultHashAlgorithms();
    }

    @NotNull
    public static final List<CompressionAlgorithm> getDefaultCompressionAlgorithms() {
        return Companion.getDefaultCompressionAlgorithms();
    }

    @NotNull
    public static final List<AEADCipherMode> getDefaultAEADAlgorithmSuites() {
        return Companion.getDefaultAEADAlgorithmSuites();
    }

    @NotNull
    public static final List<Feature> getDefaultFeatures() {
        return Companion.getDefaultFeatures();
    }

    @NotNull
    public static final AlgorithmSuite getDefaultAlgorithmSuite() {
        return Companion.getDefaultAlgorithmSuite();
    }

    public /* synthetic */ AlgorithmSuite(Set symmetricKeyAlgorithms, Set hashAlgorithms, Set compressionAlgorithms2, Set aeadAlgorithms, Set features, DefaultConstructorMarker $constructor_marker) {
        this(symmetricKeyAlgorithms, hashAlgorithms, compressionAlgorithms2, aeadAlgorithms, features);
    }

    static {
        Object[] objectArray = new SymmetricKeyAlgorithm[]{SymmetricKeyAlgorithm.AES_256, SymmetricKeyAlgorithm.AES_192, SymmetricKeyAlgorithm.AES_128};
        defaultSymmetricKeyAlgorithms = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new HashAlgorithm[]{HashAlgorithm.SHA512, HashAlgorithm.SHA384, HashAlgorithm.SHA256, HashAlgorithm.SHA224};
        defaultHashAlgorithms = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new CompressionAlgorithm[]{CompressionAlgorithm.ZLIB, CompressionAlgorithm.BZIP2, CompressionAlgorithm.ZIP, CompressionAlgorithm.UNCOMPRESSED};
        defaultCompressionAlgorithms = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new AEADCipherMode[]{new AEADCipherMode(AEADAlgorithm.EAX, SymmetricKeyAlgorithm.AES_256), new AEADCipherMode(AEADAlgorithm.OCB, SymmetricKeyAlgorithm.AES_256), new AEADCipherMode(AEADAlgorithm.GCM, SymmetricKeyAlgorithm.AES_256), new AEADCipherMode(AEADAlgorithm.EAX, SymmetricKeyAlgorithm.AES_192), new AEADCipherMode(AEADAlgorithm.EAX, SymmetricKeyAlgorithm.AES_192)};
        defaultAEADAlgorithmSuites = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Feature[]{Feature.MODIFICATION_DETECTION, Feature.MODIFICATION_DETECTION_2};
        defaultFeatures = CollectionsKt.listOf((Object[])objectArray);
        defaultAlgorithmSuite = new AlgorithmSuite(defaultSymmetricKeyAlgorithms, defaultHashAlgorithms, defaultCompressionAlgorithms, defaultAEADAlgorithmSuites, defaultFeatures);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0003J\u001f\u0010\u0011\u001a\u00020\u00002\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0012\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0011\u001a\u00020\u00002\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0014J\u001f\u0010\u0015\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0012\"\u00020\t\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0015\u001a\u00020\u00002\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0014J\u001f\u0010\u0017\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0012\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0017\u001a\u00020\u00002\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0014J\u001f\u0010\u0019\u001a\u00020\u00002\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0012\"\u00020\r\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u0019\u001a\u00020\u00002\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0014J\u001f\u0010\u001b\u001a\u00020\u00002\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0012\"\u00020\u000f\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001b\u001a\u00020\u00002\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0014R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/algorithm/AlgorithmSuite$Builder;", "", "suite", "Lorg/pgpainless/algorithm/AlgorithmSuite;", "(Lorg/pgpainless/algorithm/AlgorithmSuite;)V", "aeadAlgorithms", "", "Lorg/pgpainless/algorithm/AEADCipherMode;", "compressionAlgorithms", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "features", "Lorg/pgpainless/algorithm/Feature;", "hashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "symmetricKeyAlgorithms", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "build", "overrideAeadAlgorithms", "", "([Lorg/pgpainless/algorithm/AEADCipherMode;)Lorg/pgpainless/algorithm/AlgorithmSuite$Builder;", "", "overrideCompressionAlgorithms", "([Lorg/pgpainless/algorithm/CompressionAlgorithm;)Lorg/pgpainless/algorithm/AlgorithmSuite$Builder;", "overrideFeatures", "([Lorg/pgpainless/algorithm/Feature;)Lorg/pgpainless/algorithm/AlgorithmSuite$Builder;", "overrideHashAlgorithms", "([Lorg/pgpainless/algorithm/HashAlgorithm;)Lorg/pgpainless/algorithm/AlgorithmSuite$Builder;", "overrideSymmetricKeyAlgorithms", "([Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;)Lorg/pgpainless/algorithm/AlgorithmSuite$Builder;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nAlgorithmSuite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlgorithmSuite.kt\norg/pgpainless/algorithm/AlgorithmSuite$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
    public static final class Builder {
        @Nullable
        private Set<? extends SymmetricKeyAlgorithm> symmetricKeyAlgorithms;
        @Nullable
        private Set<? extends HashAlgorithm> hashAlgorithms;
        @Nullable
        private Set<? extends CompressionAlgorithm> compressionAlgorithms;
        @Nullable
        private Set<AEADCipherMode> aeadAlgorithms;
        @Nullable
        private Set<? extends Feature> features;

        public Builder(@Nullable AlgorithmSuite suite) {
            AlgorithmSuite algorithmSuite = suite;
            this.symmetricKeyAlgorithms = algorithmSuite != null ? algorithmSuite.getSymmetricKeyAlgorithms() : null;
            AlgorithmSuite algorithmSuite2 = suite;
            this.hashAlgorithms = algorithmSuite2 != null ? algorithmSuite2.getHashAlgorithms() : null;
            AlgorithmSuite algorithmSuite3 = suite;
            this.compressionAlgorithms = algorithmSuite3 != null ? algorithmSuite3.getCompressionAlgorithms() : null;
            AlgorithmSuite algorithmSuite4 = suite;
            this.aeadAlgorithms = algorithmSuite4 != null ? algorithmSuite4.getAeadAlgorithms() : null;
            AlgorithmSuite algorithmSuite5 = suite;
            this.features = algorithmSuite5 != null ? algorithmSuite5.getFeatures() : null;
        }

        public /* synthetic */ Builder(AlgorithmSuite algorithmSuite, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                algorithmSuite = null;
            }
            this(algorithmSuite);
        }

        @NotNull
        public final Builder overrideSymmetricKeyAlgorithms(SymmetricKeyAlgorithm ... symmetricKeyAlgorithms) {
            Intrinsics.checkNotNullParameter((Object)symmetricKeyAlgorithms, (String)"symmetricKeyAlgorithms");
            return this.overrideSymmetricKeyAlgorithms(ArraysKt.toSet((Object[])symmetricKeyAlgorithms));
        }

        @NotNull
        public final Builder overrideSymmetricKeyAlgorithms(@Nullable Collection<? extends SymmetricKeyAlgorithm> symmetricKeyAlgorithms) {
            Builder builder;
            Builder $this$overrideSymmetricKeyAlgorithms_u24lambda_u240 = builder = this;
            boolean bl = false;
            Collection<? extends SymmetricKeyAlgorithm> collection = symmetricKeyAlgorithms;
            $this$overrideSymmetricKeyAlgorithms_u24lambda_u240.symmetricKeyAlgorithms = collection != null ? CollectionsKt.toSet((Iterable)collection) : null;
            return builder;
        }

        @NotNull
        public final Builder overrideHashAlgorithms(HashAlgorithm ... hashAlgorithms) {
            Intrinsics.checkNotNullParameter((Object)hashAlgorithms, (String)"hashAlgorithms");
            return this.overrideHashAlgorithms(ArraysKt.toSet((Object[])hashAlgorithms));
        }

        @NotNull
        public final Builder overrideHashAlgorithms(@Nullable Collection<? extends HashAlgorithm> hashAlgorithms) {
            Builder builder;
            Builder $this$overrideHashAlgorithms_u24lambda_u241 = builder = this;
            boolean bl = false;
            Collection<? extends HashAlgorithm> collection = hashAlgorithms;
            $this$overrideHashAlgorithms_u24lambda_u241.hashAlgorithms = collection != null ? CollectionsKt.toSet((Iterable)collection) : null;
            return builder;
        }

        @NotNull
        public final Builder overrideCompressionAlgorithms(CompressionAlgorithm ... compressionAlgorithms2) {
            Intrinsics.checkNotNullParameter((Object)compressionAlgorithms2, (String)"compressionAlgorithms");
            return this.overrideCompressionAlgorithms(ArraysKt.toSet((Object[])compressionAlgorithms2));
        }

        @NotNull
        public final Builder overrideCompressionAlgorithms(@Nullable Collection<? extends CompressionAlgorithm> compressionAlgorithms2) {
            Builder builder;
            Builder $this$overrideCompressionAlgorithms_u24lambda_u242 = builder = this;
            boolean bl = false;
            Collection<? extends CompressionAlgorithm> collection = compressionAlgorithms2;
            $this$overrideCompressionAlgorithms_u24lambda_u242.compressionAlgorithms = collection != null ? CollectionsKt.toSet((Iterable)collection) : null;
            return builder;
        }

        @NotNull
        public final Builder overrideAeadAlgorithms(AEADCipherMode ... aeadAlgorithms) {
            Intrinsics.checkNotNullParameter((Object)aeadAlgorithms, (String)"aeadAlgorithms");
            return this.overrideAeadAlgorithms(ArraysKt.toSet((Object[])aeadAlgorithms));
        }

        @NotNull
        public final Builder overrideAeadAlgorithms(@Nullable Collection<AEADCipherMode> aeadAlgorithms) {
            Builder builder;
            Builder $this$overrideAeadAlgorithms_u24lambda_u243 = builder = this;
            boolean bl = false;
            Collection<AEADCipherMode> collection = aeadAlgorithms;
            $this$overrideAeadAlgorithms_u24lambda_u243.aeadAlgorithms = collection != null ? CollectionsKt.toSet((Iterable)collection) : null;
            return builder;
        }

        @NotNull
        public final Builder overrideFeatures(Feature ... features) {
            Intrinsics.checkNotNullParameter((Object)features, (String)"features");
            return this.overrideFeatures(ArraysKt.toSet((Object[])features));
        }

        @NotNull
        public final Builder overrideFeatures(@Nullable Collection<? extends Feature> features) {
            Builder builder;
            Builder $this$overrideFeatures_u24lambda_u244 = builder = this;
            boolean bl = false;
            Collection<? extends Feature> collection = features;
            $this$overrideFeatures_u24lambda_u244.features = collection != null ? CollectionsKt.toSet((Iterable)collection) : null;
            return builder;
        }

        @NotNull
        public final AlgorithmSuite build() {
            return new AlgorithmSuite(this.symmetricKeyAlgorithms, this.hashAlgorithms, this.compressionAlgorithms, this.aeadAlgorithms, this.features, null);
        }

        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\bR\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\bR\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\bR\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\b\u00a8\u0006 "}, d2={"Lorg/pgpainless/algorithm/AlgorithmSuite$Companion;", "", "()V", "defaultAEADAlgorithmSuites", "", "Lorg/pgpainless/algorithm/AEADCipherMode;", "getDefaultAEADAlgorithmSuites$annotations", "getDefaultAEADAlgorithmSuites", "()Ljava/util/List;", "defaultAlgorithmSuite", "Lorg/pgpainless/algorithm/AlgorithmSuite;", "getDefaultAlgorithmSuite$annotations", "getDefaultAlgorithmSuite", "()Lorg/pgpainless/algorithm/AlgorithmSuite;", "defaultCompressionAlgorithms", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "getDefaultCompressionAlgorithms$annotations", "getDefaultCompressionAlgorithms", "defaultFeatures", "Lorg/pgpainless/algorithm/Feature;", "getDefaultFeatures$annotations", "getDefaultFeatures", "defaultHashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "getDefaultHashAlgorithms$annotations", "getDefaultHashAlgorithms", "defaultSymmetricKeyAlgorithms", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getDefaultSymmetricKeyAlgorithms$annotations", "getDefaultSymmetricKeyAlgorithms", "emptyBuilder", "Lorg/pgpainless/algorithm/AlgorithmSuite$Builder;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder emptyBuilder() {
            return new Builder(null, 1, null);
        }

        @NotNull
        public final List<SymmetricKeyAlgorithm> getDefaultSymmetricKeyAlgorithms() {
            return defaultSymmetricKeyAlgorithms;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultSymmetricKeyAlgorithms$annotations() {
        }

        @NotNull
        public final List<HashAlgorithm> getDefaultHashAlgorithms() {
            return defaultHashAlgorithms;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultHashAlgorithms$annotations() {
        }

        @NotNull
        public final List<CompressionAlgorithm> getDefaultCompressionAlgorithms() {
            return defaultCompressionAlgorithms;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultCompressionAlgorithms$annotations() {
        }

        @NotNull
        public final List<AEADCipherMode> getDefaultAEADAlgorithmSuites() {
            return defaultAEADAlgorithmSuites;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultAEADAlgorithmSuites$annotations() {
        }

        @NotNull
        public final List<Feature> getDefaultFeatures() {
            return defaultFeatures;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultFeatures$annotations() {
        }

        @NotNull
        public final AlgorithmSuite getDefaultAlgorithmSuite() {
            return defaultAlgorithmSuite;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultAlgorithmSuite$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

