/*
 * Decompiled with CFR 0.152.
 */
package org.gnupg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.api.OpenPGPKey;
import org.gnupg.GnuPGDummyExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.key.SubkeyIdentifier;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lorg/gnupg/GnuPGDummyKeyUtil;", "", "()V", "Builder", "Companion", "KeyFilter", "pgpainless-core"})
public final class GnuPGDummyKeyUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private GnuPGDummyKeyUtil() {
    }

    @JvmStatic
    @NotNull
    public static final Set<SubkeyIdentifier> getIdsOfKeysWithGnuPGS2KDivertedToCard(@NotNull PGPSecretKeyRing secretKeys) {
        return Companion.getIdsOfKeysWithGnuPGS2KDivertedToCard(secretKeys);
    }

    @JvmStatic
    @NotNull
    public static final Builder modify(@NotNull OpenPGPKey key) {
        return Companion.modify(key);
    }

    @JvmStatic
    @NotNull
    public static final Builder modify(@NotNull PGPSecretKeyRing secretKeys) {
        return Companion.modify(secretKeys);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gnupg/GnuPGDummyKeyUtil$Builder;", "", "keys", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "(Lorg/bouncycastle/openpgp/PGPSecretKeyRing;)V", "divertPrivateKeysToCard", "filter", "Lorg/gnupg/GnuPGDummyKeyUtil$KeyFilter;", "cardSerialNumber", "", "encodeSerial", "serial", "extensionToS2K", "Lorg/bouncycastle/bcpg/S2K;", "extension", "Lorg/gnupg/GnuPGDummyExtension;", "removePrivateKeys", "replacePrivateKeys", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nGnuPGDummyKeyUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GnuPGDummyKeyUtil.kt\norg/gnupg/GnuPGDummyKeyUtil$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1#2:208\n1549#3:209\n1620#3,3:210\n*S KotlinDebug\n*F\n+ 1 GnuPGDummyKeyUtil.kt\norg/gnupg/GnuPGDummyKeyUtil$Builder\n*L\n117#1:209\n117#1:210,3\n*E\n"})
    public static final class Builder {
        @NotNull
        private final PGPSecretKeyRing keys;

        public Builder(@NotNull PGPSecretKeyRing keys) {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            this.keys = keys;
        }

        @NotNull
        public final PGPSecretKeyRing removePrivateKeys(@NotNull KeyFilter filter) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            return this.replacePrivateKeys(GnuPGDummyExtension.NO_PRIVATE_KEY, null, filter);
        }

        @NotNull
        public final PGPSecretKeyRing divertPrivateKeysToCard(@NotNull KeyFilter filter) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            return this.divertPrivateKeysToCard(filter, new byte[16]);
        }

        @NotNull
        public final PGPSecretKeyRing divertPrivateKeysToCard(@NotNull KeyFilter filter, @Nullable byte[] cardSerialNumber) {
            Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
            if (!(cardSerialNumber == null || cardSerialNumber.length <= 16)) {
                boolean bl = false;
                String string = "Card serial number length cannot exceed 16 bytes.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.replacePrivateKeys(GnuPGDummyExtension.DIVERT_TO_CARD, cardSerialNumber, filter);
        }

        /*
         * WARNING - void declaration
         */
        private final PGPSecretKeyRing replacePrivateKeys(GnuPGDummyExtension extension, byte[] serial, KeyFilter filter) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            byte[] byArray;
            Object it;
            if (serial != null) {
                it = serial;
                boolean bl = false;
                byArray = this.encodeSerial((byte[])it);
            } else {
                byArray = null;
            }
            byte[] encodedSerial = byArray;
            S2K s2k = this.extensionToS2K(extension);
            it = (Iterable)this.keys;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PGPSecretKey pGPSecretKey;
                void it2;
                PGPSecretKey pGPSecretKey2 = (PGPSecretKey)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KeyIdentifier keyIdentifier = it2.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)keyIdentifier, (String)"getKeyIdentifier(...)");
                if (!filter.filter(keyIdentifier)) {
                    pGPSecretKey = it2;
                } else {
                    PublicKeyPacket publicKeyPacket = it2.getPublicKey().getPublicKeyPacket();
                    SecretKeyPacket keyPacket = it2.isMasterKey() ? new SecretKeyPacket(publicKeyPacket, 0, 254, s2k, null, encodedSerial) : (SecretKeyPacket)new SecretSubkeyPacket(publicKeyPacket, 0, 254, s2k, null, encodedSerial);
                    pGPSecretKey = new PGPSecretKey(keyPacket, it2.getPublicKey());
                }
                collection.add(pGPSecretKey);
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            return new PGPSecretKeyRing(list);
        }

        private final byte[] encodeSerial(byte[] serial) {
            byte[] encoded = new byte[serial.length + 1];
            encoded[0] = (byte)((byte)serial.length & 0xFFFFFFFF);
            System.arraycopy(serial, 0, encoded, 1, serial.length);
            return encoded;
        }

        private final S2K extensionToS2K(GnuPGDummyExtension extension) {
            S2K s2K = S2K.gnuDummyS2K((S2K.GNUDummyParams)(extension == GnuPGDummyExtension.DIVERT_TO_CARD ? S2K.GNUDummyParams.divertToCard() : S2K.GNUDummyParams.noPrivateKey()));
            Intrinsics.checkNotNullExpressionValue((Object)s2K, (String)"gnuDummyS2K(...)");
            return s2K;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/gnupg/GnuPGDummyKeyUtil$Companion;", "", "()V", "getIdsOfKeysWithGnuPGS2KDivertedToCard", "", "Lorg/pgpainless/key/SubkeyIdentifier;", "secretKeys", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "modify", "Lorg/gnupg/GnuPGDummyKeyUtil$Builder;", "key", "Lorg/bouncycastle/openpgp/api/OpenPGPKey;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nGnuPGDummyKeyUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GnuPGDummyKeyUtil.kt\norg/gnupg/GnuPGDummyKeyUtil$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n766#2:208\n857#2,2:209\n1549#2:211\n1620#2,3:212\n*S KotlinDebug\n*F\n+ 1 GnuPGDummyKeyUtil.kt\norg/gnupg/GnuPGDummyKeyUtil$Companion\n*L\n43#1:208\n43#1:209,2\n47#1:211\n47#1:212,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @NotNull
        public final Set<SubkeyIdentifier> getIdsOfKeysWithGnuPGS2KDivertedToCard(@NotNull PGPSecretKeyRing secretKeys) {
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            $this$filter$iv = (Iterable)secretKeys;
            $i$f$filter = false;
            var4_4 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (PGPSecretKey)element$iv$iv;
                $i$a$-filter-GnuPGDummyKeyUtil$Companion$getIdsOfKeysWithGnuPGS2KDivertedToCard$1 = false;
                v0 = it.getS2K();
                v1 = v0 != null ? v0.getType() == 101 : false;
                if (!v1) ** GOTO lbl-1000
                v2 = it.getS2K();
                v3 = v2 != null ? v2.getProtectionMode() == 2 : false;
                if (v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (PGPSecretKey)item$iv$iv;
                var11_11 = destination$iv$iv;
                $i$a$-map-GnuPGDummyKeyUtil$Companion$getIdsOfKeysWithGnuPGS2KDivertedToCard$2 = false;
                v5 = (PGPKeyRing)secretKeys;
                v6 = it.getKeyIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getKeyIdentifier(...)");
                var11_11.add(new SubkeyIdentifier(v5, v6));
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        @JvmStatic
        @NotNull
        public final Builder modify(@NotNull OpenPGPKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            PGPSecretKeyRing pGPSecretKeyRing = key.getPGPSecretKeyRing();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSecretKeyRing, (String)"getPGPSecretKeyRing(...)");
            return this.modify(pGPSecretKeyRing);
        }

        @JvmStatic
        @NotNull
        public final Builder modify(@NotNull PGPSecretKeyRing secretKeys) {
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            return new Builder(secretKeys);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lorg/gnupg/GnuPGDummyKeyUtil$KeyFilter;", "", "filter", "", "keyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "Companion", "pgpainless-core"})
    public static interface KeyFilter {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean filter(@NotNull KeyIdentifier var1);

        @JvmStatic
        @NotNull
        public static KeyFilter any() {
            return Companion.any();
        }

        @JvmStatic
        @Deprecated(message="Use only(KeyIdentifier) instead.")
        @NotNull
        public static KeyFilter only(long onlyKeyId) {
            return Companion.only(onlyKeyId);
        }

        @JvmStatic
        @NotNull
        public static KeyFilter only(@NotNull KeyIdentifier onlyKeyIdentifier) {
            return Companion.only(onlyKeyIdentifier);
        }

        @JvmStatic
        @NotNull
        public static KeyFilter selected(@NotNull Collection<? extends KeyIdentifier> ids) {
            return Companion.selected(ids);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0007\u00a8\u0006\r"}, d2={"Lorg/gnupg/GnuPGDummyKeyUtil$KeyFilter$Companion;", "", "()V", "any", "Lorg/gnupg/GnuPGDummyKeyUtil$KeyFilter;", "only", "onlyKeyId", "", "onlyKeyIdentifier", "Lorg/bouncycastle/bcpg/KeyIdentifier;", "selected", "ids", "", "pgpainless-core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final KeyFilter any() {
                return Companion::any$lambda$0;
            }

            @JvmStatic
            @Deprecated(message="Use only(KeyIdentifier) instead.")
            @NotNull
            public final KeyFilter only(long onlyKeyId) {
                return this.only(new KeyIdentifier(onlyKeyId));
            }

            @JvmStatic
            @NotNull
            public final KeyFilter only(@NotNull KeyIdentifier onlyKeyIdentifier) {
                Intrinsics.checkNotNullParameter((Object)onlyKeyIdentifier, (String)"onlyKeyIdentifier");
                return arg_0 -> Companion.only$lambda$1(onlyKeyIdentifier, arg_0);
            }

            @JvmStatic
            @NotNull
            public final KeyFilter selected(@NotNull Collection<? extends KeyIdentifier> ids) {
                Intrinsics.checkNotNullParameter(ids, (String)"ids");
                return arg_0 -> Companion.selected$lambda$2(ids, arg_0);
            }

            private static final boolean any$lambda$0(KeyIdentifier it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return true;
            }

            private static final boolean only$lambda$1(KeyIdentifier $onlyKeyIdentifier, KeyIdentifier it) {
                Intrinsics.checkNotNullParameter((Object)$onlyKeyIdentifier, (String)"$onlyKeyIdentifier");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.matchesExplicit($onlyKeyIdentifier);
            }

            private static final boolean selected$lambda$2(Collection $ids, KeyIdentifier it) {
                Intrinsics.checkNotNullParameter((Object)$ids, (String)"$ids");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return $ids.contains(it);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

