/*
 * Decompiled with CFR 0.152.
 */
package openpgp;

import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.text.Regex;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0001\u00a8\u0006\u0006"}, d2={"fromOpenPgpKeyId", "", "Lkotlin/Long$Companion;", "hexKeyId", "", "openPgpKeyId", "pgpainless-core"})
public final class LongExtensionsKt {
    @NotNull
    public static final String openPgpKeyId(long $this$openPgpKeyId) {
        String string = "%016X";
        Object[] objectArray = new Object[]{$this$openPgpKeyId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        return string3;
    }

    public static final long fromOpenPgpKeyId(@NotNull LongCompanionObject $this$fromOpenPgpKeyId, @NotNull String hexKeyId) {
        Intrinsics.checkNotNullParameter((Object)$this$fromOpenPgpKeyId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hexKeyId, (String)"hexKeyId");
        if (!new Regex("^[0-9A-Fa-f]{16}$").matches((CharSequence)hexKeyId)) {
            boolean bl = false;
            String string = "Provided long key-id does not match expected format. A long key-id consists of 16 hexadecimal characters.";
            throw new IllegalArgumentException(string.toString());
        }
        return UStringsKt.toULong((String)hexKeyId, (int)16);
    }
}

