/*
 * Decompiled with CFR 0.152.
 */
package openpgp;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0006\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\n\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0006\u0010\r\u001a\u00020\u0005\u001a\u0012\u0010\u000e\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006\u001a\n\u0010\u0010\u001a\u00020\u0006*\u00020\u0006\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"parser", "Ljava/text/SimpleDateFormat;", "getParser", "()Ljava/text/SimpleDateFormat;", "asSeconds", "", "Ljava/util/Date;", "getAsSeconds", "(Ljava/util/Date;)J", "formatUTC", "", "parseUTC", "plusSeconds", "seconds", "secondsTill", "later", "toSecondsPrecision", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nDateExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateExtensions.kt\nopenpgp/DateExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class DateExtensionsKt {
    @Nullable
    public static final Date plusSeconds(@NotNull Date $this$plusSeconds, long seconds) {
        Intrinsics.checkNotNullParameter((Object)$this$plusSeconds, (String)"<this>");
        if (!(Long.MAX_VALUE - $this$plusSeconds.getTime() > seconds)) {
            boolean bl = false;
            String string = "Adding " + seconds + " seconds to this date would cause time to overflow.";
            throw new IllegalArgumentException(string.toString());
        }
        return seconds == 0L ? null : new Date($this$plusSeconds.getTime() + (long)1000 * seconds);
    }

    public static final long getAsSeconds(@NotNull Date $this$asSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$asSeconds, (String)"<this>");
        return $this$asSeconds.getTime() / (long)1000;
    }

    public static final long secondsTill(@NotNull Date $this$secondsTill, @NotNull Date later) {
        Intrinsics.checkNotNullParameter((Object)$this$secondsTill, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)later, (String)"later");
        if (!($this$secondsTill.compareTo(later) <= 0)) {
            boolean bl = false;
            String string = "Timestamp MUST be before the later timestamp.";
            throw new IllegalArgumentException(string.toString());
        }
        return DateExtensionsKt.getAsSeconds(later) - DateExtensionsKt.getAsSeconds($this$secondsTill);
    }

    @NotNull
    public static final Date toSecondsPrecision(@NotNull Date $this$toSecondsPrecision) {
        Intrinsics.checkNotNullParameter((Object)$this$toSecondsPrecision, (String)"<this>");
        return new Date(DateExtensionsKt.getAsSeconds($this$toSecondsPrecision) * (long)1000);
    }

    @NotNull
    public static final SimpleDateFormat getParser() {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat $this$_get_parser__u24lambda_u242 = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        boolean bl = false;
        $this$_get_parser__u24lambda_u242.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    @NotNull
    public static final String formatUTC(@NotNull Date $this$formatUTC) {
        Intrinsics.checkNotNullParameter((Object)$this$formatUTC, (String)"<this>");
        String string = DateExtensionsKt.getParser().format($this$formatUTC);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final Date parseUTC(@NotNull String $this$parseUTC) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)$this$parseUTC, (String)"<this>");
        try {
            date = DateExtensionsKt.getParser().parse($this$parseUTC);
            Intrinsics.checkNotNull((Object)date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Malformed UTC timestamp: " + $this$parseUTC, e);
        }
        return date;
    }
}

