/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text.json;

import java.math.BigDecimal;
import java.util.Map;
import org.pfsw.text.StringExaminer;
import org.pfsw.text.StringUtil;
import org.pfsw.text.json.CharEscaper;
import org.pfsw.text.json.JsonArray;
import org.pfsw.text.json.JsonConstants;
import org.pfsw.text.json.JsonObject;
import org.pfsw.text.json.JsonParseException;
import org.pfsw.text.json.JsonType;

public class SimpleJsonParser {
    private static final StringUtil SU = StringUtil.current();
    private final CharEscaper charEscaper = new CharEscaper();
    private StringExaminer stringExaminer;

    public static SimpleJsonParser create() {
        return new SimpleJsonParser();
    }

    public Object parse(String jsonText) throws JsonParseException {
        this.setStringExaminer(new StringExaminer(jsonText));
        return this.parseInternal();
    }

    public JsonObject parseObject(String jsonText) throws JsonParseException {
        return this.parseTo(jsonText, JsonObject.class);
    }

    public JsonArray parseArray(String jsonText) throws JsonParseException {
        return this.parseTo(jsonText, JsonArray.class);
    }

    protected boolean isObjectStart(char ch) {
        return JsonConstants.BEGIN_OBJECT == ch;
    }

    protected boolean isObjectEnd(char ch) {
        return JsonConstants.END_OBJECT == ch;
    }

    protected boolean isArrayStart(char ch) {
        return JsonConstants.BEGIN_ARRAY == ch;
    }

    protected boolean isArrayEnd(char ch) {
        return JsonConstants.END_ARRAY == ch;
    }

    protected boolean isStringStart(char ch) {
        return this.getStringDelimiter() == ch;
    }

    protected boolean isStringEnd(char ch) {
        return this.getStringDelimiter() == ch;
    }

    protected boolean isEscape(char ch) {
        return JsonConstants.ESCAPE == ch;
    }

    protected boolean isValueSeparator(char ch) {
        return JsonConstants.VALUE_SEPARATOR == ch;
    }

    protected boolean isNumberStart(char ch) {
        return Character.isDigit(ch) || ch == '-' || ch == '+';
    }

    protected Object parseInternal() throws JsonParseException {
        return this.parseValue();
    }

    protected Object parseValue() throws JsonParseException {
        char ch = this.peekNextNoneWhitespaceChar();
        if (this.isObjectStart(ch)) {
            return this.parseObject();
        }
        if (this.isArrayStart(ch)) {
            return this.parseArray();
        }
        if (this.isStringStart(ch)) {
            return this.parseString();
        }
        if (this.isNumberStart(ch)) {
            return this.parseNumber();
        }
        return this.parseLiteral();
    }

    protected JsonObject parseObject() throws JsonParseException {
        this.checkNextMandatoryToken(JsonConstants.BEGIN_OBJECT);
        JsonObject jsonObject = this.createObject();
        char ch = this.peekNextNoneWhitespaceChar();
        if (this.isObjectEnd(ch)) {
            this.nextChar();
            return jsonObject;
        }
        do {
            this.parseKeyValueInto(jsonObject);
            ch = this.nextNoneWhitespaceChar();
            if (!this.isObjectEnd(ch)) continue;
            return jsonObject;
        } while (this.isValueSeparator(ch));
        throw new JsonParseException("Value separator '" + JsonConstants.VALUE_SEPARATOR + "' expected at position: " + this.getLastPosition());
    }

    protected void parseKeyValueInto(Map<String, Object> jsonObject) throws JsonParseException {
        String key = this.parseString();
        this.checkNextMandatoryToken(JsonConstants.NAME_SEPARATOR);
        Object value = this.parseValue();
        jsonObject.put(key, value);
    }

    protected JsonArray parseArray() throws JsonParseException {
        this.checkNextMandatoryToken(JsonConstants.BEGIN_ARRAY);
        JsonArray jsonArray = this.createArray();
        char ch = this.peekNextNoneWhitespaceChar();
        if (this.isArrayEnd(ch)) {
            this.nextChar();
            return jsonArray;
        }
        do {
            Object value = this.parseValue();
            jsonArray.add(value);
            ch = this.nextNoneWhitespaceChar();
            if (!this.isArrayEnd(ch)) continue;
            return jsonArray;
        } while (this.isValueSeparator(ch));
        throw new JsonParseException("Value separator '" + JsonConstants.VALUE_SEPARATOR + "' expected in array at position: " + this.getLastPosition());
    }

    protected String parseString() throws JsonParseException {
        this.checkNextMandatoryToken(this.getStringDelimiter());
        String string = this.parseUpToQuote();
        return string;
    }

    protected String parseUpToQuote() throws JsonParseException {
        StringBuilder buffer = new StringBuilder(200);
        char ch = this.nextChar();
        while (!this.isStringEnd(ch)) {
            if (this.isEscape(ch)) {
                ch = this.nextChar();
                ch = this.getCharEscaper().getCharForEscapedChar(ch);
            }
            buffer.append(ch);
            ch = this.nextChar();
        }
        return buffer.toString();
    }

    protected Number parseNumber() throws JsonParseException {
        BigDecimal number;
        int pos = this.getLastPosition();
        String string = this.parseLiteralString(30, "+-0123456789.eE");
        try {
            number = new BigDecimal(string);
        }
        catch (NumberFormatException ex) {
            throw new JsonParseException("Invalid number: " + string + " , at position: " + pos);
        }
        if (number.scale() == 0) {
            if (number.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) < 0) {
                return number.intValue();
            }
            return number.longValue();
        }
        return number;
    }

    protected String parseLiteralString(int maxLength, String allowedChars) throws JsonParseException {
        StringBuilder buffer = new StringBuilder(maxLength);
        char ch = this.peekNextChar();
        while (buffer.length() < maxLength && SU.contains(allowedChars, ch)) {
            buffer.append(this.nextChar());
            ch = this.peekNextChar();
        }
        return buffer.toString();
    }

    protected Object parseLiteral() throws JsonParseException {
        this.peekNextNoneWhitespaceChar();
        int pos = this.getLastPosition();
        String text = this.parseLiteralString(5, "truefalsn");
        if (JsonConstants.TRUE.equals(text)) {
            return Boolean.TRUE;
        }
        if (JsonConstants.FALSE.equals(text)) {
            return Boolean.FALSE;
        }
        if (JsonConstants.NULL.equals(text)) {
            return null;
        }
        throw new JsonParseException("No valid JSON literal: " + text + "   at position " + pos);
    }

    protected <T extends JsonType> T parseTo(String json, Class<T> resultType) throws JsonParseException {
        Object result = this.parse(json);
        if (resultType.isInstance(result)) {
            return (T)((JsonType)result);
        }
        throw new JsonParseException("Class cast problem for parsed JSON. Actual class is: " + result.getClass().getName());
    }

    protected int getLastPosition() {
        return this.getStringExaminer().getPosition();
    }

    protected void checkNextMandatoryToken(char expectedChar) throws JsonParseException {
        char ch = this.nextNoneWhitespaceChar();
        if (ch != expectedChar) {
            throw new JsonParseException("Expected token <" + expectedChar + "> not found at position " + this.getLastPosition());
        }
    }

    protected char nextNoneWhitespaceChar() throws JsonParseException {
        char ch = this.getStringExaminer().nextNoneWhitespaceChar();
        if (this.getStringExaminer().endReached(ch)) {
            throw new JsonParseException("End of data reached unexpectedly.");
        }
        return ch;
    }

    protected char nextChar() throws JsonParseException {
        char ch = this.getStringExaminer().nextChar();
        if (this.getStringExaminer().endReached(ch)) {
            throw new JsonParseException("Unexpected end of data reached.");
        }
        return ch;
    }

    protected char peekNextChar() {
        return this.getStringExaminer().peek();
    }

    protected char peekNextNoneWhitespaceChar() throws JsonParseException {
        char ch = this.nextNoneWhitespaceChar();
        this.getStringExaminer().skip(-1);
        return ch;
    }

    protected char getStringDelimiter() {
        return JsonConstants.STRING_DELIMITER;
    }

    protected JsonObject createObject() {
        return new JsonObject();
    }

    protected JsonArray createArray() {
        return new JsonArray(new Object[0]);
    }

    protected StringExaminer getStringExaminer() {
        return this.stringExaminer;
    }

    protected void setStringExaminer(StringExaminer stringExaminer) {
        this.stringExaminer = stringExaminer;
    }

    public CharEscaper getCharEscaper() {
        return this.charEscaper;
    }

    protected String getCurrentStringRegion(int backwards, int forwards) {
        int len = backwards + forwards;
        StringBuilder buffer = new StringBuilder(len);
        this.getStringExaminer().markPosition();
        this.getStringExaminer().skip(backwards * -1);
        for (int i = 0; i < len; ++i) {
            buffer.append(this.getStringExaminer().nextChar());
        }
        this.getStringExaminer().restorePosition();
        return buffer.toString();
    }
}

