/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import org.pfsw.bif.exceptions.IORuntimeException;
import org.pfsw.bif.text.IJSONConvertible;
import org.pfsw.bif.text.IStringRepresentation;
import org.pfsw.text.json.JsonArray;
import org.pfsw.text.json.JsonObject;

public class JsonUtil {
    public static final JsonUtil JU = new JsonUtil();
    private static final Class<?>[] JSON_TYPES = new Class[]{JsonObject.class, JsonArray.class, String.class, Boolean.class, Integer.class, Long.class, BigDecimal.class};
    private static JsonUtil soleInstance = JU;

    public static JsonUtil current() {
        return soleInstance;
    }

    protected JsonUtil() {
    }

    public String convertToJSON(IJSONConvertible jsonConvertible) {
        if (jsonConvertible == null) {
            return IJSONConvertible.JSON_LITERAL_NULL;
        }
        StringBuffer buffer = new StringBuffer(100);
        jsonConvertible.appendAsJSONString((Appendable)buffer);
        return buffer.toString();
    }

    public String arrayToJSON(Object ... objects) {
        StringBuffer buffer = new StringBuffer(50 * objects.length);
        this.appendJSONArray(buffer, objects);
        return buffer.toString();
    }

    public String mapToJSON(Map<String, Object> map) {
        if (map == null) {
            return IJSONConvertible.JSON_LITERAL_NULL;
        }
        StringBuffer buffer = new StringBuffer(50 * map.size());
        this.appendJSONMap(buffer, map);
        return buffer.toString();
    }

    public String toJSONStringLiteral(String str) {
        if (str == null) {
            return IJSONConvertible.JSON_LITERAL_NULL;
        }
        return IJSONConvertible.JSON_STRING_DELIMITER + str + IJSONConvertible.JSON_STRING_DELIMITER;
    }

    public void appendJSONPair(Appendable output, String name, Object value) {
        this.appendJsonPair(output, name, value, true);
    }

    public void appendJsonPair(Appendable output, String name, Object value) {
        this.appendJsonPair(output, name, value, false);
    }

    public void appendJsonPair(Appendable output, String name, Object value, boolean compact) {
        try {
            this.appendJSONString(output, name);
            if (!compact) {
                output.append(" ");
            }
            output.append(IJSONConvertible.JSON_PAIR_SEPARATOR);
            if (!compact) {
                output.append(" ");
            }
            this.appendJSONObject(output, value);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void appendJSONString(Appendable output, String str) {
        try {
            output.append(IJSONConvertible.JSON_STRING_DELIMITER);
            output.append(str);
            output.append(IJSONConvertible.JSON_STRING_DELIMITER);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void appendJSONConvertible(Appendable output, IJSONConvertible jsonConvertible) {
        if (jsonConvertible == null) {
            try {
                output.append(IJSONConvertible.JSON_LITERAL_NULL);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        } else {
            jsonConvertible.appendAsJSONString(output);
        }
    }

    public void appendJSONArray(Appendable output, Object ... objects) {
        boolean isFirst = true;
        try {
            output.append(IJSONConvertible.JSON_ARRAY_START);
            for (Object object : objects) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    output.append(IJSONConvertible.JSON_ELEMENT_SEPARATOR);
                }
                this.appendJSONObject(output, object);
            }
            output.append(IJSONConvertible.JSON_ARRAY_END);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void appendJSONObject(Appendable output, Object object) {
        try {
            if (object == null) {
                output.append(IJSONConvertible.JSON_LITERAL_NULL);
            } else if (object instanceof String) {
                this.appendJSONString(output, (String)object);
            } else if (object instanceof IJSONConvertible) {
                IJSONConvertible convertible = (IJSONConvertible)object;
                this.appendJSONConvertible(output, convertible);
            } else if (object instanceof Number) {
                output.append(object.toString());
            } else if (object instanceof Character) {
                Character ch = (Character)object;
                this.appendJSONString(output, String.valueOf(ch.charValue()));
            } else if (object instanceof Boolean) {
                Boolean bool = (Boolean)object;
                output.append(bool != false ? IJSONConvertible.JSON_LITERAL_TRUE : IJSONConvertible.JSON_LITERAL_FALSE);
            } else if (object instanceof IStringRepresentation) {
                this.appendJSONString(output, ((IStringRepresentation)object).asString());
            } else {
                this.appendJSONString(output, object.toString());
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void appendJSONMap(Appendable output, Map<String, Object> map) {
        boolean isFirst = true;
        try {
            if (map == null) {
                output.append(IJSONConvertible.JSON_LITERAL_NULL);
                return;
            }
            output.append(IJSONConvertible.JSON_OBJECT_START);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    output.append(IJSONConvertible.JSON_ELEMENT_SEPARATOR);
                }
                this.appendJSONPair(output, entry.getKey(), entry.getValue());
            }
            output.append(IJSONConvertible.JSON_OBJECT_END);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public String objectToJSONValue(Object object) {
        StringBuffer buffer = new StringBuffer(100);
        this.appendJSONObject(buffer, object);
        return buffer.toString();
    }

    public boolean isValidJsonTypeInstance(Object object) {
        if (object == null) {
            return true;
        }
        return this.isValidJsonType(object.getClass());
    }

    public boolean isValidJsonType(Class<?> type) {
        if (type == null) {
            return false;
        }
        for (Class<?> jsonType : JSON_TYPES) {
            if (type != jsonType) continue;
            return true;
        }
        return false;
    }
}

