/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text.json;

import java.math.BigDecimal;
import org.pfsw.bif.text.IStringConstant;
import org.pfsw.text.NaturalNumber;
import org.pfsw.text.TimeUnit;
import org.pfsw.text.TimeValue;
import org.pfsw.text.json.JsonAccessException;
import org.pfsw.text.json.JsonArray;
import org.pfsw.text.json.JsonObject;

public class JsonObjectAccessor {
    private final JsonObject jsonObject;

    public static JsonObjectAccessor create(JsonObject jsonObject) {
        return new JsonObjectAccessor(jsonObject);
    }

    public JsonObjectAccessor(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    public JsonObjectAccessor getRequiredJsonObjectAccessorValue(IStringConstant name) {
        return this.getRequiredJsonObjectAccessorValue(name.asString());
    }

    public JsonObjectAccessor getRequiredJsonObjectAccessorValue(String name) {
        JsonObject object = this.getRequiredJsonObjectValue(name);
        return new JsonObjectAccessor(object);
    }

    public JsonObject getRequiredJsonObjectValue(IStringConstant name) {
        return this.getRequiredJsonObjectValue(name.asString());
    }

    public JsonObject getRequiredJsonObjectValue(String name) {
        return this.getRequiredTypedValue(name, JsonObject.class);
    }

    public JsonArray getRequiredJsonArrayValue(IStringConstant name) {
        return this.getRequiredJsonArrayValue(name.asString());
    }

    public JsonArray getRequiredJsonArrayValue(String name) {
        return this.getRequiredTypedValue(name, JsonArray.class);
    }

    public String getRequiredStringValue(IStringConstant name) {
        return this.getRequiredStringValue(name.asString());
    }

    public String getRequiredStringValue(String name) {
        return this.getRequiredTypedValue(name, String.class);
    }

    public String[] getRequiredStringArrayValue(IStringConstant name) {
        return this.getRequiredStringArrayValue(name.asString());
    }

    public String[] getRequiredStringArrayValue(String name) {
        return this.getStringArray(name, true);
    }

    public Boolean getRequiredBooleanValue(IStringConstant name) {
        return this.getRequiredBooleanValue(name.asString());
    }

    public Boolean getRequiredBooleanValue(String name) {
        return this.getRequiredTypedValue(name, Boolean.class);
    }

    public Integer getRequiredIntegerValue(IStringConstant name) {
        return this.getRequiredIntegerValue(name.asString());
    }

    public Integer getRequiredIntegerValue(String name) {
        return this.getRequiredTypedValue(name, Integer.class);
    }

    public Long getRequiredLongValue(IStringConstant name) {
        return this.getRequiredLongValue(name.asString());
    }

    public Long getRequiredLongValue(String name) {
        return this.getRequiredTypedValue(name, Long.class);
    }

    public BigDecimal getRequiredBigDecimalValue(IStringConstant name) {
        return this.getRequiredBigDecimalValue(name.asString());
    }

    public BigDecimal getRequiredBigDecimalValue(String name) {
        return this.getRequiredTypedValue(name, BigDecimal.class);
    }

    public NaturalNumber getRequiredNaturalNumberValue(IStringConstant name) {
        return this.getRequiredNaturalNumberValue(name.asString());
    }

    public NaturalNumber getRequiredNaturalNumberValue(String name) {
        return this.getRequiredTypedValue(name, NaturalNumber.class);
    }

    public TimeValue getRequiredTimeValue(IStringConstant name, TimeUnit timeUnit) {
        return this.getRequiredTimeValue(name.asString(), timeUnit);
    }

    public TimeValue getRequiredTimeValue(String name, TimeUnit timeUnit) {
        return this.asTimeValue(this.getRequiredLongValue(name), timeUnit);
    }

    public Object getRequiredRawValue(IStringConstant name) {
        return this.getRequiredRawValue(name.asString());
    }

    public Object getRequiredRawValue(String name) {
        return this.getRawValueOf(name, true);
    }

    public JsonObjectAccessor getOptionalJsonObjectAccessorValue(IStringConstant name) {
        return this.getOptionalJsonObjectAccessorValue(name.asString());
    }

    public JsonObjectAccessor getOptionalJsonObjectAccessorValue(String name) {
        JsonObject object = this.getOptionalJsonObjectValue(name);
        if (object == null) {
            return null;
        }
        return new JsonObjectAccessor(object);
    }

    public JsonObject getOptionalJsonObjectValue(IStringConstant name) {
        return this.getOptionalJsonObjectValue(name.asString());
    }

    public JsonObject getOptionalJsonObjectValue(String name) {
        return this.getOptionalTypedValue(name, JsonObject.class);
    }

    public JsonArray getOptionalJsonArrayValue(IStringConstant name) {
        return this.getOptionalJsonArrayValue(name.asString());
    }

    public JsonArray getOptionalJsonArrayValue(String name) {
        return this.getOptionalTypedValue(name, JsonArray.class);
    }

    public String getOptionalStringValue(IStringConstant name) {
        return this.getOptionalStringValue(name.asString());
    }

    public String getOptionalStringValue(String name) {
        return this.getOptionalTypedValue(name, String.class);
    }

    public String[] getOptionalStringArrayValue(IStringConstant name) {
        return this.getOptionalStringArrayValue(name.asString());
    }

    public String[] getOptionalStringArrayValue(String name) {
        return this.getStringArray(name, false);
    }

    public Boolean getOptionalBooleanValue(IStringConstant name) {
        return this.getOptionalBooleanValue(name.asString());
    }

    public Boolean getOptionalBooleanValue(String name) {
        return this.getOptionalTypedValue(name, Boolean.class);
    }

    public Integer getOptionalIntegerValue(IStringConstant name) {
        return this.getOptionalIntegerValue(name.asString());
    }

    public Integer getOptionalIntegerValue(String name) {
        return this.getOptionalTypedValue(name, Integer.class);
    }

    public Long getOptionalLongValue(IStringConstant name) {
        return this.getOptionalLongValue(name.asString());
    }

    public Long getOptionalLongValue(String name) {
        return this.getOptionalTypedValue(name, Long.class);
    }

    public BigDecimal getOptionalBigDecimalValue(IStringConstant name) {
        return this.getOptionalBigDecimalValue(name.asString());
    }

    public BigDecimal getOptionalBigDecimalValue(String name) {
        return this.getOptionalTypedValue(name, BigDecimal.class);
    }

    public NaturalNumber getOptionalNaturalNumberValue(IStringConstant name) {
        return this.getOptionalNaturalNumberValue(name.asString());
    }

    public NaturalNumber getOptionalNaturalNumberValue(String name) {
        return this.getOptionalTypedValue(name, NaturalNumber.class);
    }

    public TimeValue getOptionalTimeValue(IStringConstant name, TimeUnit timeUnit) {
        return this.getOptionalTimeValue(name.asString(), timeUnit);
    }

    public TimeValue getOptionalTimeValue(String name, TimeUnit timeUnit) {
        return this.asTimeValue(this.getOptionalLongValue(name), timeUnit);
    }

    public Object getOptionalRawValue(IStringConstant name) {
        return this.getOptionalRawValue(name.asString());
    }

    public Object getOptionalRawValue(String name) {
        return this.getRawValueOf(name, false);
    }

    public <T> T getOptionalTypedValue(IStringConstant name, Class<T> type) {
        return this.getOptionalTypedValue(name.asString(), type);
    }

    public <T> T getOptionalTypedValue(String name, Class<T> type) {
        return this.getTypedValueOf(name, type, false);
    }

    public <T> T getRequiredTypedValue(IStringConstant name, Class<T> type) {
        return this.getRequiredTypedValue(name.asString(), type);
    }

    public <T> T getRequiredTypedValue(String name, Class<T> type) {
        return this.getTypedValueOf(name, type, true);
    }

    public <T> T getTypedValueOf(IStringConstant name, Class<T> type, boolean isRequired) {
        return this.getTypedValueOf(name.asString(), type, isRequired);
    }

    public <T> T getTypedValueOf(String name, Class<T> type, boolean isRequired) {
        T value;
        try {
            value = type == Long.class ? type.cast(this.getLongValueOf(name)) : (type == NaturalNumber.class ? type.cast(this.getNaturalNumberValueOf(name)) : this.getJsonObject().getValueOfType(name, type));
        }
        catch (Exception ex) {
            throw new JsonAccessException(ex, "Type conversion problem for value of \"%s\". The value is not %s", name, type.getSimpleName());
        }
        if (value == null && isRequired) {
            this.signalRequiredFieldMissing(name);
        }
        return value;
    }

    public Object getRawValueOf(IStringConstant name, boolean isRequired) {
        return this.getRawValueOf(name.asString(), isRequired);
    }

    public Object getRawValueOf(String name, boolean isRequired) {
        Object value = this.getJsonObject().get(name);
        if (value == null && isRequired) {
            this.signalRequiredFieldMissing(name);
        }
        return value;
    }

    public void signalRequiredFieldMissing(String fieldName) throws JsonAccessException {
        throw new JsonAccessException("Required field missing: \"%s\"", fieldName);
    }

    protected String[] getStringArray(String name, boolean isRequired) {
        JsonArray jsonArray = this.getTypedValueOf(name, JsonArray.class, isRequired);
        if (jsonArray == null) {
            return null;
        }
        String[] strings = new String[jsonArray.size()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = jsonArray.getString(i);
        }
        return strings;
    }

    protected NaturalNumber getNaturalNumberValueOf(String name) {
        Long longValue = this.getLongValueOf(name, "NaturalNumber");
        if (longValue == null) {
            return null;
        }
        return NaturalNumber.valueOf(longValue);
    }

    protected Long getLongValueOf(String name) {
        return this.getLongValueOf(name, "Long");
    }

    protected Long getLongValueOf(String name, String targetTypeName) {
        Object value = this.getJsonObject().get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return intValue.longValue();
        }
        throw new ClassCastException("Field named <" + name + "> is not of type " + targetTypeName + ". It is a " + value.getClass().getName());
    }

    protected TimeValue asTimeValue(Long value, TimeUnit timeUnit) {
        if (value == null) {
            return null;
        }
        return new TimeValue(value, timeUnit);
    }
}

