/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text.json;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pfsw.bif.facet.IReadOnlyNamedValues;
import org.pfsw.bif.text.IStringConstant;
import org.pfsw.text.json.JsonArray;
import org.pfsw.text.json.JsonType;
import org.pfsw.text.json.JsonUtil;

public class JsonObject
extends LinkedHashMap<String, Object>
implements JsonType,
IReadOnlyNamedValues<Object> {
    private static final long serialVersionUID = 4396195499191118203L;
    private static final JsonUtil JU = JsonUtil.current();

    public JsonObject() {
    }

    public JsonObject(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public JsonObject(int initialCapacity) {
        super(initialCapacity);
    }

    public JsonObject(Map<? extends String, ? extends Object> map) {
        super(map);
    }

    @Override
    public Object put(String key, Object value) {
        if (JsonUtil.current().isValidJsonTypeInstance(value)) {
            return super.put(key, value);
        }
        throw new IllegalArgumentException("Cannot add an object of invalid JSON type " + value.getClass().getName());
    }

    public JsonObject setField(IStringConstant name, Object value) {
        this.put(name.asString(), value);
        return this;
    }

    public JsonObject getJsonObject(String name) {
        return this.getValueOfType(name, JsonObject.class);
    }

    public JsonObject getJsonObject(IStringConstant name) {
        return this.getJsonObject(name.asString());
    }

    public JsonArray getJsonArray(String name) {
        return this.getValueOfType(name, JsonArray.class);
    }

    public JsonArray getJsonArray(IStringConstant name) {
        return this.getJsonArray(name.asString());
    }

    public String getString(String name) {
        return this.getValueOfType(name, String.class);
    }

    public String getString(IStringConstant name) {
        return this.getString(name.asString());
    }

    public Boolean getBoolean(String name) {
        return this.getValueOfType(name, Boolean.class);
    }

    public Boolean getBoolean(IStringConstant name) {
        return this.getBoolean(name.asString());
    }

    public Number getNumber(String name) {
        return this.getTypedElement(name, Number.class);
    }

    public Number getNumber(IStringConstant name) {
        return this.getNumber(name.asString());
    }

    public Integer getInteger(String name) {
        return this.getValueOfType(name, Integer.class);
    }

    public Integer getInteger(IStringConstant name) {
        return this.getInteger(name.asString());
    }

    public Long getLong(String name) {
        return this.getValueOfType(name, Long.class);
    }

    public Long getLong(IStringConstant name) {
        return this.getLong(name.asString());
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getValueOfType(name, BigDecimal.class);
    }

    public BigDecimal getBigDecimal(IStringConstant name) {
        return this.getBigDecimal(name.asString());
    }

    public <T> T getValueOfType(String name, Class<T> type) {
        if (JsonUtil.current().isValidJsonType(type)) {
            return this.getTypedElement(name, type);
        }
        throw new IllegalArgumentException("The specified type " + type.getName() + " of \"" + name + "\" is not supported!");
    }

    public <T> T getValueOfType(IStringConstant name, Class<T> type) {
        return this.getValueOfType(name.asString(), type);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    public Collection<String> getNames() {
        return this.keySet();
    }

    public Object getValue(String name) {
        return this.get(name);
    }

    public Object getValue(IStringConstant name) {
        return this.getValue(name.asString());
    }

    public String asString() {
        return this.toJSON();
    }

    public void appendAsJSONString(Appendable output) {
        JU.appendJSONMap(output, this);
    }

    public String toJSON() {
        StringBuffer buffer = new StringBuffer(500);
        this.appendAsJSONString(buffer);
        return buffer.toString();
    }

    protected <T> T getTypedElement(String name, Class<T> type) {
        Object object = this.get(name);
        if (object == null || type.isInstance(object)) {
            return (T)object;
        }
        throw new ClassCastException("Object named <" + name + "> is no " + type.getName() + ". It is a " + object.getClass().getName());
    }
}

