/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text.json;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pfsw.bif.exceptions.IORuntimeException;
import org.pfsw.text.json.JsonObject;
import org.pfsw.text.json.JsonType;
import org.pfsw.text.json.JsonUtil;

public class JsonArray
extends ArrayList<Object>
implements JsonType {
    private static final long serialVersionUID = -6724887777835446777L;
    private static final JsonUtil JU = JsonUtil.current();

    public JsonArray(Object ... objects) {
        for (Object object : objects) {
            this.add(object);
        }
    }

    public JsonArray(Collection<? extends Object> collection) {
        super(collection);
    }

    public JsonArray(int initialCapacity) {
        super(initialCapacity);
    }

    public JsonObject getJsonObject(int index) {
        return this.getTypedElement(index, JsonObject.class);
    }

    public JsonArray getJsonArray(int index) {
        return this.getTypedElement(index, JsonArray.class);
    }

    public String getString(int index) {
        return this.getValueOfType(index, String.class);
    }

    public Boolean getBoolean(int index) {
        return this.getValueOfType(index, Boolean.class);
    }

    public Number getNumber(int index) {
        return this.getTypedElement(index, Number.class);
    }

    public Integer getInteger(int index) {
        return this.getValueOfType(index, Integer.class);
    }

    public Long getLong(int index) {
        return this.getValueOfType(index, Long.class);
    }

    public BigDecimal getBigDecimal(int index) {
        return this.getValueOfType(index, BigDecimal.class);
    }

    public <T> T getValueOfType(int index, Class<T> type) {
        if (JsonUtil.current().isValidJsonType(type)) {
            return this.getTypedElement(index, type);
        }
        throw new IllegalArgumentException("The specified type " + type.getName() + " at index " + index + " is not supported!");
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean add(Object object) {
        if (!JsonUtil.current().isValidJsonTypeInstance(object)) {
            throw new IllegalArgumentException("Cannot add object of invalid JSON type " + object.getClass().getName());
        }
        super.add(object);
        return true;
    }

    public void addElements(Object ... elements) {
        for (Object object : elements) {
            this.add(object);
        }
    }

    public <T> List<T> asList(Class<T> elementType) {
        ArrayList elements = new ArrayList();
        for (Object object : this) {
            if (elementType.isInstance(object)) {
                elements.add(object);
                continue;
            }
            throw new ClassCastException("At least one elemnt is not of type " + elementType.getName() + "; It is a " + (object == null ? "null" : object.getClass().getName()));
        }
        return elements;
    }

    public String asString() {
        return this.toJSON();
    }

    public void appendAsJSONString(Appendable output) {
        boolean first = true;
        try {
            output.append(JSON_ARRAY_START);
            for (Object element : this) {
                if (first) {
                    first = false;
                } else {
                    output.append(JSON_ELEMENT_SEPARATOR);
                }
                JU.appendJSONObject(output, element);
            }
            output.append(JSON_ARRAY_END);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public String toJSON() {
        StringBuffer buffer = new StringBuffer(500);
        this.appendAsJSONString(buffer);
        return buffer.toString();
    }

    protected <T> T getTypedElement(int index, Class<T> type) {
        Object object = this.get(index);
        if (object == null || type.isInstance(object)) {
            return (T)object;
        }
        throw new ClassCastException("Object at <" + index + "> is no " + type.getName() + ". It is a " + object.getClass().getName());
    }
}

