/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.util.ArrayList;
import java.util.List;
import org.pfsw.bif.text.IStringPair;
import org.pfsw.bif.text.IStringRepresentation;
import org.pfsw.text.StringUtil;

public class Version
implements IStringRepresentation {
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int GREATER = 1;
    private static final String JAVA_VERSION_PROPERTY = "java.version";
    private static final String JAVA_PATCH_SEPARATOR = "_";
    private static final int MUST_BE_NUMERIC = 2;
    static final Integer NOT_SET = new Integer(-1);
    public static final String SEPARATOR = ".";
    public static final String SPECIAL_CHARACTERS = "-_";
    private List<VersionElement> elements = null;

    public static boolean isValidVersion(String str) {
        if (str == null) {
            return false;
        }
        Version version = new Version(str);
        return version.isValid();
    }

    public static Version getJavaVersion() {
        return new Version(System.getProperty(JAVA_VERSION_PROPERTY));
    }

    public static Version getJavaBaseVersion() {
        String versionStr = System.getProperty(JAVA_VERSION_PROPERTY);
        versionStr = StringUtil.current().cutTail(versionStr, JAVA_PATCH_SEPARATOR);
        return new Version(versionStr);
    }

    protected Version() {
        this.setElements(new ArrayList<VersionElement>());
    }

    public Version(String versionString) {
        this();
        this.parse(versionString);
    }

    public Version(Version version) {
        this();
        for (VersionElement vElement : version.getElements()) {
            this.getElements().add(vElement.copy());
        }
    }

    public Version(int major, int minor, int micro, String qualifier) {
        this(major, minor, micro);
        if (qualifier.startsWith(JAVA_PATCH_SEPARATOR)) {
            this.getElements().add(new VersionElement(qualifier));
        } else {
            this.getLastElement().setStringPart(qualifier);
        }
    }

    public Version(int major, int minor, int micro) {
        this(major, minor);
        this.addElement(micro);
    }

    public Version(int major, int minor) {
        this(major);
        this.addElement(minor);
    }

    public Version(int major) {
        this();
        this.addElement(major);
    }

    public boolean isGreaterThan(Version version) {
        return this.compareTo(version) == 1;
    }

    public boolean isLessThan(Version version) {
        return this.compareTo(version) == -1;
    }

    public boolean isGreaterThan(String version) {
        return this.isGreaterThan(new Version(version));
    }

    public boolean isLessThan(String version) {
        return this.isLessThan(new Version(version));
    }

    public boolean isGreaterOrEqual(Version version) {
        int result = this.compareTo(version);
        return result == 1 || result == 0;
    }

    public boolean isLessOrEqual(Version version) {
        int result = this.compareTo(version);
        return result == -1 || result == 0;
    }

    public boolean isGreaterOrEqual(String strVersion) {
        return this.isGreaterOrEqual(new Version(strVersion));
    }

    public boolean isLessOrEqual(String strVersion) {
        return this.isLessOrEqual(new Version(strVersion));
    }

    public boolean isEqualTo(String strVersion) {
        if (!Version.isValidVersion(strVersion)) {
            return false;
        }
        Version otherVersion = new Version(strVersion);
        return this.equals(otherVersion);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.compareTo(obj) == 0;
        }
        if (obj instanceof String) {
            return this.compareTo(new Version((String)obj)) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.getElements().size(); ++i) {
            hash ^= this.getElements().get(i).hashCode();
        }
        return hash;
    }

    public String asString() {
        StringBuffer buffer = new StringBuffer(20);
        for (int i = 0; i < this.getElements().size(); ++i) {
            VersionElement element = this.getElements().get(i);
            if (this.needsSeparator(i, element)) {
                buffer.append(SEPARATOR);
            }
            buffer.append(element);
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        for (int i = 0; i < this.getElements().size(); ++i) {
            VersionElement element = this.getElements().get(i);
            if (this.needsSeparator(i, element)) {
                buffer.append(SEPARATOR);
            }
            buffer.append(element);
        }
        return buffer.toString();
    }

    public Version copy() {
        return new Version(this);
    }

    public String[] getVersionElements() {
        String[] subElements = new String[this.getElements().size()];
        for (int i = 0; i < this.getElements().size(); ++i) {
            VersionElement elem = this.getElements().get(i);
            subElements[i] = elem.toString();
        }
        return subElements;
    }

    public int compareTo(Object obj) {
        if (obj instanceof Version) {
            int i;
            Version otherVersion = (Version)obj;
            List<VersionElement> otherElemets = otherVersion.getElements();
            for (i = 0; i < otherElemets.size(); ++i) {
                VersionElement otherElement;
                if (i >= this.getElements().size()) {
                    return -1;
                }
                VersionElement element = this.getElements().get(i);
                int compResult = element.compare(otherElement = otherElemets.get(i));
                if (compResult == 0) continue;
                return compResult < 0 ? -1 : 1;
            }
            return i == this.getElements().size() ? 0 : 1;
        }
        throw new IllegalArgumentException("The object to compare is not a Version");
    }

    public boolean isNumeric() {
        if (this.getElements().isEmpty()) {
            return false;
        }
        for (VersionElement element : this.getElements()) {
            if (element.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        if (this.getElements().isEmpty()) {
            return false;
        }
        VersionElement lastElement = this.getLastElement();
        for (VersionElement element : this.getElements()) {
            if (!element.isValid()) {
                return false;
            }
            if (element == lastElement || !element.hasStringPart()) continue;
            return false;
        }
        return true;
    }

    public int getMajorVersion() {
        return this.getIntValueOfElement(0);
    }

    public int getMinorVersion() {
        return this.getIntValueOfElement(1);
    }

    public int getMicroVersion() {
        return this.getIntValueOfElement(2);
    }

    protected void parse(String versionString) {
        String[] parts = this.str().parts(versionString, SEPARATOR);
        if (this.str().notNullOrEmpty(parts)) {
            for (int i = 0; i < parts.length; ++i) {
                VersionElement element;
                String fragment = parts[i];
                if (parts[i].contains(JAVA_PATCH_SEPARATOR)) {
                    IStringPair pair = this.str().splitStringPair(parts[i], JAVA_PATCH_SEPARATOR);
                    if (this.str().isZeroOrPositiveInteger(pair.getString1())) {
                        element = new VersionElement(pair.getString1());
                        this.getElements().add(element);
                        fragment = JAVA_PATCH_SEPARATOR + pair.getString2();
                    }
                }
                element = new VersionElement(fragment);
                this.getElements().add(element);
                if (i >= 2 || !element.isPureString()) continue;
                element.makeInvalid();
            }
        }
    }

    protected boolean needsSeparator(int elementIndex, VersionElement element) {
        if (elementIndex == 0) {
            return false;
        }
        return !element.isPureString() || !element.strPart.startsWith(JAVA_PATCH_SEPARATOR);
    }

    protected int getIntValueOfElement(int index) {
        VersionElement element = this.getElement(index);
        if (element == null) {
            return NOT_SET;
        }
        if (!element.isNumeric()) {
            return NOT_SET;
        }
        return element.getNumeric();
    }

    protected void addElement(int value) {
        int num = value < 0 ? 0 : value;
        this.getElements().add(new VersionElement(num));
    }

    protected VersionElement getLastElement() {
        return this.getElements().get(this.getElements().size() - 1);
    }

    protected VersionElement getElement(int index) {
        if (index >= 0 && index < this.getElements().size()) {
            return this.getElements().get(index);
        }
        return null;
    }

    protected List<VersionElement> getElements() {
        return this.elements;
    }

    protected void setElements(List<VersionElement> newValue) {
        this.elements = newValue;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    private class VersionElement {
        private boolean isValid = true;
        private Integer intPart = NOT_SET;
        String strPart = "";

        VersionElement(String versionString) {
            this.parse(versionString);
        }

        VersionElement(int intPart) {
            this.intPart = intPart;
        }

        private VersionElement(int intPart, String strPart) {
            this.intPart = intPart;
            this.strPart = strPart;
        }

        public String toString() {
            if (this.intPart.equals(NOT_SET)) {
                return this.strPart;
            }
            return this.intPart.toString() + this.strPart;
        }

        protected void parse(String versionPart) {
            boolean isNumber = true;
            StringBuffer numBuffer = new StringBuffer(20);
            StringBuffer strBuffer = new StringBuffer(20);
            for (int i = 0; i < versionPart.length(); ++i) {
                char ch = versionPart.charAt(i);
                boolean bl = isNumber = isNumber && Character.isDigit(ch);
                if (isNumber) {
                    numBuffer.append(ch);
                    continue;
                }
                strBuffer.append(ch);
            }
            try {
                if (numBuffer.length() > 0) {
                    int value = Integer.parseInt(numBuffer.toString());
                    this.intPart = value;
                }
            }
            catch (NumberFormatException e) {
                this.intPart = NOT_SET;
            }
            this.strPart = strBuffer.toString();
        }

        protected int compare(VersionElement otherElement) {
            int compResult = this.intPart.compareTo(otherElement.intPart);
            if (compResult == 0) {
                compResult = this.strPart.compareTo(otherElement.strPart);
            }
            return compResult;
        }

        protected void makeInvalid() {
            this.isValid = false;
        }

        protected Integer getNumeric() {
            return this.intPart;
        }

        protected void setStringPart(String qualifier) {
            this.strPart = qualifier;
        }

        public boolean equals(Object object) {
            if (object instanceof VersionElement) {
                return this.compare((VersionElement)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            if (this.isNumeric()) {
                return this.intPart;
            }
            return this.strPart.hashCode();
        }

        protected VersionElement copy() {
            return new VersionElement(this.intPart, this.strPart);
        }

        protected boolean isValid() {
            if (this.isValid && this.intPart.equals(NOT_SET) && Version.this.str().isNullOrEmpty(this.strPart)) {
                this.isValid = false;
            }
            return this.isValid;
        }

        protected boolean hasStringPart() {
            return Version.this.str().notNullOrEmpty(this.strPart);
        }

        protected boolean isNumeric() {
            return !this.intPart.equals(NOT_SET) && Version.this.str().isNullOrEmpty(this.strPart);
        }

        protected boolean isNumericWithString() {
            return !this.intPart.equals(NOT_SET) && this.hasStringPart();
        }

        protected boolean isPureString() {
            return !this.isNumeric() && !this.isNumericWithString();
        }
    }
}

