/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import org.pfsw.text.NaturalNumber;
import org.pfsw.text.StringPair;
import org.pfsw.text.StringUtil;
import org.pfsw.text.TimeUnit;

public class TimeValue
implements Comparable<TimeValue> {
    private long milliseconds;

    public static TimeValue create(long millisecondsValue) {
        return new TimeValue(millisecondsValue);
    }

    public static TimeValue create(long value, TimeUnit unit) {
        return new TimeValue(value, unit);
    }

    public static TimeValue create(NaturalNumber value, TimeUnit unit) {
        return new TimeValue(value, unit);
    }

    public static TimeValue create(String strValue, TimeUnit defaultUnit) {
        return new TimeValue(strValue, defaultUnit);
    }

    public static TimeValue create(String strValue) {
        return new TimeValue(strValue);
    }

    public TimeValue(long millisecondsValue) {
        this.setMilliseconds(millisecondsValue);
    }

    public TimeValue(long value, TimeUnit unit) {
        this(value * unit.getMsFactor());
    }

    public TimeValue(NaturalNumber value, TimeUnit unit) {
        this(value.longValue(), unit);
    }

    public TimeValue(String strValue, TimeUnit defaultUnit) {
        this(0L);
        this.setMilliseconds(this.parseToMilliseconds(strValue, defaultUnit));
    }

    public TimeValue(String strValue) {
        this(strValue, TimeUnit.MILLISECONDS);
    }

    public long asMilliseconds() {
        return this.getMilliseconds();
    }

    public long asSeconds() {
        return this.convertTo(TimeUnit.SECONDS);
    }

    public long asMinutes() {
        return this.convertTo(TimeUnit.MINUTES);
    }

    public long asHours() {
        return this.convertTo(TimeUnit.HOURS);
    }

    public long convertTo(TimeUnit unit) {
        return this.getMilliseconds() / unit.getMsFactor();
    }

    public String toString() {
        return "TimeValue(" + this.asMilliseconds() + "ms)";
    }

    public int hashCode() {
        return Long.toString(this.asMilliseconds()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeValue) {
            TimeValue other = (TimeValue)obj;
            return this.asMilliseconds() == other.asMilliseconds();
        }
        return false;
    }

    @Override
    public int compareTo(TimeValue other) {
        return Long.valueOf(this.asMilliseconds()).compareTo(other.asMilliseconds());
    }

    protected long parseToMilliseconds(String strValue, TimeUnit defaultUnit) {
        TimeUnit unit = null;
        StringPair stringPair = this.splitDigitsAndUnit(strValue.trim());
        for (TimeUnit timeUnit : TimeUnit.values()) {
            if (!timeUnit.getShortName().equals(stringPair.getString2())) continue;
            unit = timeUnit;
            break;
        }
        if (unit == null) {
            if (StringUtil.current().notNullOrEmpty(stringPair.getString2())) {
                throw new NumberFormatException("Invalid time unit specified: " + strValue);
            }
            unit = defaultUnit;
        }
        long millis = Long.parseLong(stringPair.getString1()) * unit.getMsFactor();
        return millis;
    }

    protected StringPair splitDigitsAndUnit(String str) {
        int noneDigitIndex = 0;
        StringPair pair = new StringPair();
        for (char ch : str.toCharArray()) {
            if (!Character.isDigit(ch)) break;
            ++noneDigitIndex;
        }
        if (noneDigitIndex >= str.length()) {
            pair.setString1(str);
            pair.setString2("");
        } else {
            pair.setString1(str.substring(0, noneDigitIndex));
            pair.setString2(str.substring(noneDigitIndex).trim());
        }
        return pair;
    }

    protected long getMilliseconds() {
        return this.milliseconds;
    }

    protected void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }
}

