/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.pfsw.bif.exceptions.IORuntimeException;
import org.pfsw.bif.text.ICharsets;
import org.pfsw.bif.text.IStringRepresentation;
import org.pfsw.text.NewLine;

public class TextFileWriter
extends OutputStreamWriter {
    public static final Charset DEFAULT_CHARSET = ICharsets.UTF_8;
    public static final NewLine DEFAULT_NEWLINE = NewLine.CURRENT_OS;
    private NewLine newline = DEFAULT_NEWLINE;

    public TextFileWriter(File file, Charset charset) throws FileNotFoundException {
        super((OutputStream)new FileOutputStream(file), charset);
    }

    public TextFileWriter(File file) throws FileNotFoundException {
        this(file, DEFAULT_CHARSET);
    }

    public TextFileWriter(String filename, Charset charset) throws FileNotFoundException {
        this(new File(filename), charset);
    }

    public TextFileWriter(String filename) throws FileNotFoundException {
        this(filename, DEFAULT_CHARSET);
    }

    public TextFileWriter writef(String text, Object ... args) throws IOException {
        this.write(String.format(text, args));
        return this;
    }

    public TextFileWriter write(IStringRepresentation object) throws IOException {
        this.write(object.asString());
        return this;
    }

    public TextFileWriter writeln(String text, Object ... args) throws IOException {
        this.writef(text, args);
        return this.newLine();
    }

    public TextFileWriter writeln(IStringRepresentation object) throws IOException {
        this.write(object);
        return this.newLine();
    }

    public TextFileWriter newLine() throws IOException {
        this.write(this.getNewline().asString());
        return this;
    }

    public NewLine getNewline() {
        return this.newline;
    }

    public TextFileWriter setNewline(NewLine newline) {
        this.newline = newline == null ? DEFAULT_NEWLINE : newline;
        return this;
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeUnchecked() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

