/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.pfsw.bif.exceptions.IORuntimeException;
import org.pfsw.bif.text.ICharsets;
import org.pfsw.bif.text.ILineProcessor;

public class TextFileReader
extends InputStreamReader {
    public static final Charset DEFAULT_CHARSET = ICharsets.UTF_8;

    public TextFileReader(File file, Charset charset) throws FileNotFoundException {
        super((InputStream)new FileInputStream(file), charset);
    }

    public TextFileReader(File file) throws FileNotFoundException {
        this(file, DEFAULT_CHARSET);
    }

    public TextFileReader(String filename, Charset charset) throws FileNotFoundException {
        this(new File(filename), charset);
    }

    public TextFileReader(String filename) throws FileNotFoundException {
        this(filename, DEFAULT_CHARSET);
    }

    public int processLines(ILineProcessor lineProcessor) {
        boolean goOn = true;
        int counter = 0;
        BufferedReader bufferedReader = new BufferedReader(this);
        try {
            String line;
            while (goOn && bufferedReader.ready() && (line = bufferedReader.readLine()) != null) {
                goOn = lineProcessor.processLine(line, ++counter);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return counter;
    }

    public void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void closeUnchecked() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

