/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.pfsw.bif.configuration.IConfigSettings;
import org.pfsw.bif.facet.IReadOnlyNamedValues;
import org.pfsw.bif.text.IStringFilter;
import org.pfsw.bif.text.IStringPair;
import org.pfsw.bif.text.IStringRepresentation;
import org.pfsw.text.CollatorComparator;
import org.pfsw.text.ReverseComparator;
import org.pfsw.text.StringExaminer;
import org.pfsw.text.StringPair;
import org.pfsw.text.StringPattern;

public class StringUtil {
    public static final StringUtil SU = new StringUtil();
    public static final char CH_SPACE = ' ';
    public static final char CH_NEWLINE = '\n';
    public static final char CH_CR = '\r';
    public static final char CH_TAB = '\t';
    public static final String STR_SPACE = " ";
    public static final String STR_NEWLINE = "\n";
    public static final String STR_CR = "\r";
    public static final String STR_TAB = "\t";
    public static final String STR_PACKAGE_SEPARATOR = ".";
    public static final String STR_INNER_CLASS_SEPARATOR = "$";
    public static final String NULL_STRING = "\u0000";
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final IStringPair DELIMITER_QUOTE = new StringPair("\"");
    public static final IStringPair DELIMITER_APOS = new StringPair("'");
    public static final IStringPair[] DEFAULT_TEXT_DELIMITERS = new IStringPair[]{DELIMITER_QUOTE, DELIMITER_APOS};
    private static final String WORD_DELIM = " \t\n\r";
    private static final String DEFAULT_STRING_SEPARATOR = ",";
    private static final int NOT_FOUND = -1;
    private static final boolean DEBUG = "true".equals(System.getProperty("org.pfsw.text.debug", "false"));

    public static StringUtil current() {
        return SU;
    }

    protected StringUtil() {
    }

    public void addAll(Collection<String> collection, String ... strings) {
        this.addAll(collection, strings, false);
    }

    public void addAllNew(Collection<String> collection, String ... strings) {
        this.addAll(collection, strings, true);
    }

    public String replaceAll(String sourceStr, String oldSubStr, String newSubStr) {
        String part = null;
        StringBuffer result = null;
        int index = -1;
        int subLen = 0;
        result = new StringBuffer(sourceStr.length());
        subLen = oldSubStr.length();
        part = sourceStr;
        while (part.length() > 0 && subLen > 0) {
            index = part.indexOf(oldSubStr);
            if (index >= 0) {
                result.append(part.substring(0, index));
                result.append(newSubStr);
                part = part.substring(index + subLen);
                continue;
            }
            result.append(part);
            part = EMPTY_STRING;
        }
        return result.toString();
    }

    public String replaceEach(String sourceStr, String oldChars, String newChars) {
        if (this.isNullOrEmpty(sourceStr) || this.isNullOrEmpty(oldChars) || this.isNullOrEmpty(newChars)) {
            return sourceStr;
        }
        char[] destArray = new char[sourceStr.length()];
        char[] srcChars = sourceStr.toCharArray();
        for (int i = 0; i < srcChars.length; ++i) {
            char ch = srcChars[i];
            int index = oldChars.indexOf(ch);
            if (index >= 0 && index < newChars.length()) {
                ch = newChars.charAt(index);
            }
            destArray[i] = ch;
        }
        return new String(destArray);
    }

    public int count(String sourceStr, String subStr) {
        String part = null;
        int counter = 0;
        int index = 0;
        int subLen = 0;
        subLen = subStr.length();
        part = sourceStr;
        while (part.length() > 0 && subLen > 0) {
            index = part.indexOf(subStr);
            if (index >= 0) {
                ++counter;
                part = part.substring(index + subLen);
                continue;
            }
            part = EMPTY_STRING;
        }
        return counter;
    }

    public String repeat(char ch, int count) {
        StringBuffer buffer = null;
        buffer = new StringBuffer(count);
        for (int i = 1; i <= count; ++i) {
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public String[] words(String text) {
        return this.parts(text, WORD_DELIM);
    }

    public String[] split(String string, String separator) {
        if (string == null) {
            return null;
        }
        if (this.isNullOrEmpty(separator)) {
            throw new IllegalArgumentException("The separator must not be null or empty!");
        }
        String remainingString = string;
        ArrayList<String> elements = new ArrayList<String>();
        int sepIndex = remainingString.indexOf(separator);
        while (sepIndex >= 0) {
            int startPos;
            if (sepIndex > 0) {
                String str = remainingString.substring(0, sepIndex);
                elements.add(str);
            }
            if ((startPos = sepIndex + separator.length()) < remainingString.length()) {
                remainingString = remainingString.substring(startPos);
                sepIndex = remainingString.indexOf(separator);
                continue;
            }
            remainingString = EMPTY_STRING;
            sepIndex = -1;
        }
        if (remainingString.length() > 0) {
            elements.add(remainingString);
        }
        return this.asStrings(elements);
    }

    public String[] trimmedParts(String text, String separators) {
        return this.asStrings(this.trimmedSplit(text, separators));
    }

    public List<String> trimmedSplit(String text, String separators) {
        String[] result = this.parts(text, separators);
        if (result == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(result.length);
        for (int i = 0; i < result.length; ++i) {
            String str = result[i].trim();
            if (str.length() <= 0) continue;
            list.add(str);
        }
        return list;
    }

    public String[] parts(String text, String separators) {
        return this.parts(text, separators, false);
    }

    public String[] parts(String text, String separators, char quoteChar) {
        return this.quotedParts(text, separators, new char[]{quoteChar}, false);
    }

    public String[] parts(String text, String separators, char[] quoteChars) {
        return this.quotedParts(text, separators, quoteChars, false);
    }

    public String[] parts(String text, String separators, IStringPair[] quotePairs) {
        return this.quotedParts(text, separators, quotePairs, false);
    }

    public String[] allParts(String text, String separators) {
        return this.parts(text, separators, true);
    }

    public String[] allParts(String text, String separators, char quoteChar) {
        return this.quotedParts(text, separators, new char[]{quoteChar}, true);
    }

    public String[] allParts(String text, String separators, char[] quoteChars) {
        return this.quotedParts(text, separators, quoteChars, true);
    }

    public String[] substrings(String text, String separator) {
        return this.substrings(text, separator, false);
    }

    public String[] allSubstrings(String text, String separator) {
        return this.substrings(text, separator, true);
    }

    public String getDelimitedSubstring(String text, IStringPair ... delimiters) {
        int start = Integer.MAX_VALUE;
        int stop = 0;
        int delimiterLength = 0;
        String subStr = EMPTY_STRING;
        if (text != null && delimiters != null) {
            for (int i = 0; i < delimiters.length; ++i) {
                String endDelimiter;
                int stopIndex;
                String startDelimiter = delimiters[i].getString1();
                int startIndex = text.indexOf(startDelimiter);
                if (startIndex < 0 || startIndex >= start || (stopIndex = text.indexOf(endDelimiter = delimiters[i].getString2(), startIndex + startDelimiter.length())) <= startIndex) continue;
                start = startIndex;
                stop = stopIndex;
                delimiterLength = startDelimiter.length();
            }
            if (delimiterLength > 0 && stop > start) {
                subStr = text.substring(start + delimiterLength, stop);
            }
        }
        return subStr;
    }

    public String getDelimitedSubstring(String text, IStringPair delimiter) {
        return this.getDelimitedSubstring(text, new IStringPair[]{delimiter});
    }

    public String getDelimitedSubstring(String text, String startDelimiter, String endDelimiter) {
        return this.getDelimitedSubstring(text, (IStringPair)new StringPair(startDelimiter, endDelimiter));
    }

    public String getDelimitedSubstring(String text, String delimiter) {
        return this.getDelimitedSubstring(text, delimiter, delimiter);
    }

    public String getString(String text) {
        return this.getString(text, DEFAULT_TEXT_DELIMITERS);
    }

    public String getString(String text, IStringPair delimiter) {
        return this.getString(text, new IStringPair[]{delimiter});
    }

    public String getString(String text, IStringPair[] delimiters) {
        if (this.isNullOrBlank(text)) {
            return EMPTY_STRING;
        }
        String value = text.trim();
        for (int i = 0; i < delimiters.length; ++i) {
            if (!value.startsWith(delimiters[i].getString1()) || !value.endsWith(delimiters[i].getString2())) continue;
            return this.getDelimitedSubstring(value, delimiters[i]);
        }
        return value;
    }

    public String stackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public String leftPadCh(String str, int len, char ch) {
        return this.padCh(str, len, ch, true);
    }

    public String leftPad(String str, int len) {
        return this.leftPadCh(str, len, ' ');
    }

    public String leftPadCh(int value, int len, char fillChar) {
        if (value < 0) {
            StringBuffer buffer = new StringBuffer(len);
            buffer.append('-');
            buffer.append(this.leftPadCh(Math.abs(value), len - 1, fillChar));
            return buffer.toString();
        }
        return this.leftPadCh(Integer.toString(value), len, fillChar);
    }

    public String leftPad(int value, int len) {
        return this.leftPadCh(value, len, '0');
    }

    public String leftPadCh(long value, int len, char fillChar) {
        if (value < 0L) {
            StringBuffer buffer = new StringBuffer(len);
            buffer.append('-');
            buffer.append(this.leftPadCh(Math.abs(value), len - 1, fillChar));
            return buffer.toString();
        }
        return this.leftPadCh(Long.toString(value), len, fillChar);
    }

    public void leftPadCh(StringBuffer buffer, long value, int len, char fillChar) {
        if (value < 0L) {
            buffer.append('-');
            this.leftPadCh(buffer, Math.abs(value), len - 1, fillChar);
        } else {
            this.padCh(buffer, Long.toString(value), len, fillChar, true);
        }
    }

    public String leftPad(long value, int len) {
        return this.leftPadCh(value, len, '0');
    }

    public String rightPadCh(String str, int len, char ch) {
        return this.padCh(str, len, ch, false);
    }

    public String rightPad(String str, int len) {
        return this.rightPadCh(str, len, ' ');
    }

    public String rightPadCh(int value, int len, char fillChar) {
        return this.rightPadCh(Integer.toString(value), len, fillChar);
    }

    public String rightPad(int value, int len) {
        return this.rightPadCh(value, len, ' ');
    }

    public String rightPadCh(long value, int len, char fillChar) {
        return this.rightPadCh(Long.toString(value), len, fillChar);
    }

    public String rightPad(long value, int len) {
        return this.rightPadCh(value, len, ' ');
    }

    public String centerCh(String str, int len, char ch) {
        String buffer = null;
        int missing = len - str.length();
        int half = 0;
        if (missing <= 0) {
            return str;
        }
        half = missing / 2;
        buffer = this.rightPadCh(str, len - half, ch);
        return this.leftPadCh(buffer, len, ch);
    }

    public String center(String str, int len) {
        return this.centerCh(str, len, ' ');
    }

    public String[] append(String[] strings, String string) {
        String[] appStr = new String[]{string};
        return this.append(strings, appStr);
    }

    public String[] append(String[] strings, String[] appendStrings) {
        String[] newStrings = null;
        if (strings == null) {
            return appendStrings;
        }
        if (appendStrings == null) {
            return strings;
        }
        newStrings = new String[strings.length + appendStrings.length];
        System.arraycopy(strings, 0, newStrings, 0, strings.length);
        System.arraycopy(appendStrings, 0, newStrings, strings.length, appendStrings.length);
        return newStrings;
    }

    public String[] appendIfNotThere(String[] strings, String appendString) {
        if (this.contains(strings, appendString)) {
            return strings;
        }
        return this.append(strings, appendString);
    }

    public String[] appendIfNotThere(String[] strings, String[] appendStrings) {
        String[] newStrings = strings;
        if (appendStrings == null) {
            return newStrings;
        }
        for (int i = 0; i < appendStrings.length; ++i) {
            newStrings = this.appendIfNotThere(newStrings, appendStrings[i]);
        }
        return newStrings;
    }

    public String[] remove(String[] strings, String[] removeStrings) {
        if (strings == null || removeStrings == null || strings.length == 0 || removeStrings.length == 0) {
            return strings;
        }
        return this.removeFromStringArray(strings, removeStrings);
    }

    public String[] remove(String[] strings, String removeString) {
        String[] removeStrings = new String[]{removeString};
        return this.remove(strings, removeStrings);
    }

    public String[] removeNull(String[] strings) {
        if (strings == null) {
            return strings;
        }
        return this.removeFromStringArray(strings, null);
    }

    public String join(String separator, String ... elements) {
        return this.asString(this.removeNull(elements), separator);
    }

    public String concat(String ... elements) {
        return this.join(DEFAULT_STRING_SEPARATOR, elements);
    }

    public String asString(Object object) {
        if (object == null) {
            return NULL_STRING;
        }
        if (object instanceof IStringRepresentation) {
            return ((IStringRepresentation)object).asString();
        }
        return object.toString();
    }

    public String asString(String[] strings) {
        return this.asString(strings, DEFAULT_STRING_SEPARATOR);
    }

    public String asString(String[] strings, String separator) {
        StringBuffer buffer = null;
        boolean first = true;
        if (strings == null) {
            return null;
        }
        String stringSeparator = separator == null ? DEFAULT_STRING_SEPARATOR : separator;
        buffer = new StringBuffer(strings.length * 20);
        if (strings.length > 0) {
            for (String string : strings) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(stringSeparator);
                }
                if (string == null) continue;
                buffer.append(string);
            }
        }
        return buffer.toString();
    }

    public String asString(Collection<String> strings) {
        return this.asString(strings, DEFAULT_STRING_SEPARATOR);
    }

    public String asString(Collection<String> strings, String separator) {
        StringBuilder buffer = null;
        if (strings == null) {
            return EMPTY_STRING;
        }
        buffer = new StringBuilder(strings.size() * 20);
        if (strings.size() > 0) {
            for (String string : strings) {
                if (buffer.length() > 0) {
                    buffer.append(separator);
                }
                buffer.append(string);
            }
        }
        return buffer.toString();
    }

    public String asStringEnclosed(Collection<String> strings, String prefix, String suffix, String separator) {
        if (strings == null) {
            return EMPTY_STRING;
        }
        StringBuilder buffer = new StringBuilder(strings.size() * 20);
        if (strings.size() > 0) {
            for (String string : strings) {
                if (buffer.length() > 0) {
                    buffer.append(separator);
                }
                buffer.append(prefix).append(string).append(suffix);
            }
        }
        return buffer.toString();
    }

    public String asSortedString(String[] strings) {
        return this.asSortedString(strings, DEFAULT_STRING_SEPARATOR);
    }

    public String asSortedString(String[] strings, String separator) {
        return this.asSortedString(strings, separator, true);
    }

    public String asSortedString(String[] strings, String separator, boolean ascending) {
        Comparator<String> comparator = ascending ? new CollatorComparator() : new ReverseComparator<String>(new CollatorComparator());
        return this.asSortedString(strings, separator, comparator);
    }

    public String asSortedString(String[] strings, String separator, Comparator<String> comparator) {
        if (strings == null) {
            return null;
        }
        String[] array = this.copy(strings);
        Arrays.sort(array, comparator);
        return this.asString(array, separator);
    }

    public String[] asStrings(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public String[] asStrings(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(50);
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return this.asStrings(list);
    }

    public String asString(Map map, String elementSeparator, String keyValueSeparator) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return EMPTY_STRING;
        }
        String elemSep = elementSeparator == null ? DEFAULT_STRING_SEPARATOR : elementSeparator;
        String keyValSep = keyValueSeparator == null ? "=" : keyValueSeparator;
        StringBuffer buffer = new StringBuffer(map.size() * 30);
        for (Map.Entry entry : map.entrySet()) {
            if (buffer.length() > 0) {
                buffer.append(elemSep);
            }
            buffer.append(entry.getKey().toString());
            buffer.append(keyValSep);
            buffer.append(entry.getValue().toString());
        }
        return buffer.toString();
    }

    public String asString(Map<?, ?> map, String elementSeparator) {
        return this.asString(map, elementSeparator, null);
    }

    public String asString(Map<?, ?> map) {
        return this.asString(map, null, null);
    }

    public int indexOf(String[] strArray, StringPattern pattern) {
        if (strArray == null || strArray.length == 0) {
            return -1;
        }
        boolean found = false;
        for (int i = 0; i < strArray.length; ++i) {
            if (strArray[i] == null) {
                if (pattern == null) {
                    found = true;
                }
            } else if (pattern != null) {
                found = pattern.matches(strArray[i]);
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String[] strArray, String searchStr) {
        return this.indexOfString(strArray, searchStr, false);
    }

    public int indexOfIgnoreCase(String[] strArray, String searchStr) {
        return this.indexOfString(strArray, searchStr, true);
    }

    public int indexOfString(String[] strArray, String searchStr, boolean ignoreCase) {
        if (strArray == null || strArray.length == 0) {
            return -1;
        }
        boolean found = false;
        for (int i = 0; i < strArray.length; ++i) {
            if (strArray[i] == null) {
                if (searchStr == null) {
                    found = true;
                }
            } else {
                boolean bl = found = ignoreCase ? strArray[i].equalsIgnoreCase(searchStr) : strArray[i].equals(searchStr);
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(char[] charArray, char ch, boolean ignoreCase) {
        char upper_ch = Character.toUpperCase(ch);
        for (int i = 0; i < charArray.length; ++i) {
            if (!(ignoreCase ? Character.toUpperCase(charArray[i]) == upper_ch : charArray[i] == ch)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(String str, char ch) {
        if (str == null) {
            return false;
        }
        return str.indexOf(ch) >= 0;
    }

    public boolean contains(String[] strArray, String searchStr, boolean ignoreCase) {
        if (ignoreCase) {
            return this.containsIgnoreCase(strArray, searchStr);
        }
        return this.contains(strArray, searchStr);
    }

    public boolean contains(String[] strArray, StringPattern pattern) {
        return this.indexOf(strArray, pattern) >= 0;
    }

    public boolean contains(String[] strArray, String searchStr) {
        return this.indexOf(strArray, searchStr) >= 0;
    }

    public boolean containsIgnoreCase(String[] strArray, String searchStr) {
        return this.indexOfIgnoreCase(strArray, searchStr) >= 0;
    }

    public boolean containsAll(String[] strArray, String ... strings) {
        return this.containsAll(strArray, false, strings);
    }

    public boolean containsAllIgnoreCase(String[] strArray, String ... strings) {
        return this.containsAll(strArray, true, strings);
    }

    public boolean containsAll(String[] strArray, boolean ignoreCase, String ... strings) {
        for (String string : strings) {
            if (this.contains(strArray, string, ignoreCase)) continue;
            return false;
        }
        return true;
    }

    public String[] copyFrom(String[] from, int start) {
        if (from == null) {
            return null;
        }
        return this.copyFrom(from, start, from.length - 1);
    }

    public String[] copyFrom(String[] from, int start, int end) {
        int count;
        int stop = end;
        if (from == null) {
            return null;
        }
        if (stop > from.length - 1) {
            stop = from.length - 1;
        }
        if ((count = stop - start + 1) < 1) {
            return new String[0];
        }
        String[] result = new String[count];
        System.arraycopy(from, start, result, 0, count);
        return result;
    }

    public String[] copy(String[] strings, IStringFilter filter) {
        ArrayList result = this.copyStrings(ArrayList.class, strings, filter, true);
        return this.asStrings(result);
    }

    public String[] copy(String ... strings) {
        if (strings == null) {
            return null;
        }
        String[] newStrings = new String[strings.length];
        System.arraycopy(strings, 0, newStrings, 0, strings.length);
        return newStrings;
    }

    public String[] copyWithout(String[] strings, IStringFilter filter) {
        List result = this.copyStrings(ArrayList.class, strings, filter, false);
        return this.asStrings(result);
    }

    public Collection<String> copy(Collection<String> strings, IStringFilter filter) {
        return this.copyStrings(strings.getClass(), this.asStrings(strings), filter, true);
    }

    public Collection<String> copyWithout(Collection<String> strings, IStringFilter filter) {
        return this.copyStrings(strings.getClass(), this.asStrings(strings), filter, false);
    }

    public String cutTail(String text, String separator) {
        if (text == null || separator == null) {
            return text;
        }
        int index = text.lastIndexOf(separator);
        if (index < 0) {
            return text;
        }
        return text.substring(0, index);
    }

    public String cutHead(String text, String separator) {
        if (text == null || separator == null || separator.length() == 0) {
            return text;
        }
        int index = text.lastIndexOf(separator);
        if (index < 0) {
            return text;
        }
        return text.substring(index + separator.length());
    }

    public String[] splitNameValue(String str, String separator) {
        IStringPair pair = this.splitStringPair(str, separator);
        return pair.asArray();
    }

    public IStringPair splitStringPair(String str, String separator) {
        StringPair result = new StringPair(EMPTY_STRING);
        if (str != null) {
            int index = str.indexOf(separator);
            if (index >= 0) {
                result.setString1(str.substring(0, index));
                result.setString2(str.substring(index + separator.length()));
            } else {
                result.setString1(str);
            }
        }
        return result;
    }

    public String prefix(String str, String separator) {
        return this.prefix(str, separator, true);
    }

    public String suffix(String str, String separator) {
        return this.suffix(str, separator, true);
    }

    public String upTo(String str, String separator) {
        return this.prefix(str, separator, false);
    }

    public String startingFrom(String str, String separator) {
        return this.suffix(str, separator, false);
    }

    public String trim(String str, String ... unwanted) {
        return this.trimLoop(100000, str, unwanted);
    }

    public String trimOnce(String str, String ... unwanted) {
        return this.trimLoop(1, str, unwanted);
    }

    public String reverse(String str) {
        if (str == null) {
            return null;
        }
        char[] newStr = new char[str.length()];
        StringCharacterIterator iterator = new StringCharacterIterator(str);
        int i = 0;
        char ch = iterator.last();
        while (ch != '\uffff') {
            newStr[i] = ch;
            ++i;
            ch = iterator.previous();
        }
        return new String(newStr);
    }

    public Map<String, String> toMap(String str, String elementSeparator, String keyValueSeparator, Map<String, String> map) {
        if (str == null) {
            return map;
        }
        Hashtable<String, String> result = map == null ? new Hashtable<String, String>() : map;
        String elemSep = elementSeparator == null ? DEFAULT_STRING_SEPARATOR : elementSeparator;
        String kvSep = keyValueSeparator == null ? "=" : keyValueSeparator;
        String[] assignments = this.parts(str, elemSep);
        for (int i = 0; i < assignments.length; ++i) {
            String[] nameValue = this.splitNameValue(assignments[i], kvSep);
            nameValue[0] = nameValue[0].trim();
            nameValue[1] = nameValue[1].trim();
            if (nameValue[0].length() <= 0) continue;
            result.put(nameValue[0], nameValue[1]);
        }
        return result;
    }

    public Map<String, String> asMap(String[][] stringPairArray) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String[] stringPair : stringPairArray) {
            if (stringPair.length != 2) {
                throw new IllegalArgumentException("The provided string array does not contain exactly 2 elements!");
            }
            map.put(stringPair[0], stringPair[1]);
        }
        return map;
    }

    public Map<String, String> asMap(String str) {
        return this.toMap(str, null, null, null);
    }

    public Map<String, String> asMap(String str, String elementSeparator) {
        return this.toMap(str, elementSeparator, null, null);
    }

    public Map<String, String> asMap(String str, String elementSeparator, String keyValueSeparator) {
        return this.toMap(str, elementSeparator, keyValueSeparator, null);
    }

    public Map<String, String> toMap(String str, String elementSeparator, Map<String, String> map) {
        return this.toMap(str, elementSeparator, null, map);
    }

    public Map<String, String> toMap(String str, Map<String, String> map) {
        return this.toMap(str, null, null, map);
    }

    public Properties asProperties(String str) {
        return this.toProperties(str, null);
    }

    public Properties toProperties(String str, Properties properties) {
        Properties props = properties == null ? new Properties() : properties;
        Map<String, String> map = this.toMap(str, null, null, null);
        this.copyMapToProperties(map, props);
        return props;
    }

    public void copyMapToProperties(Map<String, String> map, Properties properties) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public List<String> asList(String ... strings) {
        ArrayList<String> list = new ArrayList<String>(strings.length);
        this.addAll(list, strings);
        return list;
    }

    public IReadOnlyNamedValues<String> asReadOnlyNamedValues(Properties properties) {
        return this.asConfigSettings(properties);
    }

    public <T> IReadOnlyNamedValues<T> asReadOnlyNamedValues(final Map<String, T> map) {
        return new IReadOnlyNamedValues<T>(){

            public Collection<String> getNames() {
                return map.keySet();
            }

            public T getValue(String name) {
                return map.get(name);
            }

            public boolean isEmpty() {
                return map.isEmpty();
            }
        };
    }

    public IConfigSettings asConfigSettings(final Map<String, String> map) {
        return new IConfigSettings(){

            public Collection<String> getNames() {
                return map.keySet();
            }

            public String getValue(String name) {
                return (String)map.get(name);
            }

            public boolean isEmpty() {
                return map.isEmpty();
            }
        };
    }

    public IConfigSettings asConfigSettings(final Properties properties) {
        return new IConfigSettings(){

            public Collection<String> getNames() {
                return properties.stringPropertyNames();
            }

            public String getValue(String name) {
                return properties.getProperty(name);
            }

            public boolean isEmpty() {
                return properties.isEmpty();
            }
        };
    }

    public IConfigSettings asConfigSettings(String str) {
        Map<String, String> map = this.asMap(str);
        return this.asConfigSettings(map);
    }

    public IConfigSettings asConfigSettings(String str, String elementSeparator, String keyValueSeparator) {
        Map<String, String> map = this.asMap(str, elementSeparator, keyValueSeparator);
        return this.asConfigSettings(map);
    }

    public boolean isAnyNullOrBlank(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String string : strings) {
            if (!this.isNullOrBlank(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isNoneNullOrBlank(String ... strings) {
        return !this.isAnyNullOrBlank(strings);
    }

    public boolean isNullOrEmpty(String[] strings) {
        return strings == null || strings.length == 0;
    }

    public boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public boolean isNullOrBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public boolean notNullOrEmpty(String[] strings) {
        return !this.isNullOrEmpty(strings);
    }

    public boolean notNullOrEmpty(String str) {
        return !this.isNullOrEmpty(str);
    }

    public boolean notNullOrBlank(String str) {
        return !this.isNullOrBlank(str);
    }

    public String asString(char ch) {
        char[] chars = new char[]{ch};
        return new String(chars);
    }

    public boolean areEqual(String[] strings1, String[] strings2) {
        return this.equals(strings1, strings2, false);
    }

    public boolean areEqualIgnoreCase(String[] strings1, String[] strings2) {
        return this.equals(strings1, strings2, true);
    }

    public String setFileNameExtension(String filename, String extension, boolean replace) {
        if (filename == null || this.isNullOrBlank(extension)) {
            return filename;
        }
        StringBuffer buffer = new StringBuffer(filename.length() + extension.length() + 1);
        if (filename.indexOf(46) < 0) {
            buffer.append(filename);
        } else if (replace) {
            buffer.append(this.cutTail(filename, STR_PACKAGE_SEPARATOR));
        } else {
            buffer.append(filename);
        }
        buffer.append('.');
        buffer.append(extension);
        return buffer.toString();
    }

    public void toUpperCase(String[] strings) {
        if (strings == null) {
            return;
        }
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].toUpperCase();
        }
    }

    public void toLowerCase(String[] strings) {
        if (strings == null) {
            return;
        }
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].toLowerCase();
        }
    }

    public String[] copyUpperCase(String[] strings) {
        String[] copy = this.copy(strings);
        this.toUpperCase(copy);
        return copy;
    }

    public String[] copyLowerCase(String[] strings) {
        String[] copy = this.copy(strings);
        this.toLowerCase(copy);
        return copy;
    }

    public String getPackageName(String qualifiedClassName) {
        if (qualifiedClassName.indexOf(STR_PACKAGE_SEPARATOR) >= 0) {
            return this.cutTail(qualifiedClassName, STR_PACKAGE_SEPARATOR);
        }
        return EMPTY_STRING;
    }

    public String getUnqualifiedClassName(String qualifiedClassName) {
        return this.cutHead(qualifiedClassName, STR_PACKAGE_SEPARATOR);
    }

    public String translate(String text, String replacementChars, String charsToReplace) {
        String replChars = replacementChars;
        if (replChars.length() > charsToReplace.length()) {
            replChars = replChars.substring(0, charsToReplace.length());
        } else if (replChars.length() < charsToReplace.length()) {
            replChars = this.rightPadCh(replChars, charsToReplace.length(), ' ');
        }
        StringBuffer buffer = new StringBuffer(text.length());
        char[] textChars = text.toCharArray();
        for (int i = 0; i < textChars.length; ++i) {
            int index = charsToReplace.indexOf(textChars[i]);
            if (index < 0) {
                buffer.append(textChars[i]);
                continue;
            }
            buffer.append(replChars.charAt(index));
        }
        return buffer.toString();
    }

    public boolean isTrue(String string) {
        if (string == null) {
            return false;
        }
        return "true".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "1".equals(string);
    }

    public boolean isFalse(String string) {
        if (string == null) {
            return false;
        }
        return "false".equalsIgnoreCase(string) || "off".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string) || "0".equals(string);
    }

    public boolean isInteger(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0 || value.length() > 11) {
            return false;
        }
        char[] chars = value.toCharArray();
        if (chars[0] != '-' && !Character.isDigit(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) continue;
            return false;
        }
        if (value.length() > 9) {
            try {
                Integer.parseInt(value);
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    public boolean isPositiveInteger(String value) {
        if (this.isInteger(value)) {
            return this.asInteger(value, -1) > 0;
        }
        return false;
    }

    public boolean isZeroOrPositiveInteger(String value) {
        if (this.isInteger(value)) {
            return this.asInteger(value, -1) >= 0;
        }
        return false;
    }

    public boolean isLong(String value) {
        if (value == null) {
            return false;
        }
        if (value.length() == 0 || value.length() > 20) {
            return false;
        }
        char[] chars = value.toCharArray();
        if (chars[0] != '-' && !Character.isDigit(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isDigit(chars[i])) continue;
            return false;
        }
        if (value.length() > 18) {
            try {
                Long.parseLong(value);
            }
            catch (Exception e) {
                if (DEBUG) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    public boolean isPositiveLong(String value) {
        if (this.isLong(value)) {
            return this.asLong(value, -1L) > 0L;
        }
        return false;
    }

    public boolean isZeroOrPositiveLong(String value) {
        if (this.isLong(value)) {
            return this.asLong(value, -1L) >= 0L;
        }
        return false;
    }

    public int asInteger(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return defaultValue;
        }
    }

    public long asLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return defaultValue;
        }
    }

    public byte[] hexToBytes(String hex) {
        int len = hex.length() / 2;
        byte[] bytes = new byte[len];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(pos, pos + 2), 16);
            pos += 2;
        }
        return bytes;
    }

    public byte[] hexToBytes(String hex, String separator) {
        if (separator == null) {
            return this.hexToBytes(hex);
        }
        String[] hexElements = this.split(hex, separator);
        return this.hexToBytes(this.asString(hexElements, EMPTY_STRING));
    }

    public String bytesToHex(byte ... bytes) {
        return this.bytesToHex(null, bytes);
    }

    public String bytesToHex(String separator, byte ... bytes) {
        if (bytes == null) {
            return null;
        }
        String sep = separator == null ? EMPTY_STRING : separator;
        StringBuffer buffer = new StringBuffer(bytes.length * (2 + sep.length()));
        for (byte b : bytes) {
            if (buffer.length() > 0) {
                buffer.append(sep);
            }
            buffer.append(String.format("%X", b));
        }
        return buffer.toString();
    }

    public String withLeadingChar(String string, char ch) {
        String oneChar = this.asString(ch);
        if (string.startsWith(oneChar)) {
            return string;
        }
        return oneChar + string;
    }

    public String withTrailingChar(String string, char ch) {
        String oneChar = this.asString(ch);
        if (string.endsWith(oneChar)) {
            return string;
        }
        return string + oneChar;
    }

    public String withoutLeadingChar(String string, char ch) {
        String oneChar = this.asString(ch);
        String result = string;
        while (result.startsWith(oneChar)) {
            result = result.substring(1);
        }
        return result;
    }

    public String withoutTrailingChar(String string, char ch) {
        String oneChar = this.asString(ch);
        String result = string;
        while (result.endsWith(oneChar)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String truncate(String string, int len) {
        if (string == null) {
            return null;
        }
        if (len <= 0) {
            return EMPTY_STRING;
        }
        if (string.length() <= len) {
            return string;
        }
        return string.substring(0, len);
    }

    public String removeAllChars(String string, String charsToRemove) {
        if (string == null) {
            return null;
        }
        if (this.isNullOrEmpty(charsToRemove)) {
            return string;
        }
        return this.removeCharsFromString(string, charsToRemove);
    }

    public String removeChar(String string, char charToRemove) {
        if (string == null) {
            return null;
        }
        return this.removeCharsFromString(string, String.valueOf(charToRemove));
    }

    protected String trimSeparator(String input, String separator) {
        String text = input;
        int sepLen = separator.length();
        while (text.startsWith(separator)) {
            text = text.substring(separator.length());
        }
        while (text.endsWith(separator)) {
            text = text.substring(0, text.length() - sepLen);
        }
        return text;
    }

    protected String[] parts(String text, String delimiters, boolean all) {
        ArrayList<String> result = null;
        StringTokenizer tokenizer = null;
        if (text == null) {
            return null;
        }
        if (this.isNullOrEmpty(delimiters)) {
            String[] resultArray = new String[]{text};
            return resultArray;
        }
        if (text.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        result = new ArrayList<String>();
        tokenizer = new StringTokenizer(text, delimiters, all);
        if (all) {
            this.collectParts(result, tokenizer, delimiters);
        } else {
            this.collectParts(result, tokenizer);
        }
        return this.asStrings(result);
    }

    protected void collectParts(List<String> list, StringTokenizer tokenizer) {
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
    }

    protected void collectParts(List<String> list, StringTokenizer tokenizer, String delimiter) {
        boolean lastWasDelimiter = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (delimiter.indexOf(token) >= 0) {
                if (lastWasDelimiter) {
                    list.add(EMPTY_STRING);
                }
                lastWasDelimiter = true;
                continue;
            }
            list.add(token);
            lastWasDelimiter = false;
        }
    }

    protected String[] substrings(String text, String separator, boolean all) {
        int index = 0;
        int start = 0;
        int sepLen = 0;
        int strLen = 0;
        String str = text;
        ArrayList<String> strings = new ArrayList<String>();
        if (text == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (separator == null || separator.length() == 0) {
            if (text.length() == 0) {
                return EMPTY_STRING_ARRAY;
            }
            String[] resultArray = new String[]{text};
            return resultArray;
        }
        if (!all) {
            str = this.trimSeparator(text, separator);
        }
        if ((strLen = str.length()) > 0) {
            sepLen = separator.length();
            index = str.indexOf(separator, start);
            while (index >= 0) {
                if (all) {
                    if (index > 0) {
                        strings.add(str.substring(start, index));
                    }
                } else if (index >= start + sepLen) {
                    strings.add(str.substring(start, index));
                }
                start = index + sepLen;
                index = str.indexOf(separator, start);
            }
            if (start < strLen) {
                strings.add(str.substring(start));
            }
        }
        return this.asStrings(strings);
    }

    protected String padCh(String str, int len, char ch, boolean left) {
        StringBuffer buffer = null;
        int missing = len - str.length();
        if (missing <= 0) {
            return str;
        }
        buffer = new StringBuffer(len);
        this.padCh(buffer, str, len, ch, left);
        return buffer.toString();
    }

    protected void padCh(StringBuffer buffer, String str, int len, char ch, boolean left) {
        int missing = len - str.length();
        if (missing <= 0) {
            buffer.append(str);
            return;
        }
        if (!left) {
            buffer.append(str);
        }
        for (int i = 1; i <= missing; ++i) {
            buffer.append(ch);
        }
        if (left) {
            buffer.append(str);
        }
    }

    protected String prefix(String str, String separator, boolean returnNull) {
        if (str == null) {
            return null;
        }
        if (separator == null) {
            return returnNull ? null : str;
        }
        int index = str.indexOf(separator);
        if (index >= 0) {
            return str.substring(0, index);
        }
        return returnNull ? null : str;
    }

    protected String suffix(String str, String separator, boolean returnNull) {
        if (str == null) {
            return null;
        }
        if (separator == null) {
            return returnNull ? null : str;
        }
        int index = str.indexOf(separator);
        if (index >= 0) {
            return str.substring(index + separator.length());
        }
        return returnNull ? null : str;
    }

    protected String[] removeFromStringArray(String[] strings, String[] removeStrings) {
        ArrayList<String> list = new ArrayList<String>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            boolean remains;
            if (removeStrings == null) {
                remains = strings[i] != null;
            } else {
                boolean bl = remains = !this.contains(removeStrings, strings[i]);
            }
            if (!remains) continue;
            list.add(strings[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    protected String[] quotedParts(String str, String separators, char[] quoteChars, boolean all) {
        String[] parts;
        int bufferSize = 40;
        char quoteChar = '\ufffe';
        boolean insideQuotation = false;
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (this.isNullOrEmpty(separators)) {
            StringPair[] delimiters = new StringPair[quoteChars.length];
            for (int i = 0; i < delimiters.length; ++i) {
                delimiters[i] = new StringPair(this.asString(quoteChars[i]));
            }
            parts = new String[]{this.getDelimitedSubstring(str, (IStringPair[])delimiters)};
        } else {
            ArrayList<String> partList = new ArrayList<String>(30);
            StringExaminer scanner = new StringExaminer(str);
            StringBuffer buffer = new StringBuffer(40);
            while (!scanner.atEnd()) {
                char ch = scanner.nextChar();
                if (insideQuotation) {
                    if (ch == quoteChar) {
                        insideQuotation = false;
                        continue;
                    }
                    buffer.append(ch);
                    continue;
                }
                if (this.indexOf(quoteChars, ch, false) >= 0) {
                    quoteChar = ch;
                    insideQuotation = true;
                    continue;
                }
                if (separators.indexOf(ch) >= 0) {
                    if (!all && buffer.length() <= 0) continue;
                    partList.add(buffer.toString());
                    buffer = new StringBuffer(40);
                    continue;
                }
                buffer.append(ch);
            }
            if (buffer.length() > 0) {
                partList.add(buffer.toString());
            }
            parts = this.asStrings(partList);
        }
        return parts;
    }

    protected String[] quotedParts(String str, String separators, IStringPair[] quotePairs, boolean all) {
        String[] parts;
        int bufferSize = 40;
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (this.isNullOrEmpty(separators)) {
            parts = new String[]{this.getDelimitedSubstring(str, quotePairs)};
        } else {
            ArrayList<String> partList = new ArrayList<String>(30);
            StringExaminer scanner = new StringExaminer(str);
            StringBuffer buffer = new StringBuffer(40);
            while (!scanner.atEnd()) {
                char ch = scanner.nextChar();
                IStringPair quotePair = this.findInString1(quotePairs, ch, false);
                if (quotePair != null) {
                    int pos = scanner.findPositionOf(quotePair.getString2());
                    if (pos >= 0) {
                        scanner.appendUpToPosition(buffer, pos);
                        scanner.skip(quotePair.getString2().length());
                        continue;
                    }
                    buffer.append(ch);
                    continue;
                }
                if (separators.indexOf(ch) >= 0) {
                    if (!all && buffer.length() <= 0) continue;
                    partList.add(buffer.toString());
                    buffer = new StringBuffer(40);
                    continue;
                }
                buffer.append(ch);
            }
            if (buffer.length() > 0) {
                partList.add(buffer.toString());
            }
            parts = this.asStrings(partList);
        }
        return parts;
    }

    protected IStringPair findInString1(IStringPair[] stringPairs, char ch, boolean ignoreCase) {
        char upper_ch = Character.toUpperCase(ch);
        for (int i = 0; i < stringPairs.length; ++i) {
            char compChar = stringPairs[i].getString1().charAt(0);
            if (!(ignoreCase ? (compChar = Character.toUpperCase(compChar)) == upper_ch : compChar == ch)) continue;
            return stringPairs[i];
        }
        return null;
    }

    protected <T extends Collection<String>> T copyStrings(Class<T> collClass, String[] strings, IStringFilter filter, boolean allMatching) {
        Collection result;
        try {
            result = (Collection)collClass.newInstance();
        }
        catch (InstantiationException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        catch (IllegalAccessException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        if (strings == null || filter == null && allMatching) {
            return (T)result;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (filter != null) {
                if (filter.matches(strings[i])) {
                    if (!allMatching) continue;
                    result.add(strings[i]);
                    continue;
                }
                if (allMatching) continue;
                result.add(strings[i]);
                continue;
            }
            if (allMatching) continue;
            result.add(strings[i]);
        }
        return (T)result;
    }

    protected boolean equals(String[] strings1, String[] strings2, boolean ignoreCase) {
        if (strings1 == strings2) {
            return true;
        }
        if (strings1 == null || strings2 == null) {
            return false;
        }
        if (strings1.length != strings2.length) {
            return false;
        }
        for (int i = 0; i < strings1.length; ++i) {
            boolean found = ignoreCase ? this.containsIgnoreCase(strings2, strings1[i]) : this.contains(strings2, strings1[i]);
            if (found) continue;
            return false;
        }
        return true;
    }

    protected void addAll(Collection<String> collection, String[] strings, boolean justNew) {
        if (collection == null || strings == null) {
            return;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) continue;
            if (justNew) {
                if (collection.contains(strings[i])) continue;
                collection.add(strings[i]);
                continue;
            }
            collection.add(strings[i]);
        }
    }

    protected String trimLoop(int maxLoop, String str, String[] unwanted) {
        boolean hasBeenChanged;
        int loopCount = 0;
        int startRemovals = 0;
        int endRemovals = 0;
        if (str == null) {
            return null;
        }
        if (this.isNullOrEmpty(unwanted)) {
            return str.trim();
        }
        String newStr = str;
        do {
            hasBeenChanged = false;
            for (String toBeRemoved : unwanted) {
                if (startRemovals < maxLoop && newStr.startsWith(toBeRemoved)) {
                    newStr = newStr.substring(toBeRemoved.length());
                    hasBeenChanged = true;
                    ++startRemovals;
                }
                if (endRemovals >= maxLoop || !newStr.endsWith(toBeRemoved)) continue;
                newStr = newStr.substring(0, newStr.length() - toBeRemoved.length());
                hasBeenChanged = true;
                ++endRemovals;
            }
        } while (hasBeenChanged && ++loopCount < maxLoop);
        return newStr;
    }

    protected String removeCharsFromString(String string, String charsToRemove) {
        StringBuilder buffer = new StringBuilder(string.length());
        for (char ch : string.toCharArray()) {
            if (this.contains(charsToRemove, ch)) continue;
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

