/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

public class StringScanner {
    public static final char END_REACHED = '\uffff';
    protected int length = 0;
    protected int position = 0;
    protected int pos_marker = 0;
    protected char[] buffer = null;

    public StringScanner(String stringToScan) {
        this.length = stringToScan.length();
        this.buffer = new char[this.length];
        stringToScan.getChars(0, this.length, this.buffer, 0);
    }

    public boolean endReached(char character) {
        return character == '\uffff';
    }

    public boolean endNotReached(char character) {
        return !this.endReached(character);
    }

    public String toString() {
        return new String(this.buffer);
    }

    public void skip(int count) {
        this.position += count;
        if (this.position < 0) {
            this.position = 0;
        }
    }

    public char peek() {
        return this.position < this.length() ? this.buffer[this.position] : (char)'\uffff';
    }

    public char nextChar() {
        char next = this.peek();
        if (this.endNotReached(next)) {
            this.skip(1);
        }
        return next;
    }

    public boolean atEnd() {
        return this.endReached(this.peek());
    }

    public boolean hasNext() {
        return !this.atEnd();
    }

    public char nextNoneWhitespaceChar() {
        char next = this.nextChar();
        while (this.endNotReached(next) && Character.isWhitespace(next)) {
            next = this.nextChar();
        }
        return next;
    }

    public int getPosition() {
        return this.position;
    }

    public void markPosition() {
        this.pos_marker = this.position;
    }

    public void restorePosition() {
        this.setPosition(this.pos_marker);
    }

    public int length() {
        return this.length;
    }

    protected void setPosition(int pos) {
        if (pos >= 0 && pos <= this.length()) {
            this.position = pos;
        }
    }
}

