/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.util.ArrayList;
import java.util.List;
import org.pfsw.bif.logic.BooleanOperation;
import org.pfsw.bif.text.IStringFilter;
import org.pfsw.text.AStringFilter;

public class StringFilterCollection
extends AStringFilter {
    public static final BooleanOperation DEFAULT_OPERATION = BooleanOperation.OR;
    private final List<IStringFilter> filterList = new ArrayList<IStringFilter>();
    private BooleanOperation operation = DEFAULT_OPERATION;

    public StringFilterCollection() {
    }

    public StringFilterCollection(BooleanOperation operation) {
        this.setOperation(operation);
    }

    public StringFilterCollection(IStringFilter ... filters) {
        this();
        this.addFilters(filters);
    }

    public StringFilterCollection(BooleanOperation operation, IStringFilter ... filters) {
        this(filters);
        this.setOperation(operation);
    }

    public boolean matches(String aString) {
        switch (this.getOperation()) {
            case OR: {
                return this.matchesAnyFilter(aString);
            }
            case AND: {
                return this.matchesAllFilters(aString);
            }
            case XOR: {
                return this.matchesOneFilter(aString);
            }
        }
        return false;
    }

    public void addFilters(IStringFilter ... filters) {
        if (filters != null) {
            for (IStringFilter stringFilter : filters) {
                this.getFilterList().add(stringFilter);
            }
        }
    }

    public int size() {
        return this.getFilterList().size();
    }

    public boolean isEmpty() {
        return this.getFilterList().isEmpty();
    }

    public void clear() {
        this.getFilterList().clear();
    }

    public BooleanOperation getOperation() {
        return this.operation;
    }

    public void setOperation(BooleanOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("operation must not be null!");
        }
        this.operation = operation;
    }

    public List<IStringFilter> asList() {
        return new ArrayList<IStringFilter>(this.getFilterList());
    }

    protected boolean matchesAnyFilter(String aString) {
        for (IStringFilter filter : this.getFilterList()) {
            if (!filter.matches(aString)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchesAllFilters(String aString) {
        for (IStringFilter filter : this.getFilterList()) {
            if (filter.matches(aString)) continue;
            return false;
        }
        return true;
    }

    protected boolean matchesOneFilter(String aString) {
        int counter = 0;
        for (IStringFilter filter : this.getFilterList()) {
            if (!filter.matches(aString) || ++counter <= 1) continue;
            return false;
        }
        return counter == 1;
    }

    protected List<IStringFilter> getFilterList() {
        return this.filterList;
    }
}

