/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.util.Collection;
import org.pfsw.text.AStringFilter;
import org.pfsw.text.StringUtil;

public class StringCollectionFilter
extends AStringFilter {
    private String[] internalStrings = null;
    private boolean unchanged = true;
    private boolean ignoreCase = true;

    public static StringCollectionFilter create(String ... strings) {
        return new StringCollectionFilter(strings);
    }

    public StringCollectionFilter(String[] strings) {
        this.setInternalStrings(strings);
    }

    public StringCollectionFilter(Collection<String> strings) {
        this.setInternalStrings(this.str().asStrings(strings));
    }

    public StringCollectionFilter(String strings, String separators) {
        this.setInternalStrings(this.str().parts(strings, separators));
    }

    public StringCollectionFilter(String strings) {
        this(strings, ",");
    }

    public boolean matches(String string) {
        if (string == null || this.getInternalStrings() == null) {
            return false;
        }
        boolean inArray = this.str().contains(this.getInternalStrings(), string, this.getIgnoreCase());
        return this.unchanged ? inArray : !inArray;
    }

    public void negate() {
        this.unchanged = !this.unchanged;
    }

    public boolean matchesIfInCollection() {
        return this.unchanged;
    }

    public void add(String ... strings) {
        if (strings != null) {
            for (String string : strings) {
                this.addSingleString(string);
            }
        }
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean newValue) {
        this.ignoreCase = newValue;
    }

    protected void addSingleString(String string) {
        if (string != null) {
            String[] newArray = this.getInternalStrings() == null ? new String[]{string} : this.str().append(this.getInternalStrings(), string);
            this.setInternalStrings(newArray);
        }
    }

    protected String[] getInternalStrings() {
        return this.internalStrings;
    }

    protected void setInternalStrings(String[] newValue) {
        this.internalStrings = newValue;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

