/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.security.SecureRandom;
import java.util.Random;
import org.pfsw.text.StringGenerator;

public class RandomStringGenerator
implements StringGenerator {
    private static final char[] DEFAULT_ALLOWED_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    public static final int DEFAULT_LENGTH = 10;
    private char[] allowedCharsArray = DEFAULT_ALLOWED_CHARS;
    private int defaultLength = 10;
    private final Random random;

    public RandomStringGenerator() {
        this(new SecureRandom());
    }

    public RandomStringGenerator(int defaultLength) {
        this();
        this.setDefaultLength(defaultLength);
    }

    public RandomStringGenerator(Random random) {
        this.random = random;
    }

    @Override
    public String generateString(int length) {
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            buffer.append(this.nextChar());
        }
        return buffer.toString();
    }

    @Override
    public String generateString() {
        return this.generateString(this.getDefaultLength());
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("The default length cannot be set to a negative of zero value: " + length);
        }
        this.defaultLength = length;
    }

    public String getAllowedCharacters() {
        return new String(this.getAllowedCharsArray());
    }

    public void setAllowedCharacters(String allowedChars) {
        if (allowedChars == null) {
            throw new IllegalArgumentException("The set of allowed characters must not be null.");
        }
        this.setAllowedCharsArray(allowedChars.toCharArray());
    }

    protected Object nextChar() {
        int index = this.nextIndex();
        return Character.valueOf(this.getAllowedCharsArray()[index]);
    }

    protected int nextIndex() {
        return this.getRandom().nextInt(this.getAllowedCharsSize());
    }

    protected Random getRandom() {
        return this.random;
    }

    protected char[] getAllowedCharsArray() {
        return this.allowedCharsArray;
    }

    protected void setAllowedCharsArray(char[] charArray) {
        this.allowedCharsArray = charArray;
    }

    private int getAllowedCharsSize() {
        return this.getAllowedCharsArray().length;
    }
}

