/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.util.concurrent.atomic.AtomicLong;
import org.pfsw.bif.identifier.IObjectIdGenerator;
import org.pfsw.text.StringGenerator;
import org.pfsw.text.StringUtil;

public class ObjectIdGenerator
implements IObjectIdGenerator,
StringGenerator {
    protected static final char DEFAULT_PAD_CHAR = '0';
    protected static final long DEFAULT_START_ID = 1L;
    protected static final int DEFAULT_LENGTH = 10;
    private int length = 10;
    private char padChar = (char)48;
    private String prefix = null;
    private final AtomicLong nextIdHolder = new AtomicLong(1L);

    public ObjectIdGenerator() {
        this.setLength(this.getDefaultLength());
        this.setNextId(this.getDefaultStartId());
        this.setPadChar(this.getDefaultPadChar());
    }

    public ObjectIdGenerator(int idLength) {
        this();
        this.setLength(idLength);
    }

    public ObjectIdGenerator(long startId, int idLength) {
        this(idLength);
        this.setNextId(startId);
    }

    public String newIdentifier() {
        return this.leftPad(this.nextIdentifier());
    }

    public synchronized long nextIdentifier() {
        return this.getNextIdHolder().getAndIncrement();
    }

    public boolean hasPadding() {
        return this.getLength() > 0;
    }

    public int getFullLength() {
        if (this.hasPadding()) {
            return this.getPrefixLength() + this.getLength();
        }
        return this.getPrefixLength() + Long.toString(this.getNextId()).length();
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int len) {
        this.length = len;
    }

    public void setPadChar(char fillChar) {
        this.padChar = fillChar;
    }

    public char getPadChar() {
        return this.padChar;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String newValue) {
        this.prefix = newValue;
    }

    public boolean hasPrefix() {
        return this.getPrefix() != null;
    }

    @Override
    public String generateString() {
        return this.newIdentifier();
    }

    @Override
    public String generateString(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("The length for a newly generated string must not be negative: " + len);
        }
        int lengthWithoutPrefix = len - this.getPrefixLength();
        if (lengthWithoutPrefix <= 0) {
            throw new IllegalArgumentException("The underlying prefix is too long for the given length. No space left for any generated string part. Prefix: " + this.getPrefix());
        }
        String string = this.leftPad(this.nextIdentifier(), lengthWithoutPrefix);
        return string;
    }

    protected int getPrefixLength() {
        if (this.hasPrefix()) {
            return this.getPrefix().length();
        }
        return 0;
    }

    protected String leftPad(long id) {
        return this.leftPad(id, this.getLength());
    }

    protected String leftPad(long id, int stringLength) {
        StringBuffer buffer = new StringBuffer(100);
        if (this.hasPrefix()) {
            buffer.append(this.getPrefix());
        }
        if (stringLength > 0) {
            this.str().leftPadCh(buffer, id, stringLength, this.getPadChar());
        } else {
            buffer.append(id);
        }
        return buffer.toString();
    }

    protected synchronized long getNextId() {
        return this.getNextIdHolder().get();
    }

    protected synchronized void setNextId(long id) {
        this.getNextIdHolder().set(id);
    }

    protected long getDefaultStartId() {
        return 1L;
    }

    protected int getDefaultLength() {
        return 10;
    }

    protected char getDefaultPadChar() {
        return '0';
    }

    protected AtomicLong getNextIdHolder() {
        return this.nextIdHolder;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

