/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import org.pfsw.bif.conversion.IIntegerRepresentation;
import org.pfsw.bif.conversion.ILongRepresentation;
import org.pfsw.bif.text.IStringRepresentation;

public class NaturalNumber
extends Number
implements Comparable<NaturalNumber>,
IStringRepresentation,
ILongRepresentation,
IIntegerRepresentation {
    private final Long numberValue;

    public static NaturalNumber valueOf(long value) {
        return new NaturalNumber(value);
    }

    public static NaturalNumber valueOf(int value) {
        return new NaturalNumber(value);
    }

    public static NaturalNumber parse(String value) {
        return new NaturalNumber(value);
    }

    public NaturalNumber(long value) {
        this.numberValue = value;
    }

    public NaturalNumber(int value) {
        this((long)value);
    }

    public NaturalNumber(String value) {
        this(Long.parseLong(value));
    }

    @Override
    public double doubleValue() {
        return this.getNumberValue().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.getNumberValue().floatValue();
    }

    @Override
    public int intValue() {
        return this.getNumberValue().intValue();
    }

    @Override
    public long longValue() {
        return this.getNumberValue();
    }

    public String asString() {
        return this.getNumberValue().toString();
    }

    public Long asLong() {
        return this.getNumberValue();
    }

    public Integer asInteger() {
        return this.intValue();
    }

    public boolean isPositive() {
        return this.longValue() > 0L;
    }

    public boolean isNegative() {
        return this.longValue() < 0L;
    }

    public int hashCode() {
        return this.getNumberValue().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == NaturalNumber.class) {
            NaturalNumber other = (NaturalNumber)obj;
            return this.getNumberValue().equals(other.getNumberValue());
        }
        return false;
    }

    @Override
    public int compareTo(NaturalNumber other) {
        return this.getNumberValue().compareTo(other.getNumberValue());
    }

    public String toString() {
        return String.format("%s(%d)", this.getClass().getSimpleName(), this.getNumberValue());
    }

    protected Long getNumberValue() {
        return this.numberValue;
    }
}

