/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.pfsw.bif.conversion.IIntegerRepresentation;
import org.pfsw.bif.text.IStringRepresentation;

class MatchRuleTypeConverter {
    public Object convertToType(Object object, Object type) {
        if (object instanceof String) {
            return this.convertToType((String)object, type);
        }
        if (object instanceof Collection) {
            return this.convertToType((Collection)object, type);
        }
        if (object instanceof Object[]) {
            return this.convertToType((Object[])object, type);
        }
        if (object instanceof Integer && type == Long.class) {
            return this.convertToLong((Integer)object);
        }
        if (object instanceof IIntegerRepresentation) {
            return this.convertToType(((IIntegerRepresentation)object).asInteger(), type);
        }
        if (object instanceof IStringRepresentation) {
            return this.convertToType(((IStringRepresentation)object).asString(), type);
        }
        return object;
    }

    public Object convertToType(String strValue, Object type) {
        if (strValue == null) {
            return null;
        }
        if (type == Integer.class) {
            return this.convertToInteger(strValue);
        }
        if (type == Long.class) {
            return this.convertToLong(strValue);
        }
        if (type instanceof SimpleDateFormat) {
            return this.convertToDate(strValue, (SimpleDateFormat)type);
        }
        if (type == Float.class) {
            return this.convertToFloat(strValue);
        }
        if (type == Double.class) {
            return this.convertToDouble(strValue);
        }
        if (type == BigDecimal.class) {
            return this.convertToBigDecimal(strValue);
        }
        throw new IllegalArgumentException("Type " + type + " not supported.");
    }

    public Collection convertToType(Collection<?> collection, Object type) {
        if (this.isNullOrEmpty(collection)) {
            return null;
        }
        Collection result = this.newCollectionOfType(collection.getClass());
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            Object element = this.convertToType(iter.next(), type);
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public Object[] convertToType(Object[] values, Object type) {
        if (values == null) {
            return null;
        }
        Object[] result = type instanceof SimpleDateFormat ? this.newArrayOfType(Date.class, values.length) : this.newArrayOfType((Class)type, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.convertToType(values[i], type);
        }
        return result;
    }

    public Float convertToFloat(String strValue) {
        return Float.valueOf(strValue);
    }

    public Double convertToDouble(String strValue) {
        return Double.valueOf(strValue);
    }

    public BigDecimal convertToBigDecimal(String strValue) {
        return new BigDecimal(strValue);
    }

    public Integer convertToInteger(String str) {
        return Integer.valueOf(str);
    }

    public Long convertToLong(String str) {
        return Long.valueOf(str);
    }

    public Date convertToDate(String strValue, SimpleDateFormat dateFormat) {
        try {
            return dateFormat.parse(strValue);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to convert '" + strValue + "' to Date with format \"" + dateFormat.toPattern() + "\"");
        }
    }

    public Long[] convertToLong(Integer[] intValues) {
        Long[] longValues = new Long[intValues.length];
        for (int i = 0; i < intValues.length; ++i) {
            longValues[i] = this.convertToLong(intValues[i]);
        }
        return longValues;
    }

    public Long convertToLong(Integer intValue) {
        return new Long(intValue.longValue());
    }

    protected Collection newCollectionOfType(Class collectionType) {
        try {
            return (Collection)collectionType.newInstance();
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    protected Object[] newArrayOfType(Class elementType, int length) {
        return (Object[])Array.newInstance(elementType, length);
    }

    protected boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    protected boolean isNullOrEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    protected void addAll(Collection<Object> collection, Object[] array) {
        if (collection != null && array != null) {
            for (int i = 0; i < array.length; ++i) {
                collection.add(array[i]);
            }
        }
    }
}

