/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.io.Serializable;
import java.util.Map;
import org.pfsw.text.DefaultMatchRuleParser;
import org.pfsw.text.MatchGroup;
import org.pfsw.text.MatchRuleChars;
import org.pfsw.text.MatchRuleException;
import org.pfsw.text.MatchRuleParseException;
import org.pfsw.text.MatchRulePrinter;
import org.pfsw.text.MatchRuleVisitor;

public class MatchRule
implements Serializable {
    private static final long serialVersionUID = 822423687986210525L;
    private MatchGroup rootGroup = null;
    private boolean ignoreCase = false;
    private boolean ignoreCaseInNames = false;
    private transient DefaultMatchRuleParser parser = null;
    private boolean multiCharWildcardMatchesEmptyString = false;

    public MatchRule() {
    }

    public MatchRule(boolean ignoreCase) {
        this();
        this.setIgnoreCase(ignoreCase);
    }

    public MatchRule(String rule) throws MatchRuleParseException {
        this(rule, null);
    }

    public MatchRule(MatchGroup aGroup) {
        this();
        this.setRootGroup(aGroup);
    }

    public MatchRule(String rule, MatchRuleChars charSet) throws MatchRuleParseException {
        this();
        this.parseRule(rule, charSet);
    }

    public void setRule(String rule) throws MatchRuleParseException {
        this.parseRule(rule, null);
        this.ignoreCase(this.getIgnoreCase());
    }

    public void ignoreCase(boolean ignoreIt) {
        this.getRootGroup().ignoreCase(ignoreIt);
        this.setIgnoreCase(ignoreIt);
    }

    public void ignoreCaseInNames(boolean ignoreIt) {
        this.getRootGroup().ignoreCaseInName(ignoreIt);
        this.setIgnoreCaseInNames(ignoreIt);
    }

    public void multiCharWildcardMatchesEmptyString(boolean yesOrNo) {
        this.getRootGroup().multiCharWildcardMatchesEmptyString(yesOrNo);
        this.setMultiCharWildcardMatchesEmptyString(yesOrNo);
    }

    public void mergeAnd(MatchRule rule) {
        MatchGroup group = null;
        group = rule.getRootGroup();
        if (group != null) {
            group.setAnd(true);
            this.appendGroup(group);
        }
    }

    public void mergeOr(MatchRule rule) {
        MatchGroup group = null;
        group = rule.getRootGroup();
        if (group != null) {
            group.setAnd(false);
            this.appendGroup(group);
        }
    }

    public boolean matches(Map<String, ?> dictionary) {
        return this.getRootGroup().matches(dictionary);
    }

    public String toString() {
        if (this.getRootGroup() == null) {
            return "null";
        }
        MatchRulePrinter printer = new MatchRulePrinter(this.parser().getRuleChars());
        return printer.asString(this);
    }

    public void apply(MatchRuleVisitor visitor) {
        visitor.walkThroughInit();
        this.getRootGroup().apply(visitor);
        visitor.walkThroughFinished();
    }

    public void optimize() {
        this.getRootGroup().optimize();
    }

    public void setDatatypes(Map<String, Class<?>> datatypes) throws MatchRuleException {
        if (datatypes != null) {
            this.getRootGroup().applyDatatypes(datatypes);
        }
    }

    protected DefaultMatchRuleParser parser() {
        if (this.getParser() == null) {
            this.setParser(new DefaultMatchRuleParser());
        }
        return this.getParser();
    }

    protected void parseRule(String rule, MatchRuleChars charSet) throws MatchRuleParseException {
        if (charSet != null) {
            this.setParser(new DefaultMatchRuleParser(charSet));
        }
        MatchGroup group = this.parser().parseToGroup(rule);
        this.setRootGroup(group);
    }

    protected void appendGroup(MatchGroup group) {
        MatchGroup newRoot = null;
        newRoot = new MatchGroup();
        newRoot.getElements().add(this.getRootGroup());
        newRoot.getElements().add(group);
        this.setRootGroup(newRoot);
    }

    protected MatchGroup getRootGroup() {
        return this.rootGroup;
    }

    protected void setRootGroup(MatchGroup newValue) {
        this.rootGroup = newValue;
    }

    protected boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected void setIgnoreCase(boolean newValue) {
        this.ignoreCase = newValue;
    }

    protected boolean getIgnoreCaseInNames() {
        return this.ignoreCaseInNames;
    }

    protected DefaultMatchRuleParser getParser() {
        return this.parser;
    }

    protected void setParser(DefaultMatchRuleParser newValue) {
        this.parser = newValue;
    }

    protected boolean getMultiCharWildcardMatchesEmptyString() {
        return this.multiCharWildcardMatchesEmptyString;
    }

    private void setIgnoreCaseInNames(boolean newValue) {
        this.ignoreCaseInNames = newValue;
    }

    private void setMultiCharWildcardMatchesEmptyString(boolean newValue) {
        this.multiCharWildcardMatchesEmptyString = newValue;
    }
}

