/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pfsw.text.MatchAttribute;
import org.pfsw.text.MatchElement;
import org.pfsw.text.MatchRuleException;
import org.pfsw.text.MatchRuleVisitor;
import org.pfsw.text.StringPattern;

public class MatchGroup
extends MatchElement {
    private static final long serialVersionUID = -4978135628713548031L;
    private List<MatchElement> elements = null;

    public MatchGroup() {
        this.setElements(this.newElementList());
    }

    public void addElement(MatchElement element) {
        this.getElements().add(element);
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    public int elementCount() {
        return this.getElements().size();
    }

    protected MatchElement getElement(int index) {
        return this.getElements().get(index);
    }

    @Override
    protected boolean doMatch(Map<String, ?> dictionary) {
        Iterator<MatchElement> iterator = null;
        MatchElement element2 = null;
        boolean matched = true;
        boolean isFirst = true;
        for (MatchElement element2 : this.getElements()) {
            if (isFirst) {
                isFirst = false;
                matched = element2.matches(dictionary);
                continue;
            }
            if (element2.getAnd()) {
                matched = matched && element2.matches(dictionary);
                continue;
            }
            matched = matched || element2.matches(dictionary);
        }
        return matched;
    }

    @Override
    protected void ignoreCase(boolean ignoreIt) {
        for (int i = 0; i < this.getElements().size(); ++i) {
            this.getElement(i).ignoreCase(ignoreIt);
        }
    }

    @Override
    public void ignoreCaseInName(boolean ignoreIt) {
        for (int i = 0; i < this.getElements().size(); ++i) {
            this.getElement(i).ignoreCaseInName(ignoreIt);
        }
    }

    @Override
    protected void multiCharWildcardMatchesEmptyString(boolean yesOrNo) {
        for (int i = 0; i < this.getElements().size(); ++i) {
            this.getElement(i).multiCharWildcardMatchesEmptyString(yesOrNo);
        }
    }

    @Override
    protected void apply(MatchRuleVisitor visitor) {
        visitor.startGroup(this.getAnd(), this.getNot());
        for (int i = 0; i < this.getElements().size(); ++i) {
            this.getElement(i).apply(visitor);
        }
        visitor.endGroup();
    }

    @Override
    protected void applyDatatypes(Map<String, Class<?>> datatypes) throws MatchRuleException {
        for (int i = 0; i < this.getElements().size(); ++i) {
            this.getElement(i).applyDatatypes(datatypes);
        }
    }

    protected void optimize() {
        for (int i = 0; i < this.elementCount(); ++i) {
            if (this.getElement(i).isAttribute()) {
                this.optimizeAttribute(i);
                continue;
            }
            MatchGroup group = (MatchGroup)this.getElement(i);
            group.optimize();
        }
    }

    protected void optimizeAttribute(int index) {
        int i;
        ArrayList<StringPattern> patterns = null;
        boolean optimized = false;
        boolean done = false;
        if (!this.getElement(index).isAttribute()) {
            return;
        }
        MatchAttribute attr = (MatchAttribute)this.getElement(index);
        for (i = index + 1; !done && i < this.elementCount(); ++i) {
            MatchAttribute otherAttr;
            done = true;
            if (!this.getElement(i).isAttribute() || (otherAttr = (MatchAttribute)this.getElement(i)).getNot() || otherAttr.getAnd() || !attr.getAttributeName().equals(otherAttr.getAttributeName())) continue;
            done = false;
            if (!optimized) {
                optimized = true;
                patterns = new ArrayList<StringPattern>(attr.getPatterns().length + otherAttr.getPatterns().length);
                this.addAll(patterns, attr.getPatterns());
            }
            this.addAll((Collection<StringPattern>)patterns, otherAttr.getPatterns());
        }
        if (optimized && patterns != null) {
            attr.setPatterns(patterns.toArray(new StringPattern[patterns.size()]));
            this.removeElements(index + 1, i - 1);
        }
    }

    protected void addAll(Collection<StringPattern> coll, StringPattern[] patternArray) {
        for (int i = 0; i < patternArray.length; ++i) {
            coll.add(patternArray[i]);
        }
    }

    protected void removeElements(int from, int to) {
        List<MatchElement> list = this.newElementList();
        for (int i = 0; i < this.elementCount(); ++i) {
            if (i >= from && i <= to) continue;
            list.add(this.getElement(i));
        }
        this.setElements(list);
    }

    protected List<MatchElement> newElementList() {
        return new ArrayList<MatchElement>();
    }

    protected List<MatchElement> getElements() {
        return this.elements;
    }

    protected void setElements(List<MatchElement> newValue) {
        this.elements = newValue;
    }
}

