/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pfsw.bif.conversion.IIntegerRepresentation;
import org.pfsw.bif.text.IStringRepresentation;
import org.pfsw.text.MatchElement;
import org.pfsw.text.MatchRuleCompareOperator;
import org.pfsw.text.MatchRuleException;
import org.pfsw.text.MatchRuleTypeConverter;
import org.pfsw.text.MatchRuleVisitor;
import org.pfsw.text.StringPattern;

public class MatchAttribute
extends MatchElement {
    private static final long serialVersionUID = -8277461956122062665L;
    private static MatchRuleTypeConverter TYPE_CONVERTER = new MatchRuleTypeConverter();
    private MatchRuleCompareOperator operator = MatchRuleCompareOperator.OPERATOR_EQUALS;
    private String attributeName = null;
    private StringPattern[] patterns = null;
    private boolean ignoreCaseInName = false;
    private Object valueType = null;
    private Float[] floatValues = null;
    private Double[] doubleValues = null;
    private BigDecimal[] bigDecimalValues = null;
    private Integer[] integerValues = null;
    private Long[] longValues = null;
    private Date[] dateValues = null;

    public MatchAttribute() {
    }

    public MatchAttribute(String name) {
        this.setAttributeName(name);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String newValue) {
        this.attributeName = newValue;
    }

    public StringPattern[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(StringPattern[] newValue) {
        this.patterns = newValue;
    }

    public boolean ignoreCaseInName() {
        return this.ignoreCaseInName;
    }

    @Override
    public boolean isAttribute() {
        return true;
    }

    public void setPattern(StringPattern aPattern) {
        StringPattern[] p = new StringPattern[]{aPattern};
        this.setPatterns(p);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(40);
        boolean hasValueList = false;
        if (this.getNot()) {
            str.append('!');
        }
        str.append(this.getAttributeName());
        boolean bl = hasValueList = this.getPatterns().length > 1;
        if (hasValueList) {
            str.append('{');
            for (int i = 0; i < this.getPatterns().length; ++i) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(this.getPatterns()[i].getPattern());
            }
            str.append('}');
        } else {
            switch (this.operator()) {
                case OPERATOR_EQUALS: {
                    str.append('=');
                    break;
                }
                case OPERATOR_GREATER: {
                    str.append('>');
                    break;
                }
                case OPERATOR_GREATER_OR_EQUAL: {
                    str.append('>');
                    str.append('=');
                    break;
                }
                case OPERATOR_LESS: {
                    str.append('<');
                    break;
                }
                case OPERATOR_LESS_OR_EQUAL: {
                    str.append('<');
                    str.append('=');
                }
            }
            str.append(this.getPatterns()[0].toString());
        }
        return str.toString();
    }

    public void setEqualsOperator() {
        this.operator(MatchRuleCompareOperator.OPERATOR_EQUALS);
    }

    public void setGreaterOperator() {
        this.operator(MatchRuleCompareOperator.OPERATOR_GREATER);
    }

    public void setLessOperator() {
        this.operator(MatchRuleCompareOperator.OPERATOR_LESS);
    }

    public void setGreaterOrEqualOperator() {
        this.operator(MatchRuleCompareOperator.OPERATOR_GREATER_OR_EQUAL);
    }

    public void setLessOrEqualOperator() {
        this.operator(MatchRuleCompareOperator.OPERATOR_LESS_OR_EQUAL);
    }

    public void setDatatype(Object type) throws MatchRuleException {
        if (type == null || type == String.class) {
            this.setValueType(null);
            return;
        }
        this.convertToType(type);
        this.setValueType(type);
    }

    @Override
    protected boolean doMatch(Map<String, ?> dictionary) {
        Object value = null;
        value = this.valueInMap(dictionary);
        if (value == null) {
            return false;
        }
        if (this.isTyped()) {
            return this.doTypedMatch(value);
        }
        if (value instanceof String) {
            return this.matchValue(value);
        }
        if (value instanceof String[]) {
            return this.matchValueArray((Object[])value);
        }
        if (value instanceof Collection) {
            return this.matchValueCollection((Collection)value);
        }
        if (value instanceof Integer) {
            return this.matchValue(value);
        }
        if (value instanceof IIntegerRepresentation) {
            return this.matchValue(value);
        }
        if (value instanceof Integer[]) {
            return this.matchValueArray((Object[])value);
        }
        if (value instanceof IStringRepresentation) {
            return this.matchValue(value);
        }
        return false;
    }

    protected boolean doTypedMatch(Object object) {
        Object value = object;
        if (!this.isCorrectType(value)) {
            value = TYPE_CONVERTER.convertToType(object, this.getValueType());
        }
        if (this.isCorrectType(value)) {
            try {
                if (this.getValueType() == Float.class) {
                    return this.doFloatMatch(value);
                }
                if (this.getValueType() == Double.class) {
                    return this.doDoubleMatch(value);
                }
                if (this.getValueType() == BigDecimal.class) {
                    return this.doBigDecimalMatch(value);
                }
                if (this.getValueType() == Integer.class) {
                    return this.doIntegerMatch(value);
                }
                if (this.getValueType() == Long.class) {
                    return this.doLongMatch(value);
                }
                if (this.getValueType() instanceof SimpleDateFormat) {
                    return this.doDateMatch(value);
                }
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        return false;
    }

    protected boolean isCorrectType(Object value) {
        if (this.getValueType() instanceof SimpleDateFormat && value.getClass() == Date.class) {
            return true;
        }
        return this.getValueType() == this.getTypeOf(value);
    }

    protected boolean doFloatMatch(Object value) {
        Float[] dataValues = this.toArray(value, Float.class);
        for (int i = 0; i < dataValues.length; ++i) {
            if (!this.matchValueAgainstValues(dataValues[i], this.floatValues)) continue;
            return true;
        }
        return false;
    }

    protected boolean doDoubleMatch(Object value) {
        Double[] dataValues = this.toArray(value, Double.class);
        for (int i = 0; i < dataValues.length; ++i) {
            if (!this.matchValueAgainstValues(dataValues[i], this.doubleValues)) continue;
            return true;
        }
        return false;
    }

    protected boolean doBigDecimalMatch(Object value) {
        BigDecimal[] dataValues = this.toArray(value, BigDecimal.class);
        for (int i = 0; i < dataValues.length; ++i) {
            if (!this.matchValueAgainstValues(dataValues[i], this.bigDecimalValues)) continue;
            return true;
        }
        return false;
    }

    protected boolean doIntegerMatch(Object value) {
        Integer[] dataValues = this.toArray(value, Integer.class);
        for (int i = 0; i < dataValues.length; ++i) {
            if (!this.matchValueAgainstValues(dataValues[i], this.integerValues)) continue;
            return true;
        }
        return false;
    }

    protected boolean doLongMatch(Object value) {
        Long[] dataValues = this.toArray(value, Long.class);
        for (int i = 0; i < dataValues.length; ++i) {
            if (!this.matchValueAgainstValues(dataValues[i], this.longValues)) continue;
            return true;
        }
        return false;
    }

    protected boolean doDateMatch(Object value) {
        Date[] dataValues = this.toArray(value, Date.class);
        for (int i = 0; i < dataValues.length; ++i) {
            if (!this.matchValueAgainstValues(dataValues[i], this.dateValues)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchValueArray(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!this.matchValue(values[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean matchValueCollection(Collection<?> values) {
        for (Object value : values) {
            try {
                if (!this.matchValue(value)) continue;
                return true;
            }
            catch (Throwable t) {
            }
        }
        return false;
    }

    protected boolean matchValue(Object value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.getPatterns().length; ++i) {
            Integer intValue;
            String strValue;
            StringPattern pattern = this.getPatterns()[i];
            if (!(this.operator() == MatchRuleCompareOperator.OPERATOR_EQUALS && pattern.hasWildcard() ? pattern.matches(strValue = this.objectAsString(value)) : ((intValue = this.objectAsInteger(value)) != null ? this.compare(intValue, pattern.toString()) : this.compare(strValue = this.objectAsString(value), pattern.toString(), pattern.getIgnoreCase())))) continue;
            return true;
        }
        return false;
    }

    protected <T> boolean matchValueAgainstValues(Comparable<T> value, T[] values) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            int result = value.compareTo(values[i]);
            if (!this.compareIntegers(result, 0)) continue;
            return true;
        }
        return false;
    }

    protected boolean compare(String value, String ruleValue, boolean ignoreCase) {
        int result = ignoreCase ? value.compareToIgnoreCase(ruleValue) : value.compareTo(ruleValue);
        return this.compareIntegers(result, 0);
    }

    protected boolean compare(Integer value, String ruleValue) {
        int ruleIntValue;
        try {
            ruleIntValue = Integer.parseInt(ruleValue);
        }
        catch (RuntimeException e) {
            return false;
        }
        return this.compareIntegers(value, ruleIntValue);
    }

    protected boolean compareIntegers(int a, int b) {
        switch (this.operator()) {
            case OPERATOR_EQUALS: {
                return a == b;
            }
            case OPERATOR_GREATER_OR_EQUAL: {
                return a >= b;
            }
            case OPERATOR_LESS_OR_EQUAL: {
                return a <= b;
            }
            case OPERATOR_GREATER: {
                return a > b;
            }
            case OPERATOR_LESS: {
                return a < b;
            }
        }
        return false;
    }

    @Override
    protected void ignoreCase(boolean ignoreIt) {
        for (int i = 0; i < this.getPatterns().length; ++i) {
            this.getPatterns()[i].setIgnoreCase(ignoreIt);
        }
    }

    @Override
    protected void multiCharWildcardMatchesEmptyString(boolean yesOrNo) {
        for (int i = 0; i < this.getPatterns().length; ++i) {
            this.getPatterns()[i].multiCharWildcardMatchesEmptyString(yesOrNo);
        }
    }

    @Override
    protected void apply(MatchRuleVisitor visitor) {
        String[] values = new String[this.getPatterns().length];
        for (int i = 0; i < this.getPatterns().length; ++i) {
            values[i] = this.getPatterns()[i].getPattern();
        }
        visitor.attribute(this.getAttributeName(), this.operator(), values, this.getAnd(), this.getNot());
    }

    protected Object valueInMap(Map<String, ?> map) {
        String attrName = this.nameOfAttribute(map);
        if (attrName == null) {
            return null;
        }
        return map.get(attrName);
    }

    protected String nameOfAttribute(Map<String, ?> map) {
        String name = this.getAttributeName();
        if (this.ignoreCaseInName()) {
            Set<String> keyNames = map.keySet();
            for (String key : keyNames) {
                if (!name.equalsIgnoreCase(key)) continue;
                return key;
            }
            name = null;
        }
        return name;
    }

    protected void convertToType(Object type) throws MatchRuleException {
        String[] strValues = new String[this.getPatterns().length];
        for (int i = 0; i < this.getPatterns().length; ++i) {
            strValues[i] = this.getPatterns()[i].getPattern();
        }
        if (type == Float.class) {
            this.convertToFloat(strValues);
            return;
        }
        if (type == Double.class) {
            this.convertToDouble(strValues);
            return;
        }
        if (type == BigDecimal.class) {
            this.convertToBigDecimal(strValues);
            return;
        }
        if (type == Integer.class) {
            this.convertToInteger(strValues);
            return;
        }
        if (type == Long.class) {
            this.convertToLong(strValues);
            return;
        }
        if (type instanceof SimpleDateFormat) {
            this.convertToDate(strValues, (SimpleDateFormat)type);
            return;
        }
        throw new MatchRuleException("Type " + type + " not supported.");
    }

    protected void convertToFloat(String[] strValues) throws MatchRuleException {
        this.floatValues = new Float[strValues.length];
        for (int i = 0; i < strValues.length; ++i) {
            try {
                this.floatValues[i] = Float.valueOf(strValues[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], Float.class);
            }
        }
    }

    protected void convertToDouble(String[] strValues) throws MatchRuleException {
        this.doubleValues = new Double[strValues.length];
        for (int i = 0; i < strValues.length; ++i) {
            try {
                this.doubleValues[i] = Double.valueOf(strValues[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], Double.class);
            }
        }
    }

    protected void convertToBigDecimal(String[] strValues) throws MatchRuleException {
        this.bigDecimalValues = new BigDecimal[strValues.length];
        for (int i = 0; i < strValues.length; ++i) {
            try {
                this.bigDecimalValues[i] = new BigDecimal(strValues[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], BigDecimal.class);
            }
        }
    }

    protected void convertToInteger(String[] strValues) throws MatchRuleException {
        this.integerValues = new Integer[strValues.length];
        for (int i = 0; i < strValues.length; ++i) {
            try {
                this.integerValues[i] = Integer.valueOf(strValues[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], Integer.class);
            }
        }
    }

    protected void convertToLong(String[] strValues) throws MatchRuleException {
        this.longValues = new Long[strValues.length];
        for (int i = 0; i < strValues.length; ++i) {
            try {
                this.longValues[i] = Long.valueOf(strValues[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw this.createTypeConversionException(strValues[i], Long.class);
            }
        }
    }

    protected void convertToDate(String[] strValues, SimpleDateFormat dateFormat) throws MatchRuleException {
        this.dateValues = new Date[strValues.length];
        for (int i = 0; i < strValues.length; ++i) {
            try {
                this.dateValues[i] = dateFormat.parse(strValues[i]);
                continue;
            }
            catch (ParseException e) {
                throw new MatchRuleException("Unable to convert '" + strValues[i] + "' to Date with format \"" + dateFormat.toPattern() + "\" for attribute <" + this.getAttributeName() + ">");
            }
        }
    }

    protected MatchRuleException createTypeConversionException(String value, Class<?> type) {
        return new MatchRuleException("Unable to convert '%s' to %s for attribute <%s>", value, type, this.getAttributeName());
    }

    protected boolean isTyped() {
        return this.getValueType() != null;
    }

    protected Class<?> getTypeOf(Object object) {
        try {
            if (object instanceof List) {
                return ((List)object).get(0).getClass();
            }
            if (object instanceof Collection) {
                return ((Collection)object).iterator().next().getClass();
            }
            if (object.getClass().isArray()) {
                return object.getClass().getComponentType();
            }
            return object.getClass();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected <T> T[] toArray(Object object, Class<T> type) {
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            Object[] array = (Object[])Array.newInstance(type, coll.size());
            return coll.toArray(array);
        }
        if (object.getClass().isArray()) {
            return (Object[])object;
        }
        Object[] array = (Object[])Array.newInstance(type, 1);
        array[0] = object;
        return array;
    }

    @Override
    protected void applyDatatypes(Map<String, Class<?>> datatypes) throws MatchRuleException {
        this.setDatatype(this.valueInMap(datatypes));
    }

    protected String objectAsString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof IStringRepresentation) {
            IStringRepresentation str = (IStringRepresentation)object;
            return str.asString();
        }
        return object.toString();
    }

    private Integer objectAsInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof IIntegerRepresentation) {
            return ((IIntegerRepresentation)value).asInteger();
        }
        return null;
    }

    @Override
    protected void ignoreCaseInName(boolean newValue) {
        this.ignoreCaseInName = newValue;
    }

    protected Object getValueType() {
        return this.valueType;
    }

    protected void setValueType(Object newValue) {
        this.valueType = newValue;
    }

    protected MatchRuleCompareOperator operator() {
        return this.operator;
    }

    protected void operator(MatchRuleCompareOperator newValue) {
        this.operator = newValue;
    }
}

