/*
 * Decompiled with CFR 0.152.
 */
package org.pfsw.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.pfsw.text.MatchRule;
import org.pfsw.text.MatchRuleCompareOperator;
import org.pfsw.text.MatchRuleVisitor;

public class LdapMatchRuleVisitor
implements MatchRuleVisitor {
    private StringBuffer buffer = null;
    private GroupInfo rootGroup = null;
    private Stack<GroupInfo> stack = null;

    @Override
    public void walkThroughInit() {
        this.setBuffer(new StringBuffer(100));
        this.setStack(new Stack<GroupInfo>());
    }

    @Override
    public void walkThroughFinished() {
        this.appendGroup(this.getRootGroup());
    }

    @Override
    public void startGroup(boolean andOperator, boolean notOperator) {
        GroupInfo group = null;
        group = this.createGroup();
        group.not_flag = notOperator;
        if (this.isFirstGroup()) {
            this.setRootGroup(group);
        } else {
            this.addElementToCurrentGroup(group, andOperator);
        }
        this.push(group);
    }

    @Override
    public void endGroup() {
        this.pop();
    }

    @Override
    public void attribute(String name, MatchRuleCompareOperator compareOperator, String[] values, boolean andOperator, boolean notOperator) {
        AttributeInfo element = new AttributeInfo();
        element.name = name;
        element.operator = compareOperator;
        element.values = values;
        element.not_flag = notOperator;
        this.addElementToCurrentGroup(element, andOperator);
    }

    public String asSearchString(MatchRule matchRule) {
        matchRule.apply(this);
        return this.getBuffer().toString();
    }

    public void appendGroup(GroupInfo group) {
        if (group.not_flag) {
            this.getBuffer().append("(!");
        }
        if (group.neutral_elements == null) {
            this.appendGroupElements(group.and_elements, true);
            this.appendGroupElements(group.or_elements, false);
        } else {
            this.appendGroupElement(group.neutral_elements.get(0));
        }
        if (group.not_flag) {
            this.getBuffer().append(')');
        }
    }

    protected void appendGroupElement(ElementInfo element) {
        if (element.isGroupInfo()) {
            this.appendGroup((GroupInfo)element);
        } else {
            this.appendAttribute((AttributeInfo)element);
        }
    }

    protected void appendGroupElements(List<ElementInfo> elements, boolean andOperator) {
        if (elements.size() == 0) {
            return;
        }
        this.getBuffer().append('(');
        this.getBuffer().append(andOperator ? (char)'&' : '|');
        for (int i = 0; i < elements.size(); ++i) {
            this.appendGroupElement(elements.get(i));
        }
        this.getBuffer().append(')');
    }

    protected void appendAttribute(AttributeInfo element) {
        this.appendAttribute(element.name, element.operator, element.values, element.not_flag);
    }

    protected void appendAttribute(String name, MatchRuleCompareOperator operator, String[] values, boolean notOperator) {
        boolean manyValues = false;
        boolean bl = manyValues = values.length > 1;
        if (notOperator) {
            this.getBuffer().append("(!");
        }
        if (manyValues) {
            this.getBuffer().append("(|");
        }
        for (int i = 0; i < values.length; ++i) {
            this.appendAttribute(name, operator, values[i]);
        }
        if (manyValues) {
            this.getBuffer().append(")");
        }
        if (notOperator) {
            this.getBuffer().append(")");
        }
    }

    protected void appendAttribute(String name, MatchRuleCompareOperator operator, String value) {
        this.getBuffer().append('(');
        this.getBuffer().append(name);
        switch (operator) {
            case OPERATOR_EQUALS: {
                this.getBuffer().append('=');
                break;
            }
            case OPERATOR_GREATER_OR_EQUAL: {
                this.getBuffer().append(">=");
                break;
            }
            case OPERATOR_LESS_OR_EQUAL: {
                this.getBuffer().append("<=");
                break;
            }
            default: {
                this.getBuffer().append('=');
            }
        }
        this.getBuffer().append(value);
        this.getBuffer().append(')');
    }

    protected void addElementToCurrentGroup(ElementInfo element, boolean andOperator) {
        GroupInfo group = null;
        List<ElementInfo> groupSlot = null;
        group = this.currentGroup();
        List<ElementInfo> list = groupSlot = andOperator ? group.and_elements : group.or_elements;
        if (group.neutral_elements == null) {
            groupSlot.add(element);
        } else if (group.neutral_elements.size() == 0) {
            group.neutral_elements.add(element);
        } else {
            groupSlot.add(group.neutral_elements.get(0));
            groupSlot.add(element);
            group.neutral_elements = null;
        }
    }

    protected GroupInfo createGroup() {
        return new GroupInfo();
    }

    protected GroupInfo pop() {
        return this.getStack().pop();
    }

    protected void push(GroupInfo obj) {
        this.getStack().push(obj);
    }

    protected GroupInfo currentGroup() {
        return this.getStack().peek();
    }

    protected boolean isFirstGroup() {
        return this.getStack().empty();
    }

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(StringBuffer newValue) {
        this.buffer = newValue;
    }

    protected GroupInfo getRootGroup() {
        return this.rootGroup;
    }

    protected void setRootGroup(GroupInfo newValue) {
        this.rootGroup = newValue;
    }

    protected Stack<GroupInfo> getStack() {
        return this.stack;
    }

    protected void setStack(Stack<GroupInfo> newValue) {
        this.stack = newValue;
    }

    private class GroupInfo
    extends ElementInfo {
        protected List<ElementInfo> neutral_elements;
        protected List<ElementInfo> and_elements;
        protected List<ElementInfo> or_elements;

        private GroupInfo() {
            this.neutral_elements = new ArrayList<ElementInfo>();
            this.and_elements = new ArrayList<ElementInfo>();
            this.or_elements = new ArrayList<ElementInfo>();
        }

        @Override
        protected boolean isGroupInfo() {
            return true;
        }
    }

    private class ElementInfo {
        protected boolean not_flag = false;

        private ElementInfo() {
        }

        protected boolean isGroupInfo() {
            return false;
        }
    }

    private class AttributeInfo
    extends ElementInfo {
        protected String name = null;
        protected MatchRuleCompareOperator operator = MatchRuleCompareOperator.OPERATOR_EQUALS;
        protected String[] values = null;

        private AttributeInfo() {
        }
    }
}

